/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.components.transformation.sync;

import java.util.Iterator;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.papyrus.designer.components.FCM.Port;
import org.eclipse.papyrus.designer.components.transformation.Activator;
import org.eclipse.papyrus.designer.components.transformation.Messages;
import org.eclipse.papyrus.designer.components.transformation.PortInfo;
import org.eclipse.papyrus.designer.components.transformation.PortUtils;
import org.eclipse.papyrus.designer.components.transformation.component.PrefixConstants;
import org.eclipse.papyrus.designer.infra.base.CommandSupport;
import org.eclipse.papyrus.designer.transformation.base.utils.OperationSync;
import org.eclipse.papyrus.designer.transformation.core.sync.SyncBehaviorParameters;
import org.eclipse.papyrus.designer.transformation.core.transformations.UpdateUtils;
import org.eclipse.papyrus.designer.transformation.profile.Transformation.DerivedElement;
import org.eclipse.papyrus.designer.uml.tools.utils.ConnectorUtil;
import org.eclipse.papyrus.designer.uml.tools.utils.OperationUtils;
import org.eclipse.papyrus.designer.uml.tools.utils.RealizationUtils;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.BehavioralFeature;
import org.eclipse.uml2.uml.BehavioredClassifier;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.DirectedRelationship;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.EncapsulatedClassifier;
import org.eclipse.uml2.uml.Generalization;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.InterfaceRealization;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.util.UMLUtil;

public class CompImplSync {
    public static void syncViaInterface(Interface intf) {
        CompImplSync.syncViaInterface(intf, null);
    }

    public static void syncViaInterface(Interface intf, BehavioralFeature toBeRemoved) {
        for (DirectedRelationship relationship : intf.getTargetDirectedRelationships(UMLPackage.eINSTANCE.getInterfaceRealization())) {
            InterfaceRealization ir = (InterfaceRealization)relationship;
            BehavioredClassifier cl = ir.getImplementingClassifier();
            if (!(cl instanceof Class)) continue;
            Activator.log.info(String.format(Messages.CompImplSync_InfoSyncIntf, cl.getName()));
            Class implementation = (Class)cl;
            CompImplSync.interfaceModifications(implementation, toBeRemoved);
        }
    }

    public static boolean syncViaType(Class compType, boolean addOnly) {
        boolean foundGeneralization = false;
        for (DirectedRelationship relationship : compType.getTargetDirectedRelationships(UMLPackage.eINSTANCE.getGeneralization())) {
            if (!(relationship instanceof Generalization)) continue;
            foundGeneralization = true;
            Classifier cl = ((Generalization)relationship).getSpecific();
            if (!(cl instanceof Class)) continue;
            Class implementation = (Class)cl;
            CompImplSync.updatePorts(implementation);
            if (cl.isAbstract()) continue;
            if (addOnly) {
                CompImplSync.addRealizations(implementation);
                continue;
            }
            CompImplSync.syncRealizations(implementation);
        }
        return foundGeneralization;
    }

    public static void updatePorts(Class implementation) {
        for (org.eclipse.uml2.uml.Port port : PortUtils.getAllPorts((EncapsulatedClassifier)implementation)) {
            Port fcmPort = (Port)UMLUtil.getStereotypeApplication((Element)port, Port.class);
            if (fcmPort == null || port.eResource() != implementation.eResource()) continue;
            fcmPort.update();
        }
    }

    public static void syncRealizations(Class implementation) {
        EList<Interface> providedIntfs = CompImplSync.addRealizations(implementation);
        CompImplSync.removeRealizations(providedIntfs, implementation);
    }

    public static EList<Interface> addRealizations(Class implementation) {
        BasicEList providedIntfs = new BasicEList();
        for (PortInfo portInfo : PortUtils.flattenExtendedPorts(PortUtils.getAllPorts2((EncapsulatedClassifier)implementation))) {
            Interface providedIntf = portInfo.getProvided();
            String opName = PrefixConstants.getP_Prefix + portInfo.getName();
            if (implementation.getOwnedOperation(opName, null, null) != null) continue;
            ConnectorEnd connEnd = ConnectorUtil.getDelegation((Class)implementation, (org.eclipse.uml2.uml.Port)portInfo.getPort());
            if (providedIntf == null || connEnd != null) continue;
            if (providedIntfs.contains((Object)providedIntf)) {
                Activator.log.info("The interface " + providedIntf.getName() + " is provided by more than one port of class <" + implementation.getQualifiedName() + ">, inputs would therefore be undistinguishable");
            }
            providedIntfs.add((Object)providedIntf);
            InterfaceRealization ir = implementation.getInterfaceRealization(null, providedIntf);
            if (ir == null) {
                RealizationUtils.addRealization((Class)implementation, (Interface)providedIntf);
                continue;
            }
            String name = RealizationUtils.calcRealizationName((Interface)providedIntf);
            if (name.equals(ir.getName())) continue;
            ir.setName(name);
        }
        return providedIntfs;
    }

    private static void removeRealizations(EList<Interface> providedIntfs, Class implementation) {
        BasicEList toBeRemoved = new BasicEList();
        for (InterfaceRealization ir : implementation.getInterfaceRealizations()) {
            Interface inheritedIntf;
            String name = ir.getName();
            if (name == null || !name.startsWith("realization of ") || providedIntfs.contains((Object)(inheritedIntf = ir.getContract()))) continue;
            toBeRemoved.add((Object)ir);
        }
        if (toBeRemoved.size() > 0) {
            CommandSupport.exec((TransactionalEditingDomain)TransactionUtil.getEditingDomain((EObject)implementation), (String)Messages.CompImplSync_InfoSyncViaImpl, (Runnable)new Runnable((EList)toBeRemoved){
                private final /* synthetic */ EList val$toBeRemoved;
                {
                    this.val$toBeRemoved = eList;
                }

                @Override
                public void run() {
                    for (InterfaceRealization ir : this.val$toBeRemoved) {
                        ir.destroy();
                    }
                }
            });
        }
    }

    public static void interfaceModifications(Class implementation, BehavioralFeature toBeRemoved) {
        CompImplSync.syncDerivedOperations(implementation);
        EList ownedOperations = implementation.getOwnedOperations();
        for (Behavior behavior : implementation.getOwnedBehaviors()) {
            String name;
            BehavioralFeature sourceBf;
            BehavioralFeature bf = behavior.getSpecification();
            if (bf == null || !ownedOperations.contains((Object)bf) || (sourceBf = (BehavioralFeature)UpdateUtils.getSource((Element)bf)) == null || sourceBf == toBeRemoved || (name = CompImplSync.calcBehaviorName(sourceBf, (Classifier)implementation)).equals(behavior.getName())) continue;
            behavior.setName(name);
        }
    }

    public static void syncDerivedOperations(Class implementation) {
        BasicEList realizedInterfaces = new BasicEList();
        EList ownedOperations = implementation.getOwnedOperations();
        for (InterfaceRealization ir : implementation.getInterfaceRealizations()) {
            Interface intf = ir.getContract();
            if (intf == null) continue;
            realizedInterfaces.add((Object)intf);
            for (Operation operation : intf.getAllOperations()) {
                Operation copiedOperation = (Operation)UpdateUtils.getDerivedElement((EList)ownedOperations, (Element)operation);
                if (copiedOperation == null) {
                    copiedOperation = OperationUtils.getSameOperation((Operation)operation, (Class)implementation);
                    if (copiedOperation == null) {
                        copiedOperation = implementation.createOwnedOperation(operation.getName(), null, null);
                        OperationSync.sync((Operation)operation, (Operation)copiedOperation);
                        copiedOperation.setIsAbstract(false);
                    }
                    UpdateUtils.setSource((Element)copiedOperation, (Element)operation);
                    continue;
                }
                if (OperationUtils.isSameOperation((Operation)operation, (Operation)copiedOperation)) continue;
                OperationSync.sync((Operation)operation, (Operation)copiedOperation);
                copiedOperation.setIsAbstract(false);
            }
        }
        for (Behavior method : implementation.getOwnedBehaviors()) {
            SyncBehaviorParameters.syncParameters((Behavior)method);
        }
        Iterator ownedOpsIter = ownedOperations.iterator();
        while (ownedOpsIter.hasNext()) {
            Operation ownedOp = (Operation)ownedOpsIter.next();
            DerivedElement de = (DerivedElement)UMLUtil.getStereotypeApplication((Element)ownedOp, DerivedElement.class);
            if (de == null) continue;
            if (de.getSource() instanceof Operation) {
                Operation sourceOp = (Operation)de.getSource();
                boolean contains = false;
                for (Interface realizedIntf : realizedInterfaces) {
                    if (!realizedIntf.getAllOperations().contains((Object)sourceOp)) continue;
                    contains = true;
                }
                if (contains) continue;
                ownedOpsIter.remove();
                ownedOp.destroy();
                continue;
            }
            if (de.getSource() != null) continue;
            ownedOpsIter.remove();
            ownedOp.destroy();
        }
    }

    private static String calcBehaviorName(BehavioralFeature bf, Classifier cl) {
        return bf.getName();
    }
}

