/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.components.transformation.ui.dialogs;

import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.papyrus.designer.components.FCM.Port;
import org.eclipse.papyrus.designer.components.FCM.PortKind;
import org.eclipse.papyrus.designer.components.transformation.PortUtils;
import org.eclipse.papyrus.designer.components.transformation.ui.Messages;
import org.eclipse.papyrus.designer.components.transformation.ui.dialogs.PortLabelProvider;
import org.eclipse.papyrus.designer.uml.tools.utils.DescriptionUtils;
import org.eclipse.papyrus.designer.uml.tools.utils.PackageUtil;
import org.eclipse.papyrus.designer.uml.tools.utils.StereotypeUtil;
import org.eclipse.papyrus.infra.widgets.editors.TreeSelectorDialog;
import org.eclipse.papyrus.infra.widgets.toolbox.utils.DialogUtils;
import org.eclipse.papyrus.uml.tools.providers.ServiceEditFilteredContentProvider;
import org.eclipse.papyrus.uml.tools.providers.UMLLabelProvider;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SelectionStatusDialog;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.EncapsulatedClassifier;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.util.UMLUtil;

public class ConfigurePortDialog
extends SelectionStatusDialog {
    protected Class m_component;
    protected Text fDescription;
    protected TableViewer fPortList;
    protected org.eclipse.uml2.uml.Port m_currentPort;
    protected Combo fKindCombo;
    protected EList<PortKind> portKindList;
    protected Label fType;
    protected Button fTypeButton;
    protected Label fProvided;
    protected Label fRequired;
    protected Package m_model;
    protected EList<org.eclipse.uml2.uml.Port> m_ports;
    public static final String COLON = ":";

    public ConfigurePortDialog(Shell parent) {
        super(parent);
    }

    public boolean init(org.eclipse.uml2.uml.Port port) {
        this.m_component = port.getClass_();
        this.m_currentPort = port;
        this.m_model = PackageUtil.getRootPackage((Element)this.m_component);
        this.m_ports = PortUtils.getAllPorts((EncapsulatedClassifier)this.m_component);
        return true;
    }

    public boolean init(Class clazz) {
        this.m_component = clazz;
        this.m_model = PackageUtil.getRootPackage((Element)this.m_component);
        this.m_currentPort = null;
        this.m_ports = PortUtils.getAllPorts((EncapsulatedClassifier)this.m_component);
        return true;
    }

    protected void computeResult() {
    }

    public Control createDialogArea(Composite parent) {
        int index;
        Composite contents = (Composite)super.createDialogArea(parent);
        this.createPortConfigurationGroup(contents);
        if (this.m_currentPort != null && (index = this.m_ports.indexOf((Object)this.m_currentPort)) != -1) {
            this.fPortList.getTable().setSelection(index);
            this.selectPort(this.m_currentPort);
        }
        return contents;
    }

    protected void createPortConfigurationGroup(Composite parent) {
        GridData groupGridData = DialogUtils.createFillGridData();
        GridData gridData = DialogUtils.createFillGridData();
        GridData gridDataH80Span2 = DialogUtils.createFillGridData();
        gridDataH80Span2.horizontalSpan = 2;
        gridDataH80Span2.heightHint = 80;
        GridData gridDataH25Span2 = DialogUtils.createFillGridData();
        gridDataH25Span2.horizontalSpan = 2;
        gridDataH25Span2.heightHint = 25;
        GridData gridDataH60 = DialogUtils.createFillGridData();
        gridDataH60.heightHint = 60;
        GridData gridDataSpan2 = DialogUtils.createFillGridData();
        gridDataSpan2.horizontalSpan = 2;
        Group portSelection = new Group(parent, 2048);
        portSelection.setLayout((Layout)new GridLayout(1, false));
        portSelection.setText(" " + Messages.ConfigurePortDialog_AvailPorts + " ");
        portSelection.setLayoutData((Object)gridDataH60);
        this.fPortList = new TableViewer((Composite)portSelection, 2048);
        this.fPortList.setLabelProvider((IBaseLabelProvider)new PortLabelProvider());
        this.fPortList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fPortList.setInput((Object)this.m_ports.toArray());
        this.fPortList.getTable().setLayoutData((Object)gridDataH60);
        this.fPortList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object[] selected;
                ISelection selection = ConfigurePortDialog.this.fPortList.getSelection();
                if (selection instanceof StructuredSelection && (selected = ((StructuredSelection)selection).toArray()).length == 1 && selected[0] instanceof org.eclipse.uml2.uml.Port) {
                    ConfigurePortDialog.this.selectPort((org.eclipse.uml2.uml.Port)selected[0]);
                }
            }
        });
        portSelection.pack();
        Group instanceConfigurationGroup = new Group(parent, 2048);
        instanceConfigurationGroup.setText(" " + Messages.ConfigurePortDialog_AvailPorts + " ");
        instanceConfigurationGroup.setLayout((Layout)new GridLayout(2, false));
        instanceConfigurationGroup.setLayoutData((Object)groupGridData);
        Label kindText = new Label((Composite)instanceConfigurationGroup, 0);
        kindText.setText(Messages.ConfigurePortDialog_Kind + COLON);
        this.fKindCombo = new Combo((Composite)instanceConfigurationGroup, 0);
        this.portKindList = this.getAvailableKinds(this.m_model);
        if (this.portKindList.size() == 0) {
            MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"No port kinds founds", (String)"No port kinds are available. Please import a SW Designer model library");
        }
        String[] portKindStrList = new String[this.portKindList.size() + 1];
        portKindStrList[0] = Messages.ConfigurePortDialog_None;
        int i = 0;
        while (i < this.portKindList.size()) {
            portKindStrList[i + 1] = ((PortKind)this.portKindList.get(i)).getBase_Class().getName();
            ++i;
        }
        this.fKindCombo.setItems(portKindStrList);
        this.fKindCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Port fcmPort = (Port)StereotypeUtil.applyApp((Element)ConfigurePortDialog.this.m_currentPort, Port.class);
                if (fcmPort != null) {
                    int index = ConfigurePortDialog.this.fKindCombo.getSelectionIndex();
                    if (index > 0) {
                        PortKind kind = (PortKind)ConfigurePortDialog.this.portKindList.get(index - 1);
                        fcmPort.setKind(kind);
                        ConfigurePortDialog.this.selectPort(ConfigurePortDialog.this.m_currentPort);
                    } else {
                        StereotypeUtil.unapply((Element)ConfigurePortDialog.this.m_currentPort, Port.class);
                        ConfigurePortDialog.this.selectPort(ConfigurePortDialog.this.m_currentPort);
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label fTypeLabel = new Label((Composite)instanceConfigurationGroup, 0);
        fTypeLabel.setText(Messages.ConfigurePortDialog_Type + COLON);
        fTypeLabel.setLayoutData((Object)gridData);
        this.fType = new Label((Composite)instanceConfigurationGroup, 0);
        this.fType.setLayoutData((Object)gridData);
        this.fTypeButton = new Button((Composite)instanceConfigurationGroup, 0);
        this.fTypeButton.setText(Messages.ConfigurePortDialog_ChangeType);
        this.fTypeButton.setLayoutData((Object)gridDataH25Span2);
        this.fTypeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Object type;
                TreeSelectorDialog tsd = new TreeSelectorDialog(Display.getCurrent().getActiveShell());
                EReference feature = UMLPackage.eINSTANCE.getTypedElement_Type();
                ServiceEditFilteredContentProvider contentProvider = new ServiceEditFilteredContentProvider((EObject)ConfigurePortDialog.this.m_currentPort, (EStructuralFeature)feature, new EObject[]{ConfigurePortDialog.this.m_model});
                BasicEList wantedMetaClasses = new BasicEList();
                wantedMetaClasses.add((Object)feature.getEType());
                contentProvider.setWantedMetaclasses((List)wantedMetaClasses);
                contentProvider.setNotWantedMetaclasses(Collections.EMPTY_LIST);
                tsd.setContentProvider((ITreeContentProvider)contentProvider);
                tsd.setLabelProvider((ILabelProvider)new UMLLabelProvider());
                tsd.open();
                Object[] result = tsd.getResult();
                if (result != null && result.length == 1 && (type = result[0]) instanceof Type) {
                    ConfigurePortDialog.this.m_currentPort.setType((Type)type);
                    ConfigurePortDialog.this.selectPort(ConfigurePortDialog.this.m_currentPort);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Group derivedInterfaces = new Group((Composite)instanceConfigurationGroup, 0);
        derivedInterfaces.setLayout((Layout)new GridLayout(2, false));
        derivedInterfaces.setText(Messages.ConfigurePortDialog_IntfDerived);
        derivedInterfaces.setLayoutData((Object)gridDataSpan2);
        Label fProvidedLabel = new Label((Composite)derivedInterfaces, 0);
        fProvidedLabel.setText(Messages.ConfigurePortDialog_Provided + COLON);
        this.fProvided = new Label((Composite)derivedInterfaces, 0);
        this.fProvided.setLayoutData((Object)gridData);
        Label fRequiredLabel = new Label((Composite)derivedInterfaces, 0);
        fRequiredLabel.setText(Messages.ConfigurePortDialog_Required + COLON);
        this.fRequired = new Label((Composite)derivedInterfaces, 0);
        this.fRequired.setLayoutData((Object)gridData);
        derivedInterfaces.pack();
        this.fDescription = new Text((Composite)instanceConfigurationGroup, 584);
        this.fDescription.setLayoutData((Object)gridDataH80Span2);
        instanceConfigurationGroup.pack();
        this.setEnabled(false);
    }

    protected void selectPort(org.eclipse.uml2.uml.Port port) {
        this.m_currentPort = port;
        if (port == null) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(true);
        Port fcmPort = (Port)UMLUtil.getStereotypeApplication((Element)port, Port.class);
        if (port.getType() != null) {
            this.fType.setText(port.getType().getQualifiedName());
        } else {
            this.fType.setText(Messages.ConfigurePortDialog_Undef);
        }
        if (fcmPort != null && fcmPort.getKind() != null) {
            PortKind kind = fcmPort.getKind();
            if (this.portKindList.contains((Object)kind)) {
                int index = this.portKindList.indexOf((Object)kind) + 1;
                this.fKindCombo.select(index);
            }
            this.fDescription.setText(DescriptionUtils.getDescription((Element)kind.getBase_Class(), (String)Messages.ConfigurePortDialog_NotAvail));
            Interface providedI = PortUtils.getProvided((org.eclipse.uml2.uml.Port)port);
            Interface requiredI = PortUtils.getRequired((org.eclipse.uml2.uml.Port)port);
            this.fProvided.setText(providedI != null ? providedI.getQualifiedName() : Messages.ConfigurePortDialog_None);
            this.fRequired.setText(requiredI != null ? requiredI.getQualifiedName() : Messages.ConfigurePortDialog_None);
        } else {
            this.fProvided.setText(port.getProvideds().size() > 0 ? ((Interface)port.getProvideds().get(0)).getQualifiedName() : Messages.ConfigurePortDialog_None);
            this.fRequired.setText(port.getRequireds().size() > 0 ? ((Interface)port.getRequireds().get(0)).getQualifiedName() : Messages.ConfigurePortDialog_None);
            this.fKindCombo.select(0);
            this.fDescription.setText("");
        }
    }

    private void setEnabled(boolean enabled) {
        this.fDescription.setEnabled(enabled);
        if (!enabled) {
            this.fDescription.setText("");
        }
    }

    protected EList<PortKind> getAvailableKinds(Package pkg) {
        UniqueEList portKindList = new UniqueEList();
        BasicEList visitedPackages = new BasicEList();
        this.getAvailableKinds(pkg, (EList<PortKind>)portKindList, (EList<Package>)visitedPackages);
        return portKindList;
    }

    protected void getAvailableKinds(Package pkg, EList<PortKind> portKindList, EList<Package> visitedPackages) {
        for (Element el : pkg.getMembers()) {
            PortKind portKind;
            if (el instanceof Package) {
                if (visitedPackages.contains((Object)el)) continue;
                visitedPackages.add((Object)((Package)el));
                this.getAvailableKinds((Package)el, portKindList, visitedPackages);
                continue;
            }
            if (!(el instanceof Class) || (portKind = (PortKind)UMLUtil.getStereotypeApplication((Element)el, PortKind.class)) == null) continue;
            portKindList.add((Object)portKind);
        }
    }
}

