/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.query;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import prefuse.data.expression.ColumnExpression;
import prefuse.data.expression.Literal;
import prefuse.data.expression.RangePredicate;
import prefuse.data.query.DynamicQueryBinding;
import prefuse.data.query.NumberRangeModel;
import prefuse.data.query.ObjectRangeModel;
import prefuse.data.tuple.TupleSet;
import prefuse.util.DataLib;
import prefuse.util.TypeLib;
import prefuse.util.ui.JRangeSlider;
import prefuse.util.ui.ValuedRangeModel;

public class RangeQueryBinding
extends DynamicQueryBinding {
    private Class m_type;
    private Listener m_lstnr;
    private ValuedRangeModel m_model;
    private boolean m_ordinal;
    private static FocusListener s_sliderAdj;

    public RangeQueryBinding(TupleSet ts, String field) {
        this(ts, field, false);
    }

    public RangeQueryBinding(TupleSet ts, String field, boolean forceOrdinal) {
        super(ts, field);
        this.m_type = DataLib.inferType(ts, field);
        this.m_ordinal = forceOrdinal;
        this.m_lstnr = new Listener();
        this.initPredicate();
        this.initModel();
    }

    private void initPredicate() {
        Object min = DataLib.min(this.m_tuples, this.m_field).get(this.m_field);
        Object max = DataLib.max(this.m_tuples, this.m_field).get(this.m_field);
        Literal left = Literal.getLiteral(min, this.m_type);
        Literal right = Literal.getLiteral(max, this.m_type);
        ColumnExpression ce = new ColumnExpression(this.m_field);
        RangePredicate rp = new RangePredicate(ce, left, right);
        this.setPredicate(rp);
    }

    public void initModel() {
        if (this.m_model != null) {
            this.m_model.removeChangeListener(this.m_lstnr);
        }
        DefaultBoundedRangeModel model = null;
        if (TypeLib.isNumericType(this.m_type) && !this.m_ordinal) {
            Number min = (Number)DataLib.min(this.m_tuples, this.m_field).get(this.m_field);
            Number max = (Number)DataLib.max(this.m_tuples, this.m_field).get(this.m_field);
            model = new NumberRangeModel(min, max, min, max);
        } else {
            model = new ObjectRangeModel(DataLib.ordinalArray(this.m_tuples, this.m_field));
        }
        this.m_model = model;
        this.m_model.addChangeListener(this.m_lstnr);
    }

    public ValuedRangeModel getModel() {
        return this.m_model;
    }

    public NumberRangeModel getNumberModel() {
        return this.m_model instanceof NumberRangeModel ? (NumberRangeModel)this.m_model : null;
    }

    public ObjectRangeModel getObjectModel() {
        return this.m_model instanceof ObjectRangeModel ? (ObjectRangeModel)this.m_model : null;
    }

    public JComponent createComponent() {
        return this.createHorizontalRangeSlider();
    }

    public JRangeSlider createHorizontalRangeSlider() {
        return this.createRangeSlider(1, 0);
    }

    public JRangeSlider createVerticalRangeSlider() {
        return this.createRangeSlider(0, 1);
    }

    public JRangeSlider createRangeSlider(int orientation, int direction) {
        return new JRangeSlider(this.m_model, orientation, direction);
    }

    public JSlider createSlider() {
        JSlider slider = new JSlider(this.m_model);
        slider.addFocusListener(RangeQueryBinding.getSliderAdjuster());
        return slider;
    }

    private static synchronized FocusListener getSliderAdjuster() {
        if (s_sliderAdj == null) {
            s_sliderAdj = new SliderAdjuster();
        }
        return s_sliderAdj;
    }

    private class Listener
    implements ChangeListener {
        private Listener() {
        }

        public void stateChanged(ChangeEvent e) {
            ValuedRangeModel model = (ValuedRangeModel)e.getSource();
            Object lo = model.getLowValue();
            Object hi = model.getHighValue();
            RangePredicate rp = (RangePredicate)RangeQueryBinding.this.m_query;
            rp.setLeftExpression(Literal.getLiteral(lo, RangeQueryBinding.this.m_type));
            rp.setRightExpression(Literal.getLiteral(hi, RangeQueryBinding.this.m_type));
        }
    }

    private static class SliderAdjuster
    implements FocusListener {
        private SliderAdjuster() {
        }

        public void focusGained(FocusEvent e) {
            ((JSlider)e.getSource()).setExtent(0);
        }

        public void focusLost(FocusEvent e) {
        }
    }
}

