/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.backend.expr;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.xtend.backend.common.BackendType;
import org.eclipse.xtend.backend.common.ExecutionContext;
import org.eclipse.xtend.backend.common.ExpressionBase;
import org.eclipse.xtend.backend.common.Function;
import org.eclipse.xtend.backend.common.FunctionDefContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class CurriedFunction
implements Function {
    private final Function _inner;
    private final boolean[] _isBound;
    private final Object[] _boundValue;
    private final List<BackendType> _paramTypes = new ArrayList<BackendType>();

    public CurriedFunction(Function inner, List<ExpressionBase> boundParams, ExecutionContext ctx) {
        this._inner = inner;
        this._isBound = new boolean[inner.getParameterTypes().size()];
        this._boundValue = new Object[inner.getParameterTypes().size()];
        int i = 0;
        while (i < boundParams.size()) {
            ExpressionBase curParam = boundParams.get(i);
            if (curParam == null) {
                this._paramTypes.add(inner.getParameterTypes().get(i));
            } else {
                this._isBound[i] = true;
                this._boundValue[i] = boundParams.get(i).evaluate(ctx);
            }
            ++i;
        }
    }

    @Override
    public ExpressionBase getGuard() {
        return this._inner.getGuard();
    }

    @Override
    public List<? extends BackendType> getParameterTypes() {
        return this._paramTypes;
    }

    public Function getInnerFunction() {
        return this._inner;
    }

    public boolean[] getIsBound() {
        return this._isBound;
    }

    public Object[] getBoundValue() {
        return this._boundValue;
    }

    @Override
    public Object invoke(ExecutionContext ctx, Object[] params) {
        ArrayList<Object> realParams = new ArrayList<Object>();
        int j = 0;
        int i = 0;
        while (i < this._isBound.length) {
            if (this._isBound[i]) {
                realParams.add(this._boundValue[i]);
            } else {
                realParams.add(params[j++]);
            }
            ++i;
        }
        return ctx.getFunctionInvoker().invoke(ctx, this._inner, realParams);
    }

    @Override
    public boolean isCached() {
        return false;
    }

    @Override
    public FunctionDefContext getFunctionDefContext() {
        return this._inner.getFunctionDefContext();
    }

    @Override
    public void setFunctionDefContext(FunctionDefContext fdc) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BackendType getReturnType() {
        return this._inner.getReturnType();
    }
}

