/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.backend.aop;

import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.xtend.backend.aop.AdviceParamType;
import org.eclipse.xtend.backend.aop.Pointcut;
import org.eclipse.xtend.backend.common.BackendType;
import org.eclipse.xtend.backend.common.Function;
import org.eclipse.xtend.backend.common.QualifiedName;
import org.eclipse.xtend.backend.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExecutionPointcut
implements Pointcut {
    private final String _functionNamePattern;
    private final boolean _hasCompleteName;
    private final Pattern _namePattern;
    private final List<Pair<String, AdviceParamType>> _paramTypes;
    private final boolean _hasVarArgs;
    private final AdviceParamType _varArgsType;

    public ExecutionPointcut(String functionNamePattern, List<Pair<String, AdviceParamType>> paramTypes, boolean hasVarArgs, AdviceParamType varArgsType) {
        this._functionNamePattern = functionNamePattern;
        if (this._functionNamePattern.contains("*")) {
            this._hasCompleteName = false;
            this._namePattern = Pattern.compile(functionNamePattern.replace("*", ".*"));
        } else {
            this._hasCompleteName = true;
            this._namePattern = null;
        }
        this._paramTypes = paramTypes;
        this._hasVarArgs = hasVarArgs;
        this._varArgsType = varArgsType;
    }

    @Override
    public boolean matches(QualifiedName name, Function function) {
        if (!this.matchesName(name)) {
            return false;
        }
        return this.matchesParamTypes(function.getParameterTypes());
    }

    private boolean matchesParamTypes(List<? extends BackendType> paramTypes) {
        if (this._hasVarArgs ? paramTypes.size() < this._paramTypes.size() : paramTypes.size() != this._paramTypes.size()) {
            return false;
        }
        int i = 0;
        while (i < this._paramTypes.size()) {
            if (!this._paramTypes.get(i).getSecond().matches(paramTypes.get(i))) {
                return false;
            }
            ++i;
        }
        i = this._paramTypes.size();
        while (i < paramTypes.size()) {
            if (!this._varArgsType.matches(paramTypes.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean matchesName(QualifiedName functionName) {
        if (this._hasCompleteName) {
            return functionName.getFullQualifiedName().equals(this._functionNamePattern);
        }
        return this._namePattern.matcher(functionName.getFullQualifiedName()).matches();
    }

    @Override
    public List<Pair<String, AdviceParamType>> getParamTypes() {
        return this._paramTypes;
    }

    public String getFunctionNamePattern() {
        return this._functionNamePattern;
    }

    public boolean isHasVarArgs() {
        return this._hasVarArgs;
    }

    public AdviceParamType getVarArgsType() {
        return this._varArgsType;
    }
}

