/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.backend.compiler;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.xtend.backend.common.FunctionDefContext;
import org.eclipse.xtend.backend.common.NamedFunction;
import org.eclipse.xtend.backend.compiler.model.NamedFunctionModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompilationUnit {
    private String _resource;
    private FunctionDefContext _fdc;
    private List<NamedFunctionModel> _publicFunctions;
    private List<NamedFunctionModel> _allFunctions;

    public CompilationUnit(String resource, FunctionDefContext fdc) {
        this._resource = resource;
        this._fdc = fdc;
        this._allFunctions = Lists.transform((List)Lists.newArrayList((Iterable)this._fdc.getAllFunctions()), (Function)new Function<NamedFunction, NamedFunctionModel>(){

            public NamedFunctionModel apply(NamedFunction from) {
                return new NamedFunctionModel(from.getName(), from.getFunction());
            }
        });
        this._publicFunctions = Lists.transform((List)Lists.newArrayList((Iterable)this._fdc.getPublicFunctions()), (Function)new Function<NamedFunction, NamedFunctionModel>(){

            public NamedFunctionModel apply(NamedFunction from) {
                return new NamedFunctionModel(from.getName(), from.getFunction());
            }
        });
    }

    public String getResource() {
        return this._resource;
    }

    public void setResource(String resource) {
        this._resource = resource;
    }

    public FunctionDefContext getFdc() {
        return this._fdc;
    }

    public void setFdc(FunctionDefContext fdc) {
        this._fdc = fdc;
    }

    public List<NamedFunctionModel> getPublicFunctions() {
        return this._publicFunctions;
    }

    public List<NamedFunctionModel> getAllFunctions() {
        return this._allFunctions;
    }
}

