/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ui.editor.scanning;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.swt.graphics.Color;
import org.eclipse.xtend.shared.ui.Activator;
import org.eclipse.xtend.ui.XtendEditorPlugin;
import org.eclipse.xtend.ui.editor.color.ColorProvider;

public abstract class AbstractXtendRuleBasedScanner
extends RuleBasedScanner {
    protected Token keyword;
    protected Token string;
    protected Token comment;
    protected Token other;

    public AbstractXtendRuleBasedScanner() {
        this.initialize();
        this.setDefaultReturnToken((IToken)this.other);
    }

    public synchronized void initialize() {
        IPreferenceStore aPreferenceStore = Activator.getDefault().getPreferenceStore();
        if (this.keyword == null) {
            this.keyword = new Token(null);
        }
        this.keyword.setData((Object)this.getAttribute(aPreferenceStore, "xpd_keywords"));
        if (this.string == null) {
            this.string = new Token(null);
        }
        this.string.setData((Object)this.getAttribute(aPreferenceStore, "xpd_string"));
        if (this.comment == null) {
            this.comment = new Token(null);
        }
        this.comment.setData((Object)this.getAttribute(aPreferenceStore, "xpd_comment"));
        if (this.other == null) {
            this.other = new Token(null);
        }
        this.other.setData((Object)this.getAttribute(aPreferenceStore, "xpd_other"));
    }

    private TextAttribute getAttribute(IPreferenceStore store, String name) {
        ColorProvider provider = XtendEditorPlugin.getColorProvider();
        Color fgColor = provider.getColor(PreferenceConverter.getColor((IPreferenceStore)store, (String)(String.valueOf(name) + ".fgcolor")));
        int textStyle = store.getInt(String.valueOf(name) + ".fstyle") & 3;
        return new TextAttribute(fgColor, null, textStyle);
    }
}

