/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpand.support.cdt;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.gnu.cpp.GPPLanguage;
import org.eclipse.cdt.core.formatter.DefaultCodeFormatterOptions;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.ParserUtil;
import org.eclipse.cdt.core.parser.ScannerInfo;
import org.eclipse.cdt.internal.formatter.CodeFormatterVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.mwe.core.resources.ResourceLoaderFactory;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.xpand2.output.FileHandle;
import org.eclipse.xpand2.output.PostProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CppBeautifier
implements PostProcessor {
    private static final String DEFAULT_CDT_OPTIONS = "cdtformat-default.xml";
    private String configFile = "cdtformat-default.xml";
    private final Log log = LogFactory.getLog(this.getClass());
    private DefaultCodeFormatterOptions formatterOptions = this.getCodeFormatterSettings();

    public void afterClose(FileHandle impl) {
    }

    public void beforeWriteAndClose(FileHandle fileHandle) {
        DefaultCodeFormatterOptions settings = this.getCodeFormatterSettings();
        String source = fileHandle.getBuffer().toString();
        try {
            CodeFormatterVisitor codeFormatter = new CodeFormatterVisitor(settings, 0, source.length());
            IASTTranslationUnit ast = this.createTranslationUnit(settings.getMap(), source);
            Document document = new Document(source);
            codeFormatter.format(source, ast).apply((IDocument)document);
            fileHandle.setBuffer((CharSequence)document.get());
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage());
            this.log.debug((Object)e);
        }
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
        this.formatterOptions = null;
        this.formatterOptions = this.getCodeFormatterSettings();
    }

    private DefaultCodeFormatterOptions getCodeFormatterSettings() {
        if (this.formatterOptions == null) {
            this.formatterOptions = DefaultCodeFormatterOptions.getDefaultSettings();
            this.formatterOptions.line_separator = System.getProperty("line.separator");
            Properties config = this.readConfig(this.getConfigFile());
            if (config != null) {
                HashMap<String, String> options = new HashMap<String, String>();
                for (Object key : config.keySet()) {
                    options.put(key.toString(), config.getProperty(key.toString()));
                }
                this.formatterOptions.set(options);
            } else {
                this.log.warn((Object)"Using default settings.");
            }
        }
        return this.formatterOptions;
    }

    private IASTTranslationUnit createTranslationUnit(Map<?, ?> options, String source) throws CoreException {
        return this.getLanguage(options).getASTTranslationUnit(new CodeReader(source.toCharArray()), (IScannerInfo)new ScannerInfo(), null, null, ParserUtil.getParserLogService());
    }

    private ILanguage getLanguage(Map<?, ?> options) {
        ILanguage language = (ILanguage)options.get("org.eclipse.cdt.core.formatter.language");
        if (language == null) {
            language = GPPLanguage.getDefault();
        }
        return language;
    }

    private Properties readConfig(String filename) {
        BufferedInputStream stream = null;
        BufferedReader reader = null;
        try {
            InputStream is = this.getConfig(filename);
            Properties formatterOptions = new Properties();
            if (filename.endsWith(".xml")) {
                Pattern pattern = Pattern.compile("<setting id=\"([^\"]*)\" value=\"([^\"]*)\"\\/>");
                reader = new BufferedReader(new InputStreamReader(is));
                String line = reader.readLine();
                while (line != null) {
                    Matcher matcher = pattern.matcher(line);
                    if (matcher.matches()) {
                        formatterOptions.put(matcher.group(1), matcher.group(2));
                    }
                    line = reader.readLine();
                }
            } else {
                stream = new BufferedInputStream(is);
                formatterOptions.load(stream);
            }
            Properties properties = formatterOptions;
            return properties;
        }
        catch (IOException e) {
            this.log.warn((Object)("Problem reading code formatter config file (" + e.getMessage() + ")."));
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    private InputStream getConfig(String filename) throws IOException {
        URL url = ResourceLoaderFactory.createResourceLoader().getResource(filename);
        if (url == null) {
            url = CppBeautifier.class.getResource(filename);
        }
        if (url == null) {
            throw new IOException("Could not find config file [" + filename + "]");
        }
        InputStream is = url.openStream();
        if (is == null) {
            throw new IOException("Config file [" + filename + "] does not exist.");
        }
        return is;
    }
}

