/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.bridge.trace.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.gmf.internal.bridge.trace.AbstractTrace;
import org.eclipse.gmf.internal.bridge.trace.GenChildNodeTrace;
import org.eclipse.gmf.internal.bridge.trace.GenLinkTrace;
import org.eclipse.gmf.internal.bridge.trace.GenNodeTrace;
import org.eclipse.gmf.internal.bridge.trace.GmfTracePlugin;
import org.eclipse.gmf.internal.bridge.trace.TraceModel;
import org.eclipse.gmf.internal.bridge.trace.TracePackage;

public class TraceModelImpl
extends EObjectImpl
implements TraceModel {
    protected EList nodeTraces = null;
    protected EList childNodeTraces = null;
    protected EList linkTraces = null;
    protected EList toolGroupTraces = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    protected TraceModelImpl() {
    }

    protected EClass eStaticClass() {
        return TracePackage.Literals.TRACE_MODEL;
    }

    public EList getNodeTraces() {
        if (this.nodeTraces == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.gmf.internal.bridge.trace.GenNodeTrace");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.nodeTraces = new EObjectContainmentEList((Class)clazz, (InternalEObject)this, 0);
        }
        return this.nodeTraces;
    }

    public EList getChildNodeTraces() {
        if (this.childNodeTraces == null) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.gmf.internal.bridge.trace.GenChildNodeTrace");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.childNodeTraces = new EObjectContainmentEList((Class)clazz, (InternalEObject)this, 1);
        }
        return this.childNodeTraces;
    }

    public EList getLinkTraces() {
        if (this.linkTraces == null) {
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.eclipse.gmf.internal.bridge.trace.GenLinkTrace");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.linkTraces = new EObjectContainmentEList((Class)clazz, (InternalEObject)this, 2);
        }
        return this.linkTraces;
    }

    public EList getToolGroupTraces() {
        if (this.toolGroupTraces == null) {
            Class<?> clazz = class$3;
            if (clazz == null) {
                try {
                    clazz = class$3 = Class.forName("org.eclipse.gmf.internal.bridge.trace.ToolGroupTrace");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.toolGroupTraces = new EObjectContainmentEList((Class)clazz, (InternalEObject)this, 3);
        }
        return this.toolGroupTraces;
    }

    public GenNodeTrace getNodeTrace(int visualID) {
        GenNodeTrace nextTrace;
        Iterator it = this.getNodeTraces().iterator();
        while (it.hasNext()) {
            nextTrace = (GenNodeTrace)it.next();
            if (nextTrace.getVisualID() != visualID) continue;
            return nextTrace;
        }
        it = this.getChildNodeTraces().iterator();
        while (it.hasNext()) {
            nextTrace = (GenChildNodeTrace)it.next();
            if (nextTrace.getVisualID() != visualID) continue;
            return nextTrace;
        }
        throw new IllegalArgumentException("Node trace with id = " + visualID + " was not found");
    }

    public GenLinkTrace getLinkTrace(int visualID) {
        Iterator it = this.getLinkTraces().iterator();
        while (it.hasNext()) {
            GenLinkTrace nextTrace = (GenLinkTrace)it.next();
            if (nextTrace.getVisualID() != visualID) continue;
            return nextTrace;
        }
        throw new IllegalArgumentException("Link trace with id = " + visualID + " was not found");
    }

    public EList getAllAbstractTraces() {
        ArrayList result = new ArrayList();
        result.addAll(this.getNodeTraces());
        this.addNodeChildTraces(result, (Collection)this.getNodeTraces());
        result.addAll(this.getChildNodeTraces());
        this.addNodeChildTraces(result, (Collection)this.getChildNodeTraces());
        result.addAll(this.getLinkTraces());
        Iterator it = this.getLinkTraces().iterator();
        while (it.hasNext()) {
            GenLinkTrace trace = (GenLinkTrace)it.next();
            result.addAll(trace.getLinkLabelTraces());
        }
        result.addAll(this.getToolGroupTraces());
        return new BasicEList.UnmodifiableEList(result.size(), result.toArray());
    }

    private void addNodeChildTraces(Collection collection, Collection nodeTraces) {
        Iterator it = nodeTraces.iterator();
        while (it.hasNext()) {
            GenNodeTrace trace = (GenNodeTrace)it.next();
            collection.addAll(trace.getCompartmentTraces());
            collection.addAll(trace.getNodeLabelTraces());
        }
    }

    public void purgeUnprocessedTraces() {
        Iterator it = this.getAllAbstractTraces().iterator();
        while (it.hasNext()) {
            AbstractTrace trace = (AbstractTrace)it.next();
            if (trace.isProcessed()) continue;
            GmfTracePlugin.getInstance().logDebugInfo("Removing unused trace with visual ID = " + trace.getVisualID());
            switch (trace.eClass().getClassifierID()) {
                case 3: {
                    this.getNodeTraces().remove((Object)trace);
                    break;
                }
                case 4: {
                    this.getChildNodeTraces().remove((Object)trace);
                    break;
                }
                case 6: {
                    this.getLinkTraces().remove((Object)trace);
                    break;
                }
                case 9: {
                    this.getToolGroupTraces().remove((Object)trace);
                    break;
                }
                case 5: {
                    ((GenNodeTrace)trace.eContainer()).getNodeLabelTraces().remove((Object)trace);
                    break;
                }
                case 7: {
                    ((GenNodeTrace)trace.eContainer()).getCompartmentTraces().remove((Object)trace);
                    break;
                }
                case 8: {
                    ((GenLinkTrace)trace.eContainer()).getLinkLabelTraces().remove((Object)trace);
                }
            }
        }
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 0: {
                return ((InternalEList)this.getNodeTraces()).basicRemove((Object)otherEnd, msgs);
            }
            case 1: {
                return ((InternalEList)this.getChildNodeTraces()).basicRemove((Object)otherEnd, msgs);
            }
            case 2: {
                return ((InternalEList)this.getLinkTraces()).basicRemove((Object)otherEnd, msgs);
            }
            case 3: {
                return ((InternalEList)this.getToolGroupTraces()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getNodeTraces();
            }
            case 1: {
                return this.getChildNodeTraces();
            }
            case 2: {
                return this.getLinkTraces();
            }
            case 3: {
                return this.getToolGroupTraces();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.getNodeTraces().clear();
                this.getNodeTraces().addAll((Collection)newValue);
                return;
            }
            case 1: {
                this.getChildNodeTraces().clear();
                this.getChildNodeTraces().addAll((Collection)newValue);
                return;
            }
            case 2: {
                this.getLinkTraces().clear();
                this.getLinkTraces().addAll((Collection)newValue);
                return;
            }
            case 3: {
                this.getToolGroupTraces().clear();
                this.getToolGroupTraces().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.getNodeTraces().clear();
                return;
            }
            case 1: {
                this.getChildNodeTraces().clear();
                return;
            }
            case 2: {
                this.getLinkTraces().clear();
                return;
            }
            case 3: {
                this.getToolGroupTraces().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.nodeTraces != null && !this.nodeTraces.isEmpty();
            }
            case 1: {
                return this.childNodeTraces != null && !this.childNodeTraces.isEmpty();
            }
            case 2: {
                return this.linkTraces != null && !this.linkTraces.isEmpty();
            }
            case 3: {
                return this.toolGroupTraces != null && !this.toolGroupTraces.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }
}

