/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.setup;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Map;
import junit.framework.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.codegen.ecore.genmodel.GenBase;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.codegen.gmfgen.GenJavaExpressionProvider;
import org.eclipse.gmf.mappings.AuditContainer;
import org.eclipse.gmf.mappings.AuditRule;
import org.eclipse.gmf.mappings.Auditable;
import org.eclipse.gmf.mappings.AuditedMetricTarget;
import org.eclipse.gmf.mappings.ChildReference;
import org.eclipse.gmf.mappings.Constraint;
import org.eclipse.gmf.mappings.DiagramElementTarget;
import org.eclipse.gmf.mappings.DomainAttributeTarget;
import org.eclipse.gmf.mappings.DomainElementTarget;
import org.eclipse.gmf.mappings.ElementInitializer;
import org.eclipse.gmf.mappings.FeatureInitializer;
import org.eclipse.gmf.mappings.FeatureSeqInitializer;
import org.eclipse.gmf.mappings.FeatureValueSpec;
import org.eclipse.gmf.mappings.GMFMapFactory;
import org.eclipse.gmf.mappings.Language;
import org.eclipse.gmf.mappings.LinkMapping;
import org.eclipse.gmf.mappings.MappingEntry;
import org.eclipse.gmf.mappings.Measurable;
import org.eclipse.gmf.mappings.MetricContainer;
import org.eclipse.gmf.mappings.MetricRule;
import org.eclipse.gmf.mappings.NodeMapping;
import org.eclipse.gmf.mappings.ReferenceNewElementSpec;
import org.eclipse.gmf.mappings.Severity;
import org.eclipse.gmf.mappings.ValueExpression;
import org.eclipse.gmf.tests.EPath;
import org.eclipse.gmf.tests.Plugin;
import org.eclipse.gmf.tests.setup.DiaDefSource;
import org.eclipse.gmf.tests.setup.DiaGenSetup;
import org.eclipse.gmf.tests.setup.DiaGenSource;
import org.eclipse.gmf.tests.setup.DomainModelFileSetup;
import org.eclipse.gmf.tests.setup.DomainModelSource;
import org.eclipse.gmf.tests.setup.GenProjectSetup;
import org.eclipse.gmf.tests.setup.GeneratorConfiguration;
import org.eclipse.gmf.tests.setup.MapDefSource;
import org.eclipse.gmf.tests.setup.MapSetup;
import org.eclipse.gmf.tests.setup.RuntimeBasedGeneratorConfiguration;
import org.eclipse.gmf.tests.setup.SessionSetup;
import org.eclipse.gmf.tests.setup.ToolDefSetup;
import org.eclipse.gmf.tests.setup.ToolDefSource;
import org.osgi.framework.BundleException;

public class LinksSessionSetup
extends SessionSetup {
    public static String modelURI = "/models/links/links.ecore";

    protected LinksSessionSetup(GeneratorConfiguration genConfig) {
        super(genConfig);
    }

    public static SessionSetup newInstance() {
        if (factoryClosed) {
            return null;
        }
        return new LinksSessionSetup(new RuntimeBasedGeneratorConfiguration());
    }

    protected GenProjectSetup createGenProject() throws BundleException {
        GenProjectSetup genProjectSetup = super.createGenProject();
        LinksSessionSetup.assertValid("Test gmfmap model must be valid", EcoreUtil.getRootContainer((EObject)this.getMapModel().getMapping()));
        return genProjectSetup;
    }

    static void assertValid(String message, EObject target) {
        Diagnostic validationDiagnostic = Diagnostician.INSTANCE.validate(target);
        IStatus validationStatus = BasicDiagnostic.toIStatus((Diagnostic)validationDiagnostic);
        if (!validationStatus.isOK()) {
            Plugin.getInstance().getLog().log(validationStatus);
        }
        Assert.assertTrue((String)MessageFormat.format("{0}. {1}. See error log for details.", message, validationStatus.getMessage()), (boolean)validationStatus.isOK());
    }

    protected DomainModelSource createDomainModel() {
        DomainModelFileSetup modelSetup = new DomainModelFileSetup(){
            private EPath modelAccess;

            public DomainModelSource init(URI sourceURI) {
                DomainModelSource r = super.init(sourceURI);
                this.modelAccess = new EPath(this.getModel().eResource());
                return r;
            }

            public EClass getDiagramElement() {
                return this.modelAccess.findClass("//Root");
            }

            public DomainModelSource.NodeData getNodeA() {
                EClass n = this.modelAccess.findClass("//LinkContainer");
                EReference c = this.modelAccess.findReference("//Root/elements");
                return new DomainModelSource.NodeData(n, null, c);
            }

            public DomainModelSource.NodeData getNodeB() {
                EClass n = this.modelAccess.findClass("//Node");
                EReference c = this.modelAccess.findReference("//Root/elements");
                return new DomainModelSource.NodeData(n, null, c);
            }

            public DomainModelSource.LinkData getLinkAsClass() {
                EClass l = this.modelAccess.findClass("//Link");
                EReference t = this.modelAccess.findReference("//Link/target");
                EReference c = this.modelAccess.findReference("//LinkContainer/childNodes");
                return new DomainModelSource.LinkData(l, (EStructuralFeature)t, c);
            }

            public EReference getLinkAsRef() {
                return this.modelAccess.findReference("//LinkContainer/referenceOnlyLink");
            }
        };
        try {
            modelSetup.init(Plugin.createURI(modelURI));
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)("Failed to setup the domain model. " + e.getLocalizedMessage()));
        }
        return modelSetup;
    }

    protected DiaGenSource createGenModel() {
        DiaGenSetup diaGenSetup = new DiaGenSetup().init(this.getMapModel());
        diaGenSetup.getGenDiagram().setValidationEnabled(true);
        diaGenSetup.getGenDiagram().setLiveValidationUIFeedback(true);
        diaGenSetup.getGenDiagram().setValidationDecorators(true);
        GenModel genModel = diaGenSetup.getGenDiagram().getDiagram().getDomainDiagramElement().getGenModel();
        for (GenPackage nextGenPackage : genModel.getAllGenPackagesWithClassifiers()) {
            if (nextGenPackage.getPrefix() != null && nextGenPackage.getPrefix().length() != 0) continue;
            StringBuffer buf = new StringBuffer(nextGenPackage.getPackageName());
            buf.setCharAt(0, Character.toUpperCase(buf.charAt(0)));
            nextGenPackage.setPrefix(buf.toString());
        }
        for (Object o : diaGenSetup.getGenDiagram().getEditorGen().getExpressionProviders().getProviders()) {
            if (!(o instanceof GenJavaExpressionProvider)) continue;
            ((GenJavaExpressionProvider)o).setThrowException(false);
            break;
        }
        ResourceSet rset = this.getMapModel().getMapping().eResource().getResourceSet();
        this.bindGMFGenModelToResourceSet(diaGenSetup, rset);
        return diaGenSetup;
    }

    protected MapDefSource createMapModel() {
        LinksMapSetup mapDefSource = new LinksMapSetup();
        return ((MapSetup)mapDefSource).init(this.getGraphDefModel(), this.getDomainModel(), new ToolDefSetup());
    }

    private void bindGMFGenModelToResourceSet(DiaGenSetup diaGenSetup, ResourceSet rset) {
        rset.createResource(URI.createURI((String)"uri:/myTestModel/gmfgen")).getContents().add((Object)EcoreUtil.getRootContainer((EObject)diaGenSetup.getGenDiagram()));
        HashSet<GenModel> genModels = new HashSet<GenModel>();
        GenModel domainGenModel = diaGenSetup.getGenDiagram().getDomainDiagramElement().getGenModel();
        genModels.add(domainGenModel);
        Map crossRefs = EcoreUtil.ExternalCrossReferencer.find((EObject)EcoreUtil.getRootContainer((EObject)diaGenSetup.getGenDiagram()));
        for (EObject crossReferenced : crossRefs.keySet()) {
            if (crossReferenced.eResource() != null || !(crossReferenced instanceof GenBase)) continue;
            genModels.add(((GenBase)crossReferenced).getGenModel());
        }
        int modelID = 0;
        for (GenModel nextGenModel : genModels) {
            rset.createResource(URI.createURI((String)("uri:/myTestModel/genmodel/" + modelID++))).getContents().add((Object)nextGenModel);
        }
    }

    private static final class LinksMapSetup
    extends MapSetup {
        private EPath modelAccess;

        private LinksMapSetup() {
        }

        public MapSetup init(DiaDefSource ddSource, DomainModelSource domainSource, ToolDefSource toolDef) {
            this.modelAccess = new EPath(domainSource.getModel().eResource());
            super.init(ddSource, domainSource, toolDef);
            EClass invalidNodeMetaClass = this.modelAccess.findClass("//InvalidNode");
            this.createNodeMapping(ddSource.getNodeDef(), invalidNodeMetaClass, null, null, this.modelAccess.findReference("//Root/elements"), true);
            this.initMetricContainer(domainSource);
            this.initAudits();
            this.bindToResourceSet(ddSource, toolDef, domainSource.getModel().eResource().getResourceSet());
            return this;
        }

        private void bindToResourceSet(DiaDefSource ddSource, ToolDefSource toolDef, ResourceSet rs) {
            Resource mapRsrc = rs.createResource(URI.createURI((String)"uri:/myTestModel/gmfmap"));
            mapRsrc.getContents().add((Object)this.getMapping());
            Resource graphRsrc = rs.createResource(URI.createURI((String)"uri:/myTestModel/gmfgraph"));
            graphRsrc.getContents().add((Object)ddSource.getCanvasDef());
            Resource toolRsrc = rs.createResource(URI.createURI((String)"uri:/myTestModel/gmftool"));
            toolRsrc.getContents().add((Object)toolDef.getRegistry());
        }

        protected void setupNodeMapping(NodeMapping nme) {
            EClass nodeEClass = this.modelAccess.findClass("//Node");
            EStructuralFeature node_nestedNodes1 = this.modelAccess.findFeature("//Node/nestedNodes1");
            if ("LinkContainer".equals(nme.getDomainContext().getName())) {
                EPath ecoreModelAccess = new EPath(EcorePackage.eINSTANCE.eResource());
                nme.setDomainInitializer((ElementInitializer)LinksMapSetup.createFSeqInit(null, new FeatureInitializer[]{this.featureValOCL("//LinkContainer/enumAttr_Init", "TestEnum::LIT1"), this.featureValOCL("//LinkContainer/manyEnumAttr_Init", "Sequence { TestEnum::LIT0, TestEnum::LIT1 }"), this.featureValOCL("//LinkContainer/reference_Init", "Bag { self }"), this.featureValOCL("//LinkContainer/manyRealAttr_Init", "Sequence { 1, 1.5 }"), LinksMapSetup.refNewElement(this.modelAccess.findFeature("//LinkContainer/refNewElement"), LinksMapSetup.createFSeqInit(null, new FeatureInitializer[]{LinksMapSetup.featureValOCL(ecoreModelAccess.findFeature("//ENamedElement/name"), "'EClass'"), LinksMapSetup.refNewElement(ecoreModelAccess.findFeature("//EClass/eStructuralFeatures"), LinksMapSetup.createFSeqInit(ecoreModelAccess.findClass("//EAttribute"), new FeatureInitializer[]{LinksMapSetup.featureValOCL(ecoreModelAccess.findFeature("//ENamedElement/name"), "'EAttribute'"), LinksMapSetup.featureValOCL(ecoreModelAccess.findFeature("//ETypedElement/eType"), "ecore::EString")})), LinksMapSetup.refNewElement(ecoreModelAccess.findFeature("//EClass/eOperations"), LinksMapSetup.createFSeqInit(null, new FeatureInitializer[]{LinksMapSetup.featureValOCL(ecoreModelAccess.findFeature("//ENamedElement/name"), "'EOperation'"), LinksMapSetup.featureValOCL(ecoreModelAccess.findFeature("//ETypedElement/eType"), "links::LinkContainer")}))})), LinksMapSetup.refNewElement(node_nestedNodes1, LinksMapSetup.createFSeqInit(nodeEClass, new FeatureInitializer[]{this.featureValOCL("//Node/name", "'Node_0'"), LinksMapSetup.refNewElement(node_nestedNodes1, LinksMapSetup.createFSeqInit(nodeEClass, new FeatureInitializer[]{this.featureValOCL("//Node/name", "'Node_0_0'"), LinksMapSetup.refNewElement(node_nestedNodes1, LinksMapSetup.createFSeqInit(nodeEClass, new FeatureInitializer[]{this.featureValOCL("//Node/name", "'Node_0_0_0'"), LinksMapSetup.refNewElement(node_nestedNodes1, LinksMapSetup.createFSeqInit(nodeEClass, new FeatureInitializer[]{this.featureValOCL("//Node/name", "'Node_0_0_0_0'"), LinksMapSetup.refNewElement(node_nestedNodes1, LinksMapSetup.createFSeqInit(nodeEClass, new FeatureInitializer[]{this.featureValOCL("//Node/name", "'Node_0_0_0_0_0'")}))}))}))}))}), LinksMapSetup.createFSeqInit(nodeEClass, new FeatureInitializer[]{this.featureValOCL("//Node/name", "'Node_1'")}))}));
                Constraint selector = GMFMapFactory.eINSTANCE.createConstraint();
                selector.setBody("true");
                nme.setDomainSpecialization(selector);
            } else if ("Node".equals(nme.getDomainContext().getName())) {
                nme.setDomainInitializer((ElementInitializer)LinksMapSetup.createFSeqInit(null, new FeatureInitializer[]{this.featureValOCL("//Node/integers_Init", "Sequence { 10, 20 }"), this.featureValJava("//Node/name", "setNodeName")}));
                this.createReusedChildNodes(nme, new String[]{"//Node/nestedNodes1", "//Node/nestedNodes2"});
            } else if ("InvalidNode".equals(nme.getDomainContext().getName())) {
                nme.setDomainInitializer((ElementInitializer)LinksMapSetup.createFSeqInit(null, new FeatureInitializer[]{this.featureValOCL("//Node/name", "'\"Quated-name tests literal escaping\"'"), this.featureValJava("//Node/multiValPrimitive", "multiValPrimitive"), this.featureValJava("//Node/multiValObj", "multiValObj"), this.featureValJava("//Node/multiRef", "multiRef"), this.featureValJava("//Node/singleValPrimitive", "singleValPrimitive"), this.featureValJava("//Node/singleValObj", "singleValObj"), this.featureValJava("//Node/singleRef", "singleRef"), LinksMapSetup.refNewElement(this.modelAccess.findFeature("//InvalidNode/ref1"), LinksMapSetup.createFSeqInit(nodeEClass, new FeatureInitializer[]{this.featureValJava("//Node/name", "aaa")})), LinksMapSetup.refNewElement(this.modelAccess.findFeature("//InvalidNode/ref2"), LinksMapSetup.createFSeqInit(nodeEClass, new FeatureInitializer[]{this.featureValJava("//Node/name", "bbb")}))}));
                Constraint selector = GMFMapFactory.eINSTANCE.createConstraint();
                selector.setLanguage(Language.JAVA_LITERAL);
                selector.setBody("myNodeSelector");
                nme.setDomainSpecialization(selector);
                this.createReusedChildNodes(nme, new String[]{"//Node/nestedNodes1"});
            }
        }

        static FeatureSeqInitializer createFSeqInit(EClass elementClass, FeatureInitializer ... featureInits) {
            FeatureSeqInitializer elementInitializer = GMFMapFactory.eINSTANCE.createFeatureSeqInitializer();
            int i = 0;
            while (i < featureInits.length) {
                elementInitializer.getInitializers().add((Object)featureInits[i]);
                ++i;
            }
            if (elementClass != null) {
                elementInitializer.setElementClass(elementClass);
            }
            return elementInitializer;
        }

        FeatureValueSpec featureValOCL(String featureQName, String expressionBody) {
            return LinksMapSetup.featureValOCL(this.modelAccess.findFeature(featureQName), expressionBody);
        }

        static FeatureValueSpec featureValOCL(EStructuralFeature sf, String expressionBody) {
            return LinksMapSetup.featureVal(sf, expressionBody, Language.OCL_LITERAL);
        }

        FeatureValueSpec featureValJava(String featureQName, String expressionBody) {
            return LinksMapSetup.featureVal(this.modelAccess.findFeature(featureQName), expressionBody, Language.JAVA_LITERAL);
        }

        FeatureValueSpec featureValLiteral(String featureQName, String expression) {
            return LinksMapSetup.featureVal(this.modelAccess.findFeature(featureQName), expression, Language.LITERAL_LITERAL);
        }

        private static FeatureValueSpec featureVal(EStructuralFeature sf, String expressionBody, Language expressionLang) {
            FeatureValueSpec featureValueSpec = GMFMapFactory.eINSTANCE.createFeatureValueSpec();
            featureValueSpec.setFeature(sf);
            ValueExpression value = GMFMapFactory.eINSTANCE.createValueExpression();
            value.setBody(expressionBody);
            value.setLanguage(expressionLang);
            featureValueSpec.setValue(value);
            return featureValueSpec;
        }

        static ReferenceNewElementSpec refNewElement(EStructuralFeature sf, FeatureSeqInitializer ... elementInitializers) {
            ReferenceNewElementSpec newElementSpec = GMFMapFactory.eINSTANCE.createReferenceNewElementSpec();
            newElementSpec.setFeature(sf);
            int i = 0;
            while (i < elementInitializers.length) {
                newElementSpec.getNewElementInitializers().add((Object)elementInitializers[i]);
                ++i;
            }
            return newElementSpec;
        }

        private void createReusedChildNodes(NodeMapping topNode, String[] containmentFeatures) {
            int i = 0;
            while (i < containmentFeatures.length) {
                ChildReference childRef = GMFMapFactory.eINSTANCE.createChildReference();
                childRef.setContainmentFeature(this.modelAccess.findReference(containmentFeatures[i]));
                childRef.setReferencedChild(topNode);
                topNode.getChildren().add((Object)childRef);
                ++i;
            }
        }

        protected void initAudits() {
            AuditContainer auditContainer = this.createAuditContainer(String.valueOf(Plugin.getPluginID()) + ".<category1>" + System.currentTimeMillis());
            this.getMapping().setAudits(auditContainer);
            DomainElementTarget classA = GMFMapFactory.eINSTANCE.createDomainElementTarget();
            classA.setElement(this.getNodeA().getDomainMetaElement());
            DomainElementTarget classB = GMFMapFactory.eINSTANCE.createDomainElementTarget();
            classB.setElement(this.modelAccess.findClass("//nestedPckg/ClassA"));
            String constraintId1 = "<constraint.id1>";
            auditContainer.getAudits().add((Object)this.createAudit(constraintId1, "false", (Auditable)classA, Severity.WARNING_LITERAL, false));
            auditContainer.getAudits().add((Object)this.createAudit("constraint.id2", "false and nestedPckg::ClassA.allInstances()->size() > 0", (Auditable)classB, Severity.ERROR_LITERAL, true));
            AuditContainer subCat = this.createAuditContainer("category2");
            DiagramElementTarget nodeTarget = GMFMapFactory.eINSTANCE.createDiagramElementTarget();
            nodeTarget.setElement((MappingEntry)this.getNodeB());
            auditContainer.getChildContainers().add((Object)subCat);
            subCat.getAudits().add((Object)this.createAudit("constraint.id3", "''='Foo'", (Auditable)nodeTarget, Severity.INFO_LITERAL, false));
            AuditContainer attrAuditContainer = this.createAuditContainer("audit_container.attributeTarget");
            auditContainer.getChildContainers().add((Object)attrAuditContainer);
            DomainAttributeTarget attrTarget1 = GMFMapFactory.eINSTANCE.createDomainAttributeTarget();
            attrTarget1.setAttribute(this.modelAccess.findAttribute("//Node/name"));
            attrTarget1.setNullAsError(true);
            attrAuditContainer.getAudits().add((Object)this.createAudit("audit.attributeTarget.id1", "self = ''", (Auditable)attrTarget1, Severity.ERROR_LITERAL, false));
            DomainAttributeTarget attrTarget2 = GMFMapFactory.eINSTANCE.createDomainAttributeTarget();
            attrTarget2.setAttribute(this.modelAccess.findAttribute("//Node/acceptLinkKind"));
            attrTarget2.setNullAsError(false);
            AuditRule regexpRule = this.createAudit("audit.attributeTarget.id2", "a*b", (Auditable)attrTarget2, Severity.ERROR_LITERAL, false);
            regexpRule.getRule().setLanguage(Language.REGEXP_LITERAL);
            attrAuditContainer.getAudits().add((Object)regexpRule);
            DomainAttributeTarget attrTarget3 = GMFMapFactory.eINSTANCE.createDomainAttributeTarget();
            attrTarget3.setAttribute(this.modelAccess.findAttribute("//Node/acceptLinkKind"));
            AuditRule javaRule1 = this.createAudit("audit.attributeTarget.id3", "myJavaAudit1", (Auditable)attrTarget3, Severity.ERROR_LITERAL, false);
            javaRule1.getRule().setLanguage(Language.JAVA_LITERAL);
            attrAuditContainer.getAudits().add((Object)javaRule1);
            DomainAttributeTarget attrTarget4 = GMFMapFactory.eINSTANCE.createDomainAttributeTarget();
            attrTarget4.setAttribute(this.modelAccess.findAttribute("//LinkContainer/enumAttr_Init"));
            AuditRule javaRule2 = this.createAudit("audit.attributeTarget.id4", "myJavaAudit2", (Auditable)attrTarget4, Severity.ERROR_LITERAL, false);
            javaRule2.getRule().setLanguage(Language.JAVA_LITERAL);
            attrAuditContainer.getAudits().add((Object)javaRule2);
            DomainAttributeTarget attrTarget5 = GMFMapFactory.eINSTANCE.createDomainAttributeTarget();
            attrTarget5.setAttribute(this.modelAccess.findAttribute("//Node/multiValObj"));
            attrTarget5.setNullAsError(false);
            AuditRule nregexpRule = this.createAudit("audit.attributeTarget.nregexp.id", "a*b", (Auditable)attrTarget5, Severity.ERROR_LITERAL, false);
            nregexpRule.getRule().setLanguage(Language.NREGEXP_LITERAL);
            attrAuditContainer.getAudits().add((Object)nregexpRule);
            AuditedMetricTarget metricTarget = GMFMapFactory.eINSTANCE.createAuditedMetricTarget();
            Assert.assertTrue((String)"Requires at least one metric definition", (this.getMapping().getMetrics() != null && this.getMapping().getMetrics().getMetrics().size() > 0 ? 1 : 0) != 0);
            metricTarget.setMetric((MetricRule)this.getMapping().getMetrics().getMetrics().get(0));
            AuditRule metricAuditRule = this.createAudit("audit.metricTarget.id", "self > 0 and false", (Auditable)metricTarget, Severity.INFO_LITERAL, false);
            auditContainer.getAudits().add((Object)metricAuditRule);
        }

        protected void setupClassLinkMapping(LinkMapping lme) {
            this.addCreationConstraints(lme, null, "self.acceptLinkKind = oppositeEnd.acceptLinkKind");
            assert (lme.getDomainInitializer() == null);
            FeatureSeqInitializer ei = LinksMapSetup.createFSeqInit(null, new FeatureInitializer[]{this.featureValLiteral("//Link/boolToInit", "true"), this.featureValLiteral("//Link/stringToInit", "\"init-string\"")});
            lme.setDomainInitializer((ElementInitializer)ei);
        }

        protected void setupReferenceLinkMapping(LinkMapping lme) {
            this.addCreationConstraints(lme, "not self.acceptLinkKind.oclIsUndefined()", "self.acceptLinkKind = oppositeEnd.acceptLinkKind");
        }

        private void initMetricContainer(DomainModelSource domainModel) {
            MetricContainer container = GMFMapFactory.eINSTANCE.createMetricContainer();
            MetricRule domainElementRule = LinksMapSetup.createMetric("\"dom1\"", "1.2", null, null);
            DomainElementTarget domainElementTarget = GMFMapFactory.eINSTANCE.createDomainElementTarget();
            domainElementRule.setName(null);
            domainElementRule.setDescription(null);
            domainElementTarget.setElement(domainModel.getNodeA().getEClass());
            domainElementRule.setTarget((Measurable)domainElementTarget);
            container.getMetrics().add((Object)domainElementRule);
            MetricRule reusedDiagramElementRule = LinksMapSetup.createMetric("reused.node.mapping.diagramElement", "150", new Double(100.0), new Double(200.0));
            reusedDiagramElementRule.setDescription("A diagram metric with reused diagram element mapping");
            DiagramElementTarget reusedDiagramElementTarget = GMFMapFactory.eINSTANCE.createDiagramElementTarget();
            reusedDiagramElementTarget.setElement((MappingEntry)this.getNodeB());
            reusedDiagramElementRule.setTarget((Measurable)reusedDiagramElementTarget);
            container.getMetrics().add((Object)reusedDiagramElementRule);
            MetricRule diagramElementRule = LinksMapSetup.createMetric("node.mapping.diagramElement", "15", new Double(10.0), new Double(20.0));
            DiagramElementTarget diagramElementTarget = GMFMapFactory.eINSTANCE.createDiagramElementTarget();
            diagramElementTarget.setElement((MappingEntry)this.getNodeA());
            diagramElementRule.setTarget((Measurable)diagramElementTarget);
            container.getMetrics().add((Object)diagramElementRule);
            this.getMapping().setMetrics(container);
        }

        private static MetricRule createMetric(String key, String oclBody, Double low, Double high) {
            MetricRule rule = GMFMapFactory.eINSTANCE.createMetricRule();
            rule.setKey(key);
            rule.setName("Name of \"" + key + "\"");
            rule.setDescription("Description of \"" + key + "\"");
            rule.setRule(GMFMapFactory.eINSTANCE.createValueExpression());
            rule.getRule().setBody(oclBody);
            rule.setLowLimit(low);
            rule.setHighLimit(high);
            return rule;
        }
    }
}

