/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.util;

import java.util.ArrayList;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AdapterUtils {
    private static final ComposedAdapterFactory FACTORY = AdapterUtils.createAdapterFactory();

    private AdapterUtils() {
    }

    public static <T> T adapt(EObject eObj, Class<? extends T> type) {
        return (T)AdapterUtils.getAdapterFactory().adapt((Notifier)eObj, type);
    }

    @Deprecated
    public static AdapterFactory findAdapterFactory(EObject eObj) {
        return FACTORY.getFactoryForType((Object)eObj);
    }

    public static AdapterFactory getAdapterFactory() {
        return FACTORY;
    }

    public static Object getItemProviderImage(EObject eObj) {
        IItemLabelProvider labelProvider = AdapterUtils.adapt(eObj, IItemLabelProvider.class);
        if (labelProvider != null) {
            return labelProvider.getImage((Object)eObj);
        }
        return null;
    }

    public static String getItemProviderText(EObject eObj) {
        IItemLabelProvider labelProvider = AdapterUtils.adapt(eObj, IItemLabelProvider.class);
        if (labelProvider != null) {
            return labelProvider.getText((Object)eObj);
        }
        return null;
    }

    private static ComposedAdapterFactory createAdapterFactory() {
        ArrayList<Object> factories = new ArrayList<Object>();
        factories.add(new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE));
        factories.add(new ReflectiveItemProviderAdapterFactory());
        return new ComposedAdapterFactory(factories);
    }
}

