/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mint.util;

import org.eclipse.emf.mint.IItemJavaElementDescriptor;
import org.eclipse.emf.mint.IItemJavaElementDescriptor2;
import org.eclipse.emf.mint.IJavaTypeReference;
import org.eclipse.emf.mint.util.JavaTypeReference;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;

public class ItemJavaElementDescriptor
implements IItemJavaElementDescriptor2 {
    private final IItemJavaElementDescriptor.Kind kind;
    private final IJavaElement javaElement;
    private final IJavaTypeReference javaTypeReference;
    private final Object nonJavaElement;
    private final String category;
    private final String description;
    private final String displayName;
    private final Object feature;
    private final boolean elementOwner;

    public ItemJavaElementDescriptor(IJavaElement javaElement, String category, String description, String displayName, Object feature) {
        this(javaElement, category, description, displayName, feature, false);
    }

    public ItemJavaElementDescriptor(IJavaElement javaElement, String category, String description, String displayName, Object feature, boolean elementOwner) {
        this(IItemJavaElementDescriptor.Kind.JAVA_ELEMENT, javaElement, null, null, category, description, displayName, feature, elementOwner);
    }

    public ItemJavaElementDescriptor(IJavaProject context, String typeName, String category, String description, String displayName, Object feature) {
        this(context, typeName, category, description, displayName, feature, false);
    }

    public ItemJavaElementDescriptor(IJavaProject context, String typeName, String category, String description, String displayName, Object feature, boolean elementOwner) {
        this(IItemJavaElementDescriptor.Kind.JAVA_TYPE_REFERENCE, null, new JavaTypeReference(context, typeName), null, category, description, displayName, feature, elementOwner);
    }

    public ItemJavaElementDescriptor(Object nonJavaElement, String category, String description, String displayName, Object feature) {
        this(nonJavaElement, category, description, displayName, feature, false);
    }

    public ItemJavaElementDescriptor(Object nonJavaElement, String category, String description, String displayName, Object feature, boolean elementOwner) {
        this(IItemJavaElementDescriptor.Kind.NON_JAVA_RESOURCE, null, null, nonJavaElement, category, description, displayName, feature, elementOwner);
    }

    protected ItemJavaElementDescriptor(IItemJavaElementDescriptor.Kind kind, IJavaElement javaElement, IJavaTypeReference javaTypeReference, Object nonJavaElement, String category, String description, String displayName, Object feature) {
        this(kind, javaElement, javaTypeReference, nonJavaElement, category, description, displayName, feature, false);
    }

    protected ItemJavaElementDescriptor(IItemJavaElementDescriptor.Kind kind, IJavaElement javaElement, IJavaTypeReference javaTypeReference, Object nonJavaElement, String category, String description, String displayName, Object feature, boolean elementOwner) {
        this.kind = kind;
        this.javaElement = javaElement;
        this.javaTypeReference = javaTypeReference;
        this.nonJavaElement = nonJavaElement;
        this.category = category;
        this.description = description;
        this.displayName = displayName;
        this.feature = feature;
        this.elementOwner = elementOwner;
    }

    public IItemJavaElementDescriptor.Kind getKind(Object object) {
        return this.kind;
    }

    public IJavaElement getJavaElement(Object object) {
        return this.javaElement;
    }

    public IJavaTypeReference getJavaTypeReference(Object object) {
        return this.javaTypeReference;
    }

    public Object getNonJavaElement(Object object) {
        return this.nonJavaElement;
    }

    public String getCategory(Object object) {
        return this.category;
    }

    public String getDescription(Object object) {
        return this.description;
    }

    public String getDisplayName(Object object) {
        return this.displayName;
    }

    public Object getFeature(Object object) {
        return this.feature;
    }

    public boolean isElementOwner(Object object) {
        return this.elementOwner;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ItemJavaElementDescriptor other = (ItemJavaElementDescriptor)obj;
        if (this.kind != other.kind) {
            return false;
        }
        if (this.javaElement == null ? other.javaElement != null : !this.javaElement.equals(other.javaElement)) {
            return false;
        }
        if (this.javaTypeReference == null ? other.javaTypeReference != null : !this.javaTypeReference.equals(other.javaTypeReference)) {
            return false;
        }
        return !(this.nonJavaElement == null ? other.nonJavaElement != null : !this.nonJavaElement.equals(other.nonJavaElement));
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.kind == null ? 0 : this.kind.hashCode());
        result = 31 * result + (this.javaElement == null ? 0 : this.javaElement.hashCode());
        result = 31 * result + (this.javaTypeReference == null ? 0 : this.javaTypeReference.hashCode());
        result = 31 * result + (this.nonJavaElement == null ? 0 : this.nonJavaElement.hashCode());
        return result;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(this.getClass().getSimpleName()).append('[');
        buf.append("kind=").append((Object)this.kind).append(';');
        buf.append("javaElement=").append(this.javaElement).append(';');
        buf.append("externalTypeReference=").append(this.javaTypeReference).append(';');
        buf.append("nonJavaElement=").append(this.nonJavaElement).append(';');
        buf.append("category=").append(this.category).append(';');
        buf.append("description=").append(this.description).append(';');
        buf.append("displayName=").append(this.displayName).append(';');
        buf.append("feature=").append(this.feature).append(']');
        return buf.toString();
    }
}

