/*******************************************************************************
 * Copyright (c) 2008, 2009 Ecliptical Software Inc. and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Ecliptical Software Inc. - initial API and implementation
 *******************************************************************************/
package org.eclipse.emf.mint.internal.genmodel;

import java.util.Collections;
import java.util.List;

import org.eclipse.emf.codegen.ecore.genmodel.GenDataType;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelPackage;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.mint.IItemJavaElementDescriptor;

public class GenDataTypeItemProvider extends GenClassifierItemProvider {

	protected static final List<EReference> GROUP_REFERENCES = appendList(
			GenClassifierItemProvider.GROUP_REFERENCES,
			GenModelPackage.Literals.GEN_DATA_TYPE__ECORE_DATA_TYPE);

	public GenDataTypeItemProvider(GenModelJavaElementSourceContributor sourceContributor) {
		super(sourceContributor);
	}

	@Override
	public List<IItemJavaElementDescriptor> getJavaElementDescriptors(
			Object object) {
		GenDataType genDataType = (GenDataType) object;
		if (!isFullyResolved(genDataType))
			return Collections.emptyList();

		UniqueEList<IItemJavaElementDescriptor> list = new UniqueEList<IItemJavaElementDescriptor>();

		GenModel genModel = genDataType.getGenModel();
		String modelDir = genModel.getModelDirectory();
		addType(modelDir, genDataType.getQualifiedInstanceClassName(),
				CAT_IMPLEMENTATION,
				Messages.GenDataTypeItemProvider_InstanceClassLabel,
				Messages.GenDataTypeItemProvider_InstanceClassDescription,
				null, list);

		return list;
	}

	@Override
	protected GroupReferenceGenModelSwitch createGroupReferenceGenModelSwitch() {
		return new GenDataTypeGroupReferenceGenModelSwitch();
	}

	protected static class GenDataTypeGroupReferenceGenModelSwitch extends
			GenClassifierGroupReferenceGenModelSwitch {

		@Override
		public List<EReference> caseGenDataType(GenDataType object) {
			return GROUP_REFERENCES;
		}
	}
}
