/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.giraph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.henshin.giraph.GiraphRuleData;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.Module;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.Unit;

public class GiraphUtil {
    public static String getInstanceCode(Graph graph) throws Exception {
        StringBuffer json = new StringBuffer();
        ArrayList<ENamedElement> types = new ArrayList<ENamedElement>(GiraphUtil.getTypeConstants(graph.getRule().getModule()).keySet());
        int i = 0;
        while (i < graph.getNodes().size()) {
            Node n = (Node)graph.getNodes().get(i);
            json.append("[[" + i + "]," + types.indexOf(n.getType()) + ",[");
            int j = 0;
            while (j < n.getOutgoing().size()) {
                Edge e = (Edge)n.getOutgoing().get(j);
                int trg = graph.getNodes().indexOf((Object)e.getTarget());
                json.append("[[" + trg + "]," + types.indexOf(e.getType()) + "]");
                if (j < n.getOutgoing().size() - 1) {
                    json.append(",");
                }
                ++j;
            }
            json.append("]]\n");
            ++i;
        }
        return json.toString();
    }

    public static Map<Unit, String> getUnitConstants(Unit mainUnit) {
        EList units = mainUnit.getSubUnits(true);
        units.add(0, (Object)mainUnit);
        LinkedHashMap<Unit, String> unitConstants = new LinkedHashMap<Unit, String>();
        for (Unit unit : units) {
            String name = String.valueOf(unit instanceof Rule ? "RULE" : "UNIT") + "_" + GiraphUtil.camelCase2Upper(unit.getName());
            unitConstants.put(unit, name);
        }
        return unitConstants;
    }

    public static Map<ENamedElement, String> getTypeConstants(Module module) {
        boolean needPackage = false;
        HashSet<String> classNames = new HashSet<String>();
        block0: for (EPackage pack : module.getImports()) {
            for (EClassifier classifier : pack.getEClassifiers()) {
                if (!(classifier instanceof EClass)) continue;
                if (classNames.contains(classifier.getName())) {
                    needPackage = true;
                    continue block0;
                }
                classNames.add(classifier.getName());
            }
        }
        LinkedHashMap<ENamedElement, String> typeConstants = new LinkedHashMap<ENamedElement, String>();
        for (EPackage pack : module.getImports()) {
            for (EClassifier classifier : pack.getEClassifiers()) {
                if (!(classifier instanceof EClass)) continue;
                String name = "TYPE_";
                if (needPackage) {
                    name = String.valueOf(name) + GiraphUtil.camelCase2Upper(pack.getName()) + "_";
                }
                name = String.valueOf(name) + GiraphUtil.camelCase2Upper(classifier.getName());
                typeConstants.put((ENamedElement)classifier, name);
                for (EReference ref : ((EClass)classifier).getEReferences()) {
                    typeConstants.put((ENamedElement)ref, String.valueOf(name) + "_" + GiraphUtil.camelCase2Upper(ref.getName()));
                }
            }
        }
        return typeConstants;
    }

    public static Collection<Rule> collectRules(Unit unit) {
        LinkedHashSet<Rule> rules = new LinkedHashSet<Rule>();
        if (unit instanceof Rule) {
            rules.add((Rule)unit);
        }
        for (Unit subUnit : unit.getSubUnits(true)) {
            if (!(subUnit instanceof Rule)) continue;
            rules.add((Rule)subUnit);
        }
        return rules;
    }

    public static String getNodeName(Node node) {
        return node.getName() != null && node.getName().trim().length() > 0 ? "\"" + node.getName() + "\"" : "" + node.getGraph().getNodes().indexOf((Object)node);
    }

    private static String camelCase2Upper(String s) {
        String r = "";
        boolean u = false;
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            char C = Character.toUpperCase(c);
            if (Character.isUpperCase(c)) {
                r = String.valueOf(r) + (u ? "_" + C : Character.valueOf(C));
            } else {
                u = true;
                r = String.valueOf(r) + C;
            }
            ++i;
        }
        return r;
    }

    public static Map<Rule, GiraphRuleData> generateRuleData(Unit mainUnit) throws Exception {
        LinkedHashMap<Rule, GiraphRuleData> data = new LinkedHashMap<Rule, GiraphRuleData>();
        for (Rule rule : GiraphUtil.collectRules(mainUnit)) {
            data.put(rule, new GiraphRuleData(rule));
        }
        return data;
    }

    public static List<EClass> getValidTypes(Node node, Module module) {
        Set<ENamedElement> allTypes = GiraphUtil.getTypeConstants(module).keySet();
        ArrayList<EClass> types = new ArrayList<EClass>();
        for (ENamedElement type : allTypes) {
            if (!(type instanceof EClass) || type != node.getType() && !((EClass)type).getEAllSuperTypes().contains((Object)node.getType())) continue;
            types.add((EClass)type);
        }
        return types;
    }
}

