/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.eef.codegen.core.initializer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.codegen.ecore.genmodel.GenAnnotation;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.eef.codegen.core.initializer.AbstractTransformer;
import org.eclipse.emf.eef.toolkits.Widget;
import org.eclipse.emf.eef.views.Category;
import org.eclipse.emf.eef.views.Container;
import org.eclipse.emf.eef.views.CustomView;
import org.eclipse.emf.eef.views.ElementEditor;
import org.eclipse.emf.eef.views.View;
import org.eclipse.emf.eef.views.ViewElement;
import org.eclipse.emf.eef.views.ViewsFactory;
import org.eclipse.emf.eef.views.ViewsRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewTransformer
extends AbstractTransformer {
    private Map<String, EObject> toolkits;
    private Map<EObject, List<ViewElement>> workingResolvTemp;
    private ViewsRepository repository;

    public ViewTransformer(Map<String, EObject> toolkits) {
        this.toolkits = toolkits;
        this.workingResolvTemp = new HashMap<EObject, List<ViewElement>>();
    }

    public Map<EObject, List<ViewElement>> getWorkingResolvTemp() {
        return this.workingResolvTemp;
    }

    public void addElementToEObject(EObject source, ViewElement element) {
        if (this.workingResolvTemp.get(source) != null) {
            this.workingResolvTemp.get(source).add(element);
        } else {
            UniqueEList list = new UniqueEList();
            list.add(element);
            this.workingResolvTemp.put(source, (List<ViewElement>)list);
        }
    }

    public ViewsRepository genPackage2ViewsRepository(GenPackage genPackage, String repositoryKind) {
        this.repository = ViewsFactory.eINSTANCE.createViewsRepository();
        this.repository.getRepositoryKind().add((Object)"SWT");
        this.repository.getRepositoryKind().add((Object)"Form");
        this.repository.setName(genPackage.getEcorePackage().getName());
        this.repository.setDocumentation("Views repository for " + genPackage.getEcorePackage().getName() + " GenPackage");
        Category views = ViewsFactory.eINSTANCE.createCategory();
        views.setName(genPackage.getEcorePackage().getName());
        this.repository.getCategories().add((Object)views);
        for (GenClass genClass : genPackage.getGenClasses()) {
            if (genClass.getEcoreClass().isAbstract()) continue;
            views.getViews().addAll(this.genClass2Views(genClass));
        }
        return this.repository;
    }

    public List<View> genClass2Views(GenClass genClass) {
        ArrayList<View> result = new ArrayList<View>();
        View view = ViewsFactory.eINSTANCE.createView();
        view.setExplicit(true);
        View additionalView = this.genClass2AdditionalView(genClass);
        view.setName(genClass.getName());
        Map<String, List<EStructuralFeature>> groups = this.genClassGroups(genClass);
        for (String name : groups.keySet()) {
            if (name.equals("view")) continue;
            Container container = ViewsFactory.eINSTANCE.createContainer();
            container.setName(name);
            container.setRepresentation(this.getWidget("Group"));
            List<EStructuralFeature> features = groups.get(name);
            for (EStructuralFeature structuralFeature : features) {
                ElementEditor editor;
                if (structuralFeature.isDerived() || this.isUnmanagedReference(structuralFeature) || (editor = this.eStructuralFeature2ViewElement(structuralFeature)) == null) continue;
                container.getElements().add((Object)editor);
            }
            view.getElements().add((Object)container);
        }
        if (groups.get("view") != null) {
            List<EStructuralFeature> features = groups.get("view");
            for (EStructuralFeature structuralFeature : features) {
                ElementEditor editor;
                if (structuralFeature.isDerived() || (editor = this.eStructuralFeature2ViewElement(structuralFeature)) == null) continue;
                view.getElements().add((Object)editor);
            }
        }
        result.add(view);
        this.addElementToEObject((EObject)genClass.getEcoreClass(), (ViewElement)view);
        if (additionalView != null) {
            result.add(additionalView);
            this.addElementToEObject((EObject)genClass.getEcoreClass(), (ViewElement)additionalView);
        }
        return result;
    }

    public View genClass2AdditionalView(GenClass genClass) {
        CustomView newView = null;
        GenAnnotation genAnnotation = genClass.getGenAnnotation("component");
        if (genAnnotation != null) {
            newView = ViewsFactory.eINSTANCE.createCustomView();
            String name = (String)genAnnotation.getDetails().get((Object)"name");
            if (name != null) {
                newView.setName(String.valueOf(genClass.getName()) + name);
            }
        }
        return newView;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ElementEditor eStructuralFeature2ViewElement(EStructuralFeature feature) {
        ElementEditor result = ViewsFactory.eINSTANCE.createElementEditor();
        result.setName(feature.getName());
        if (feature instanceof EAttribute) {
            if (feature.isMany()) {
                result.setRepresentation(this.getWidget("MultiValuedEditor"));
            } else if (feature.getEType().getName().equals("EBoolean") || feature.getEType().getName().equals("EBool") || feature.getEType().getName().equalsIgnoreCase("Boolean")) {
                result.setRepresentation(this.getWidget("Checkbox"));
            } else if (EcorePackage.eINSTANCE.getEEnum().isInstance((Object)feature.getEType())) {
                result.setRepresentation(this.getWidget("EMFComboViewer"));
            } else if ("documentation".equals(feature.getName())) {
                result.setRepresentation(this.getWidget("Textarea"));
            } else {
                result.setRepresentation(this.getWidget("Text"));
            }
        } else if (feature instanceof EReference) {
            EReference reference = (EReference)feature;
            if (reference.isContainment()) {
                if (!reference.isMany()) return null;
                result.setRepresentation(this.getWidget("AdvancedTableComposition"));
            } else if (reference.isMany()) {
                result.setRepresentation(this.getWidget("AdvancedReferencesTable"));
            } else {
                result.setRepresentation(this.getWidget("EObjectFlatComboViewer"));
            }
        }
        this.addElementToEObject((EObject)feature, (ViewElement)result);
        return result;
    }

    protected Widget getWidget(String name) {
        if (name != null) {
            for (String key : this.toolkits.keySet()) {
                EObject toolkit = this.toolkits.get(key);
                TreeIterator iter = toolkit.eAllContents();
                while (iter.hasNext()) {
                    EObject next = (EObject)iter.next();
                    if (!(next instanceof Widget) || !name.equals(((Widget)next).getName())) continue;
                    return (Widget)next;
                }
            }
        }
        return null;
    }

    private Map<String, List<EStructuralFeature>> genClassGroups(GenClass genClass) {
        HashMap<String, List<EStructuralFeature>> result = new HashMap<String, List<EStructuralFeature>>();
        for (EStructuralFeature feature : genClass.getEcoreClass().getEAllStructuralFeatures()) {
            if (!this.isSignificant(feature) || this.getViewName(feature) != null) continue;
            String groupConstraint = this.genConstraint((EModelElement)feature, "group");
            if (groupConstraint != null) {
                this.addToGroup(result, feature, groupConstraint);
                continue;
            }
            String docConstraint = this.genConstraint((EModelElement)feature, "documentation");
            if ("true".equals(docConstraint)) {
                this.addToGroup(result, feature, "view");
                continue;
            }
            this.addToGroup(result, feature, "properties");
        }
        return result;
    }

    private void addToGroup(Map<String, List<EStructuralFeature>> result, EStructuralFeature feature, String genConstraint) {
        if (result.get(genConstraint) != null) {
            result.get(genConstraint).add(feature);
        } else {
            ArrayList<EStructuralFeature> list = new ArrayList<EStructuralFeature>();
            list.add(feature);
            result.put(genConstraint, list);
        }
    }
}

