/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.eef.runtime.query.ocl;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.eef.runtime.query.QueryProcessor;
import org.eclipse.emf.eef.runtime.query.QueryResult;
import org.eclipse.emf.eef.runtime.query.QueryWrapper;
import org.eclipse.emf.eef.runtime.query.ocl.OCLQuery;
import org.eclipse.ocl.EnvironmentFactory;
import org.eclipse.ocl.OCL;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.ecore.CallOperationAction;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.EcoreEnvironmentFactory;
import org.eclipse.ocl.ecore.SendSignalAction;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.helper.OCLHelper;

public class OCLProcessor
implements QueryProcessor {
    public static final String OCL_KIND = "ocl";
    private OCL<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> oclEnvironment = OCL.newInstance((EnvironmentFactory)EcoreEnvironmentFactory.INSTANCE);

    public boolean canEvaluate(QueryWrapper query) {
        return query.getKind() == OCL_KIND;
    }

    public QueryResult evaluate(EObject context, QueryWrapper query) {
        try {
            OCLQuery oclQuery = (OCLQuery)query;
            OCLHelper oclHelper = this.oclEnvironment.createOCLHelper();
            oclHelper.setContext((Object)oclQuery.getContext());
            String queryBody = oclQuery.getOclQuery();
            if (queryBody != null && !queryBody.equals("")) {
                OCLExpression parsedException = oclHelper.createQuery(queryBody);
                Object evaluationResult = this.oclEnvironment.evaluate((Object)context, parsedException);
                return new QueryResult(Status.OK_STATUS, evaluationResult);
            }
            return new QueryResult(Status.OK_STATUS, null);
        }
        catch (ParserException e) {
            return new QueryResult((IStatus)new Status(4, "org.eclipse.emf.eef.query", "Error parsing ocl query.", (Throwable)e), null);
        }
    }
}

