/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.eef.runtime.impl.utils;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.eef.runtime.impl.utils.EEFRuntimeMessages;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;

public class ModelViewerHelper {
    private static IStructuredSelection lastSelection;
    public static final String NAME;

    static {
        NAME = EEFRuntimeMessages.ModelViewerHelper_name_feature;
    }

    public static void setLastSelection(IStructuredSelection selection) {
        lastSelection = selection;
    }

    public static IStructuredSelection getLastSelection() {
        return lastSelection;
    }

    public static String getName(Object element) {
        if (element instanceof EObject) {
            String type;
            EObject eobj = (EObject)element;
            EStructuralFeature structuralFeature = eobj.eClass().getEStructuralFeature(NAME);
            if (structuralFeature != null) {
                Object name = eobj.eGet(structuralFeature);
                if (name == null) {
                    return null;
                }
                return name.toString();
            }
            if (eobj instanceof EClass && (type = ((EClass)eobj).getName()) != null && type != "") {
                return type;
            }
            return null;
        }
        return null;
    }

    public static void setSelectedElement(TreeViewer treeViewer, IResource resource) {
        ArrayList<IContainer> itemsToExpand = new ArrayList<IContainer>();
        IContainer parent = resource.getParent();
        while (parent != null) {
            itemsToExpand.add(0, parent);
            parent = parent.getParent();
        }
        treeViewer.setExpandedElements(itemsToExpand.toArray());
        treeViewer.setSelection((ISelection)new StructuredSelection((Object)resource), true);
    }
}

