/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.signal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.text.MessageFormat;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.internal.net4j.bundle.OM;
import org.eclipse.net4j.buffer.BufferInputStream;
import org.eclipse.net4j.buffer.IBuffer;
import org.eclipse.net4j.buffer.IBufferProvider;
import org.eclipse.net4j.channel.ChannelOutputStream;
import org.eclipse.net4j.protocol.Protocol;
import org.eclipse.net4j.signal.Signal;
import org.eclipse.net4j.signal.SignalActor;
import org.eclipse.net4j.signal.SignalReactor;
import org.eclipse.net4j.util.io.IStreamWrapper;
import org.eclipse.net4j.util.io.StreamWrapperChain;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SignalProtocol
extends Protocol {
    public static final long NO_TIMEOUT = -1L;
    private static final int MIN_CORRELATION_ID = 1;
    private static final int MAX_CORRELATION_ID = Integer.MAX_VALUE;
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_SIGNAL, SignalProtocol.class);
    private static final ContextTracer STREAM_TRACER = new ContextTracer(OM.DEBUG_BUFFER_STREAM, SignalProtocol.class);
    private IStreamWrapper streamWrapper;
    private Map<Integer, Signal> signals = new ConcurrentHashMap<Integer, Signal>(0);
    private int nextCorrelationID = 1;

    protected SignalProtocol() {
    }

    public IStreamWrapper getStreamWrapper() {
        return this.streamWrapper;
    }

    public void setStreamWrapper(IStreamWrapper streamWrapper) {
        this.streamWrapper = streamWrapper;
    }

    public void addStreamWrapper(IStreamWrapper streamWrapper) {
        this.streamWrapper = this.streamWrapper == null ? streamWrapper : new StreamWrapperChain(streamWrapper, this.streamWrapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean waitForSignals(long timeout) {
        Map<Integer, Signal> map = this.signals;
        synchronized (map) {
            while (!this.signals.isEmpty()) {
                try {
                    this.signals.wait(timeout);
                }
                catch (InterruptedException interruptedException) {
                    return false;
                }
            }
            return true;
        }
    }

    public InputStream wrapInputStream(InputStream in) throws IOException {
        if (this.streamWrapper != null) {
            in = this.streamWrapper.wrapInputStream(in);
        }
        return in;
    }

    public OutputStream wrapOutputStream(OutputStream out) throws IOException {
        if (this.streamWrapper != null) {
            out = this.streamWrapper.wrapOutputStream(out);
        }
        return out;
    }

    public void finishInputStream(InputStream in) throws IOException {
        if (this.streamWrapper != null) {
            this.streamWrapper.finishInputStream(in);
        }
    }

    public void finishOutputStream(OutputStream out) throws IOException {
        if (this.streamWrapper != null) {
            this.streamWrapper.finishOutputStream(out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleBuffer(IBuffer buffer) {
        Signal signal;
        ByteBuffer byteBuffer = buffer.getByteBuffer();
        int correlationID = byteBuffer.getInt();
        if (TRACER.isEnabled()) {
            TRACER.trace("Received buffer for correlation " + correlationID);
        }
        Map<Integer, Signal> map = this.signals;
        synchronized (map) {
            if (correlationID > 0) {
                signal = this.signals.get(-correlationID);
                if (signal == null) {
                    short signalID = byteBuffer.getShort();
                    if (TRACER.isEnabled()) {
                        TRACER.trace("Got signal id " + signalID);
                    }
                    signal = this.provideSignalReactor(signalID);
                    signal.setProtocol(this);
                    signal.setCorrelationID(-correlationID);
                    signal.setBufferInputStream(new SignalInputStream(this.getInputStreamTimeout()));
                    signal.setBufferOutputStream(new SignalOutputStream(-correlationID, signalID, false));
                    this.signals.put(-correlationID, signal);
                    this.getExecutorService().execute(signal);
                }
            } else {
                signal = this.signals.get(-correlationID);
                if (signal == null) {
                    if (TRACER.isEnabled()) {
                        TRACER.trace("Discarding buffer");
                    }
                    buffer.release();
                }
            }
        }
        if (signal != null) {
            BufferInputStream inputStream = signal.getBufferInputStream();
            inputStream.handleBuffer(buffer);
        }
    }

    public long getInputStreamTimeout() {
        return -1L;
    }

    public String toString() {
        return MessageFormat.format("SignalProtocol[{0}]", this.getType());
    }

    protected final SignalReactor provideSignalReactor(short signalID) {
        this.checkActive();
        SignalReactor signal = this.createSignalReactor(signalID);
        if (signal == null) {
            throw new IllegalArgumentException("Invalid signalID " + signalID);
        }
        return signal;
    }

    protected abstract SignalReactor createSignalReactor(short var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startSignal(SignalActor<?> signalActor, long timeout) throws Exception {
        if (signalActor.getProtocol() != this) {
            throw new IllegalArgumentException("signalActor.getProtocol() != this");
        }
        short signalID = signalActor.getSignalID();
        int correlationID = signalActor.getCorrelationID();
        signalActor.setBufferInputStream(new SignalInputStream(timeout));
        signalActor.setBufferOutputStream(new SignalOutputStream(correlationID, signalID, true));
        Map<Integer, Signal> map = this.signals;
        synchronized (map) {
            this.signals.put(correlationID, signalActor);
        }
        signalActor.runSync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopSignal(Signal signal) {
        int correlationID = signal.getCorrelationID();
        Map<Integer, Signal> map = this.signals;
        synchronized (map) {
            this.signals.remove(correlationID);
            this.signals.notifyAll();
        }
    }

    synchronized int getNextCorrelationID() {
        int correlationID = this.nextCorrelationID;
        if (this.nextCorrelationID == Integer.MAX_VALUE) {
            if (TRACER.isEnabled()) {
                TRACER.trace("Correlation wrap around");
            }
            this.nextCorrelationID = 1;
        } else {
            ++this.nextCorrelationID;
        }
        return correlationID;
    }

    class SignalInputStream
    extends BufferInputStream {
        private long timeout;

        public SignalInputStream(long timeout) {
            this.timeout = timeout;
        }

        public long getMillisBeforeTimeout() {
            return this.timeout;
        }
    }

    class SignalOutputStream
    extends ChannelOutputStream {
        public SignalOutputStream(final int correlationID, final short signalID, boolean addSignalID) {
            super(SignalProtocol.this.getChannel(), new IBufferProvider(addSignalID){
                private IBufferProvider delegate;
                private boolean firstBuffer;
                {
                    this.delegate = SignalProtocol.this.getBufferProvider();
                    this.firstBuffer = bl;
                }

                public short getBufferCapacity() {
                    return this.delegate.getBufferCapacity();
                }

                public IBuffer provideBuffer() {
                    IBuffer buffer = this.delegate.provideBuffer();
                    ByteBuffer byteBuffer = buffer.startPutting(SignalProtocol.this.getChannel().getChannelIndex());
                    if (STREAM_TRACER.isEnabled()) {
                        STREAM_TRACER.trace("Providing buffer for correlation " + correlationID);
                    }
                    byteBuffer.putInt(correlationID);
                    if (this.firstBuffer) {
                        if (TRACER.isEnabled()) {
                            STREAM_TRACER.trace("Put signal id " + signalID);
                        }
                        byteBuffer.putShort(signalID);
                    }
                    this.firstBuffer = false;
                    return buffer;
                }

                public void retainBuffer(IBuffer buffer) {
                    this.delegate.retainBuffer(buffer);
                }
            });
        }
    }
}

