/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.internal.net4j.connector;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.internal.net4j.bundle.OM;
import org.eclipse.internal.net4j.channel.Channel;
import org.eclipse.net4j.buffer.IBufferProvider;
import org.eclipse.net4j.channel.IChannel;
import org.eclipse.net4j.connector.ConnectorException;
import org.eclipse.net4j.connector.ConnectorLocation;
import org.eclipse.net4j.connector.ConnectorState;
import org.eclipse.net4j.connector.IConnector;
import org.eclipse.net4j.connector.IConnectorStateEvent;
import org.eclipse.net4j.protocol.IProtocol;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.concurrent.RWLock;
import org.eclipse.net4j.util.concurrent.TimeoutRuntimeException;
import org.eclipse.net4j.util.container.Container;
import org.eclipse.net4j.util.container.IContainer;
import org.eclipse.net4j.util.container.IContainerDelta;
import org.eclipse.net4j.util.container.IContainerEvent;
import org.eclipse.net4j.util.container.IElementProcessor;
import org.eclipse.net4j.util.container.LifecycleEventConverter;
import org.eclipse.net4j.util.event.Event;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.event.INotifier;
import org.eclipse.net4j.util.event.Notifier;
import org.eclipse.net4j.util.factory.FactoryKey;
import org.eclipse.net4j.util.factory.IFactory;
import org.eclipse.net4j.util.factory.IFactoryKey;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.monitor.MonitorUtil;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.eclipse.net4j.util.registry.IRegistry;
import org.eclipse.net4j.util.security.INegotiationContext;
import org.eclipse.net4j.util.security.INegotiator;
import org.eclipse.spi.net4j.InternalChannel;
import org.eclipse.spi.net4j.InternalConnector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Connector
extends Container<IChannel>
implements InternalConnector {
    public static final long NO_OPEN_CHANNEL_TIMEOUT = Long.MAX_VALUE;
    public static final long DEFAULT_OPEN_CHANNEL_TIMEOUT = -1L;
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_CONNECTOR, Connector.class);
    private String userID;
    private IRegistry<IFactoryKey, IFactory> protocolFactoryRegistry;
    private List<IElementProcessor> protocolPostProcessors;
    private INegotiator negotiator;
    private INegotiationContext negotiationContext;
    private IBufferProvider bufferProvider;
    private ExecutorService receiveExecutor;
    private long openChannelTimeout = -1L;
    private transient int nextChannelID;
    private transient List<InternalChannel> channels = new ArrayList<InternalChannel>(0);
    private transient RWLock channelsLock = new RWLock(2500L);
    private transient ConnectorState connectorState = ConnectorState.DISCONNECTED;
    private transient IListener channelListener = new LifecycleEventConverter<IChannel>((Notifier)this){

        protected IContainerEvent<IChannel> createContainerEvent(IContainer<IChannel> container, IChannel element, IContainerDelta.Kind kind) {
            return (IContainerEvent)Connector.this.newContainerEvent(element, kind);
        }
    };
    private transient CountDownLatch finishedConnecting;
    private transient CountDownLatch finishedNegotiating;

    @Override
    public ExecutorService getReceiveExecutor() {
        return this.receiveExecutor;
    }

    @Override
    public void setReceiveExecutor(ExecutorService receiveExecutor) {
        this.receiveExecutor = receiveExecutor;
    }

    @Override
    public IRegistry<IFactoryKey, IFactory> getProtocolFactoryRegistry() {
        return this.protocolFactoryRegistry;
    }

    @Override
    public void setProtocolFactoryRegistry(IRegistry<IFactoryKey, IFactory> protocolFactoryRegistry) {
        this.protocolFactoryRegistry = protocolFactoryRegistry;
    }

    @Override
    public List<IElementProcessor> getProtocolPostProcessors() {
        return this.protocolPostProcessors;
    }

    @Override
    public void setProtocolPostProcessors(List<IElementProcessor> protocolPostProcessors) {
        this.protocolPostProcessors = protocolPostProcessors;
    }

    @Override
    public IBufferProvider getBufferProvider() {
        return this.bufferProvider;
    }

    @Override
    public void setBufferProvider(IBufferProvider bufferProvider) {
        this.bufferProvider = bufferProvider;
    }

    @Override
    public INegotiator getNegotiator() {
        return this.negotiator;
    }

    @Override
    public void setNegotiator(INegotiator negotiator) {
        this.negotiator = negotiator;
    }

    public INegotiationContext getNegotiationContext() {
        return this.negotiationContext;
    }

    public long getOpenChannelTimeout() {
        if (this.openChannelTimeout == -1L) {
            return OM.BUNDLE.getDebugSupport().getDebugOption("open.channel.timeout", 10000);
        }
        return this.openChannelTimeout;
    }

    public void setOpenChannelTimeout(long openChannelTimeout) {
        this.openChannelTimeout = openChannelTimeout;
    }

    @Override
    public boolean isClient() {
        return this.getLocation() == ConnectorLocation.CLIENT;
    }

    @Override
    public boolean isServer() {
        return this.getLocation() == ConnectorLocation.SERVER;
    }

    @Override
    public String getUserID() {
        return this.userID;
    }

    public void setUserID(String userID) {
        if (TRACER.isEnabled()) {
            TRACER.format("Setting userID {0} for {1}", new Object[]{userID, this});
        }
        this.userID = userID;
    }

    @Override
    public ConnectorState getState() {
        return this.connectorState;
    }

    public void setState(ConnectorState newState) throws ConnectorException {
        ConnectorState oldState = this.getState();
        if (newState != oldState) {
            if (TRACER.isEnabled()) {
                TRACER.format("Setting state {0} (was {1}) for {2}", new Object[]{newState, oldState.toString().toLowerCase(), this});
            }
            this.connectorState = newState;
            switch (newState) {
                case DISCONNECTED: {
                    if (this.finishedConnecting != null) {
                        this.finishedConnecting.countDown();
                        this.finishedConnecting = null;
                    }
                    if (this.finishedNegotiating == null) break;
                    this.finishedNegotiating.countDown();
                    this.finishedNegotiating = null;
                    break;
                }
                case CONNECTING: {
                    this.finishedConnecting = new CountDownLatch(1);
                    this.finishedNegotiating = new CountDownLatch(1);
                    break;
                }
                case NEGOTIATING: {
                    this.finishedConnecting.countDown();
                    this.negotiationContext = this.createNegotiationContext();
                    this.negotiator.negotiate(this.negotiationContext);
                    break;
                }
                case CONNECTED: {
                    this.negotiationContext = null;
                    this.deferredActivate();
                    this.finishedConnecting.countDown();
                    this.finishedNegotiating.countDown();
                }
            }
            this.fireEvent(new ConnectorStateEvent((INotifier)this, oldState, newState));
        }
    }

    public boolean isDisconnected() {
        return this.connectorState == ConnectorState.DISCONNECTED;
    }

    public boolean isConnecting() {
        return this.connectorState == ConnectorState.CONNECTING;
    }

    public boolean isNegotiating() {
        return this.connectorState == ConnectorState.NEGOTIATING;
    }

    @Override
    public boolean isConnected() {
        return this.connectorState == ConnectorState.CONNECTED;
    }

    @Override
    public void connectAsync() throws ConnectorException {
        try {
            this.activate();
        }
        catch (ConnectorException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ConnectorException(ex);
        }
    }

    @Override
    public boolean waitForConnection(long timeout) throws ConnectorException {
        try {
            if (TRACER.isEnabled()) {
                TRACER.trace("Waiting for connection...");
            }
            while (this.finishedNegotiating != null && !this.finishedNegotiating.await(Math.min(100L, timeout), TimeUnit.MILLISECONDS) && !MonitorUtil.isCanceled() && (timeout -= 100L) > 0L) {
            }
            return this.isConnected();
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
    }

    @Override
    public boolean connect(long timeout) throws ConnectorException {
        this.connectAsync();
        return this.waitForConnection(timeout);
    }

    @Override
    public ConnectorException disconnect() {
        Exception ex = this.deactivate();
        if (ex == null) {
            return null;
        }
        if (ex instanceof ConnectorException) {
            return (ConnectorException)ex;
        }
        return new ConnectorException(ex);
    }

    @Override
    public IChannel[] getChannels() {
        final ArrayList result = new ArrayList(0);
        this.channelsLock.read(new Runnable(){

            public void run() {
                for (InternalChannel channel : Connector.this.channels) {
                    if (channel == null) continue;
                    result.add(channel);
                }
            }
        });
        return result.toArray(new IChannel[result.size()]);
    }

    public boolean isEmpty() {
        return this.getElements().length == 0;
    }

    public IChannel[] getElements() {
        return this.getChannels();
    }

    @Override
    public IChannel openChannel() throws ConnectorException {
        return this.openChannel(null);
    }

    @Override
    public IChannel openChannel(String protocolID, Object infraStructure) throws ConnectorException {
        IProtocol protocol = this.createProtocol(protocolID, infraStructure);
        if (protocol == null) {
            throw new IllegalArgumentException("Unknown protocolID: " + protocolID);
        }
        return this.openChannel(protocol);
    }

    @Override
    public IChannel openChannel(IProtocol protocol) throws ConnectorException {
        long openChannelTimeout = this.getOpenChannelTimeout();
        long start = System.currentTimeMillis();
        if (!this.waitForConnection(openChannelTimeout)) {
            throw new ConnectorException("Connector not connected");
        }
        long elapsed = System.currentTimeMillis() - start;
        int channelID = this.getNextChannelID();
        InternalChannel channel = this.createChannel(channelID, protocol);
        try {
            try {
                this.registerChannelWithPeer(channelID, channel.getChannelIndex(), protocol, openChannelTimeout - elapsed);
            }
            catch (TimeoutRuntimeException timeoutRuntimeException) {
                throw new TimeoutRuntimeException("Registration timeout  after " + openChannelTimeout + " milliseconds");
            }
            channel.activate();
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ConnectorException(ex);
        }
        return channel;
    }

    public InternalChannel createChannel(int channelID, short channelIndex, String protocolID) {
        IProtocol protocol = this.createProtocol(protocolID, null);
        return this.createAndAddChannel(channelID, channelIndex, protocol);
    }

    protected InternalChannel createChannelWithoutChannelIndex(int channelID, IProtocol protocol) {
        InternalChannel channel = this.createChannel();
        channel.setChannelID(channelID);
        if (protocol != null) {
            protocol.setChannel(channel);
            LifecycleUtil.activate((Object)protocol);
            if (TRACER.isEnabled()) {
                String protocolType = protocol == null ? null : protocol.getType();
                TRACER.format("Opening channel ID {0} with protocol {1}", new Object[]{channelID, protocolType});
            }
        } else if (TRACER.isEnabled()) {
            TRACER.format("Opening channel ID {0} without protocol", new Object[]{channelID});
        }
        channel.setReceiveHandler(protocol);
        channel.addListener(this.channelListener);
        return channel;
    }

    public InternalChannel createAndAddChannel(int channelID, short channelIndex, IProtocol protocol) {
        InternalChannel channel = this.createChannelWithoutChannelIndex(channelID, protocol);
        channel.setChannelIndex(channelIndex);
        this.addChannelWithIndex(channel);
        return channel;
    }

    public InternalChannel createChannel(int channelID, IProtocol protocol) {
        InternalChannel channel = this.createChannelWithoutChannelIndex(channelID, protocol);
        this.addChannelWithoutIndex(channel);
        return channel;
    }

    protected InternalChannel createChannel() {
        InternalChannel channel = this.createChannelInstance();
        channel.setChannelMultiplexer(this);
        channel.setReceiveExecutor(this.receiveExecutor);
        return channel;
    }

    protected InternalChannel createChannelInstance() {
        return new Channel();
    }

    public InternalChannel getChannel(final short channelIndex) {
        return (InternalChannel)this.channelsLock.read((Callable)new Callable<InternalChannel>(){

            @Override
            public InternalChannel call() throws Exception {
                return (InternalChannel)Connector.this.channels.get(channelIndex);
            }
        });
    }

    protected int getNextChannelID() {
        return this.nextChannelID++;
    }

    protected void addChannelWithIndex(final InternalChannel channel) {
        this.channelsLock.write(new Runnable(){

            public void run() {
                short channelIndex = channel.getChannelIndex();
                while (channelIndex >= Connector.this.channels.size()) {
                    Connector.this.channels.add(null);
                }
                Connector.this.channels.set(channelIndex, channel);
            }
        });
    }

    protected void addChannelWithoutIndex(final InternalChannel channel) {
        this.channelsLock.write(new Runnable(){

            public void run() {
                short s = Connector.this.channels.size();
                short i = 0;
                while (i < s) {
                    if (Connector.this.channels.get(i) == null) {
                        Connector.this.channels.set(i, channel);
                        channel.setChannelIndex(i);
                        return;
                    }
                    i = (short)(i + 1);
                }
                channel.setChannelIndex(s);
                Connector.this.channels.add(channel);
            }
        });
    }

    @Override
    public boolean removeChannel(final IChannel channel) {
        if (channel == null) {
            throw new IllegalArgumentException("channel == null");
        }
        if (!this.isConnected()) {
            return false;
        }
        final short channelIndex = channel.getChannelIndex();
        boolean removed = false;
        try {
            removed = (Boolean)this.channelsLock.write((Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    if (channelIndex < Connector.this.channels.size() && Connector.this.channels.get(channelIndex) == channel) {
                        if (TRACER.isEnabled()) {
                            TRACER.trace("Removing channel " + channelIndex);
                        }
                        Connector.this.channels.set(channelIndex, null);
                        return true;
                    }
                    return false;
                }
            });
            if (removed) {
                channel.removeListener(this.channelListener);
                channel.close();
            }
        }
        catch (RuntimeException ex) {
            Exception unwrapped = WrappedException.unwrap((Exception)ex);
            if (unwrapped instanceof TimeoutException) {
                InternalChannel c;
                if (channelIndex < this.channels.size() && (c = this.channels.get(channelIndex)) != null && c.isActive()) {
                    throw ex;
                }
            }
            throw ex;
        }
        return removed;
    }

    public void inverseRemoveChannel(int channelID, short channelIndex) {
        try {
            InternalChannel channel = this.getChannel(channelIndex);
            if (channel != null) {
                if (channel.getChannelID() != channelID) {
                    if (TRACER.isEnabled()) {
                        TRACER.format("Ignoring concurrent atempt to remove channel {0} (channelID={1}", new Object[]{channelIndex, channelID});
                    }
                } else {
                    this.removeChannel(channel);
                }
            }
        }
        catch (RuntimeException ex) {
            OM.LOG.warn((Throwable)ex);
        }
    }

    protected void leaveConnecting() {
        if (this.getNegotiator() == null) {
            this.setState(ConnectorState.CONNECTED);
        } else {
            this.setState(ConnectorState.NEGOTIATING);
        }
    }

    protected abstract INegotiationContext createNegotiationContext();

    protected IProtocol createProtocol(String type, Object infraStructure) {
        List<IElementProcessor> processors;
        if (StringUtil.isEmpty((String)type)) {
            return null;
        }
        IRegistry<IFactoryKey, IFactory> registry = this.getProtocolFactoryRegistry();
        if (registry == null) {
            throw new ConnectorException("No protocol registry configured");
        }
        IFactoryKey key = this.createProtocolFactoryKey(type);
        IFactory factory = (IFactory)registry.get((Object)key);
        if (factory == null) {
            throw new ConnectorException("Unknown protocol: " + type);
        }
        String description = null;
        IProtocol protocol = (IProtocol)factory.create(description);
        if (protocol == null) {
            throw new ConnectorException("Invalid protocol factory: " + type);
        }
        protocol.setBufferProvider(this.bufferProvider);
        protocol.setExecutorService(this.receiveExecutor);
        if (infraStructure != null) {
            protocol.setInfraStructure(infraStructure);
        }
        if ((processors = this.getProtocolPostProcessors()) != null) {
            for (IElementProcessor processor : processors) {
                protocol = (IProtocol)processor.process(null, key.getProductGroup(), key.getType(), description, (Object)protocol);
            }
        }
        return protocol;
    }

    protected IFactoryKey createProtocolFactoryKey(String type) {
        switch (this.getLocation()) {
            case SERVER: {
                return new FactoryKey("org.eclipse.net4j.serverProtocols", type);
            }
            case CLIENT: {
                return new FactoryKey("org.eclipse.net4j.clientProtocols", type);
            }
        }
        throw new IllegalStateException();
    }

    protected boolean isDeferredActivation() {
        return true;
    }

    protected void doBeforeActivate() throws Exception {
        super.doBeforeActivate();
        if (this.bufferProvider == null) {
            throw new IllegalStateException("bufferProvider == null");
        }
        if (this.protocolFactoryRegistry == null && TRACER.isEnabled()) {
            TRACER.trace("No factoryRegistry!");
        }
        if (this.receiveExecutor == null && TRACER.isEnabled()) {
            TRACER.trace("No receiveExecutor!");
        }
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        this.setState(ConnectorState.CONNECTING);
    }

    protected void doDeactivate() throws Exception {
        this.setState(ConnectorState.DISCONNECTED);
        this.channelsLock.write(new Runnable(){

            public void run() {
                int i = 0;
                while (i < Connector.this.channels.size()) {
                    InternalChannel channel = (InternalChannel)Connector.this.channels.get(i);
                    if (channel != null) {
                        LifecycleUtil.deactivate((Object)channel);
                    }
                    i = (short)(i + 1);
                }
                Connector.this.channels.clear();
            }
        });
        super.doDeactivate();
    }

    protected abstract void registerChannelWithPeer(int var1, short var2, IProtocol var3, long var4) throws ConnectorException;

    private static class ConnectorStateEvent
    extends Event
    implements IConnectorStateEvent {
        private static final long serialVersionUID = 1L;
        private ConnectorState oldState;
        private ConnectorState newState;

        public ConnectorStateEvent(INotifier notifier, ConnectorState oldState, ConnectorState newState) {
            super(notifier);
            this.oldState = oldState;
            this.newState = newState;
        }

        public IConnector getConnector() {
            return (IConnector)this.getSource();
        }

        public ConnectorState getOldState() {
            return this.oldState;
        }

        public ConnectorState getNewState() {
            return this.newState;
        }

        public String toString() {
            return MessageFormat.format("ConnectorStateEvent[source={0}, oldState={1}, newState={2}]", new Object[]{this.getSource(), this.getOldState(), this.getNewState()});
        }
    }
}

