/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db;

import java.util.List;
import org.eclipse.emf.cdo.common.model.CDOFeature;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.internal.server.StoreChunkReader;
import org.eclipse.emf.cdo.server.IStoreChunkReader;
import org.eclipse.emf.cdo.server.IStoreReader;
import org.eclipse.emf.cdo.server.db.IClassMapping;
import org.eclipse.emf.cdo.server.db.IDBStoreChunkReader;
import org.eclipse.emf.cdo.server.db.IDBStoreReader;
import org.eclipse.emf.cdo.server.db.IMappingStrategy;
import org.eclipse.emf.cdo.server.db.IReferenceMapping;
import org.eclipse.emf.cdo.server.internal.db.DBStoreReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBStoreChunkReader
extends StoreChunkReader
implements IDBStoreChunkReader {
    private IReferenceMapping referenceMapping;
    private StringBuilder builder = new StringBuilder();

    public DBStoreChunkReader(IDBStoreReader storeReader, CDORevision revision, CDOFeature feature) {
        super((IStoreReader)storeReader, revision, feature);
        IMappingStrategy mappingStrategy = storeReader.getStore().getMappingStrategy();
        IClassMapping mapping = mappingStrategy.getClassMapping(revision.getCDOClass());
        this.referenceMapping = mapping.getReferenceMapping(feature);
    }

    @Override
    public DBStoreReader getStoreReader() {
        return (DBStoreReader)super.getStoreReader();
    }

    public void addSimpleChunk(int index) {
        super.addSimpleChunk(index);
        this.builder.append(" AND ");
        this.builder.append("cdo_idx");
        this.builder.append("=");
        this.builder.append(index);
    }

    public void addRangedChunk(int fromIndex, int toIndex) {
        super.addRangedChunk(fromIndex, toIndex);
        this.builder.append(" AND ");
        this.builder.append("cdo_idx");
        this.builder.append(" BETWEEN ");
        this.builder.append(fromIndex);
        this.builder.append(" AND ");
        this.builder.append(toIndex - 1);
    }

    public List<IStoreChunkReader.Chunk> executeRead() {
        List chunks = this.getChunks();
        this.referenceMapping.readChunks(this, chunks, this.builder.toString());
        return chunks;
    }
}

