/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.annotations.mapper;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.teneo.PersistenceOptions;
import org.eclipse.emf.teneo.annotations.mapper.BaseEFeatureAnnotator;
import org.eclipse.emf.teneo.annotations.mapper.StoreMappingException;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEAttribute;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEStructuralFeature;
import org.eclipse.emf.teneo.annotations.pannotation.CascadeType;
import org.eclipse.emf.teneo.annotations.pannotation.EnumType;
import org.eclipse.emf.teneo.annotations.pannotation.Enumerated;
import org.eclipse.emf.teneo.annotations.pannotation.FetchType;
import org.eclipse.emf.teneo.annotations.pannotation.JoinTable;
import org.eclipse.emf.teneo.annotations.pannotation.OneToMany;
import org.eclipse.emf.teneo.annotations.pannotation.PAnnotation;
import org.eclipse.emf.teneo.annotations.pannotation.TemporalType;
import org.eclipse.emf.teneo.extension.ExtensionPoint;

public class OneToManyAttributeAnnotator
extends BaseEFeatureAnnotator
implements ExtensionPoint {
    protected static final Log log = LogFactory.getLog(OneToManyAttributeAnnotator.class);
    private TemporalType optionDefaultTemporal = null;

    public void annotate(PAnnotatedEAttribute aAttribute) {
        boolean otmWasSet;
        String logStr = String.valueOf(aAttribute.getModelEAttribute().getName()) + "/" + aAttribute.getModelEAttribute().getEContainingClass().getName();
        log.debug((Object)("EAttribute " + logStr + " needs a onetomany"));
        EAttribute eAttribute = (EAttribute)aAttribute.getModelElement();
        OneToMany otm = aAttribute.getOneToMany();
        boolean bl = otmWasSet = otm != null;
        if (otm == null) {
            log.debug((Object)"One to many not present adding one");
            otm = this.getFactory().createOneToMany();
            aAttribute.setOneToMany(otm);
            otm.setEModelElement((EModelElement)eAttribute);
            if (this.getPersistenceOptions().isFetchContainmentEagerly()) {
                otm.setFetch(FetchType.EAGER);
            } else if (this.getPersistenceOptions().isFetchAssociationExtraLazy()) {
                otm.setFetch(FetchType.EXTRA);
            }
        } else {
            log.debug((Object)"One to many present adding default information if required");
        }
        if (this.getPersistenceOptions().isSetForeignKeyNames() && aAttribute.getForeignKey() == null) {
            aAttribute.setForeignKey(this.createFK((PAnnotatedEStructuralFeature)aAttribute));
        }
        if (eAttribute.getEType() instanceof EEnum && aAttribute.getEnumerated() == null) {
            Enumerated enumerated = this.getFactory().createEnumerated();
            enumerated.setValue(EnumType.STRING);
            enumerated.setEModelElement((EModelElement)eAttribute);
            aAttribute.setEnumerated(enumerated);
        }
        if (aAttribute.getTemporal() == null) {
            this.setTemporal(aAttribute, this.optionDefaultTemporal);
        }
        if (otm.getCascade().isEmpty()) {
            otm.getCascade().add((Object)CascadeType.ALL);
        }
        if (otm.getTargetEntity() == null) {
            otm.setTargetEntity(this.getTargetTypeName(aAttribute));
        }
        if (aAttribute.getJoinTable() == null) {
            JoinTable jt = this.getFactory().createJoinTable();
            jt.setName(this.getSqlNameStrategy().getJoinTableName(aAttribute));
            aAttribute.setJoinTable(jt);
        }
        if (aAttribute.getJoinColumns().size() == 0) {
            List<String> names = this.getSqlNameStrategy().getOneToManyEAttributeJoinColumns(aAttribute);
            aAttribute.getJoinColumns().addAll(this.getJoinColumns(names, FeatureMapUtil.isFeatureMap((EStructuralFeature)eAttribute), true, (PAnnotation)otm));
        }
        if (!otmWasSet) {
            log.debug((Object)"Setting indexed and unique on otm from eAttribute.isOrdered/isUnique because otm was not set manually");
            otm.setIndexed(eAttribute.isOrdered());
            otm.setUnique(eAttribute.isUnique());
        }
    }

    public void setPersistenceOptions(PersistenceOptions persistenceOptions) {
        super.setPersistenceOptions(persistenceOptions);
        this.optionDefaultTemporal = TemporalType.get((String)persistenceOptions.getDefaultTemporalValue());
        if (this.optionDefaultTemporal == null) {
            throw new StoreMappingException("Temporal value not found: " + persistenceOptions.getDefaultTemporalValue());
        }
    }
}

