/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.tests.fragmentation;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.ResourceAttachmentChange;
import org.eclipse.emf.compare.merge.BatchMerger;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.compare.scope.DefaultComparisonScope;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.compare.tests.fragmentation.data.FragmentationInputData;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.junit.Assert;
import org.junit.Test;

public class ResourceAttachmentChangeBug492261 {
    private final FragmentationInputData input = new FragmentationInputData();
    private final BatchMerger batchMerger = new BatchMerger(IMerger.RegistryImpl.createStandaloneInstance());

    @Test
    public void testUncontrolRootResourceImplication_1() throws IOException {
        Resource left = this.input.getRootElementImplicationLeft();
        Resource origin = this.input.getRootElementImplicationUncontrolOrigin();
        Resource right = this.input.getRootElementImplicationRight();
        ResourceSet leftSet = left.getResourceSet();
        ResourceSet originSet = origin.getResourceSet();
        ResourceSet rightSet = right.getResourceSet();
        Assert.assertNotNull((Object)leftSet);
        Assert.assertNotNull((Object)originSet);
        Assert.assertNotNull((Object)rightSet);
        EcoreUtil.resolveAll((ResourceSet)leftSet);
        EcoreUtil.resolveAll((ResourceSet)originSet);
        EcoreUtil.resolveAll((ResourceSet)rightSet);
        Assert.assertEquals((long)1L, (long)leftSet.getResources().size());
        Assert.assertEquals((long)2L, (long)originSet.getResources().size());
        Assert.assertEquals((long)2L, (long)rightSet.getResources().size());
        this.mergeUncontrolDiffsAndAssertResult(leftSet, originSet, rightSet, true);
    }

    @Test
    public void testUncontrolRootResourceImplication_2() throws IOException {
        Resource left = this.input.getRootElementImplicationRight();
        Resource origin = this.input.getRootElementImplicationUncontrolOrigin();
        Resource right = this.input.getRootElementImplicationLeft();
        ResourceSet leftSet = left.getResourceSet();
        ResourceSet originSet = origin.getResourceSet();
        ResourceSet rightSet = right.getResourceSet();
        Assert.assertNotNull((Object)leftSet);
        Assert.assertNotNull((Object)originSet);
        Assert.assertNotNull((Object)rightSet);
        EcoreUtil.resolveAll((ResourceSet)leftSet);
        EcoreUtil.resolveAll((ResourceSet)originSet);
        EcoreUtil.resolveAll((ResourceSet)rightSet);
        Assert.assertEquals((long)2L, (long)leftSet.getResources().size());
        Assert.assertEquals((long)2L, (long)originSet.getResources().size());
        Assert.assertEquals((long)1L, (long)rightSet.getResources().size());
        this.mergeUncontrolDiffsAndAssertResult(leftSet, originSet, rightSet, false);
    }

    @Test
    public void testControlRootResourceImplication_1() throws IOException {
        Resource left = this.input.getRootElementImplicationLeft();
        Resource origin = this.input.getRootElementImplicationControlOrigin();
        Resource right = this.input.getRootElementImplicationRight();
        ResourceSet leftSet = left.getResourceSet();
        ResourceSet originSet = origin.getResourceSet();
        ResourceSet rightSet = right.getResourceSet();
        Assert.assertNotNull((Object)leftSet);
        Assert.assertNotNull((Object)originSet);
        Assert.assertNotNull((Object)rightSet);
        EcoreUtil.resolveAll((ResourceSet)leftSet);
        EcoreUtil.resolveAll((ResourceSet)originSet);
        EcoreUtil.resolveAll((ResourceSet)rightSet);
        Assert.assertEquals((long)1L, (long)leftSet.getResources().size());
        Assert.assertEquals((long)1L, (long)originSet.getResources().size());
        Assert.assertEquals((long)2L, (long)rightSet.getResources().size());
        this.mergeControlDiffsAndAssertResult(leftSet, originSet, rightSet, false);
    }

    @Test
    public void testControlRootResourceImplication_2() throws IOException {
        Resource left = this.input.getRootElementImplicationRight();
        Resource origin = this.input.getRootElementImplicationControlOrigin();
        Resource right = this.input.getRootElementImplicationLeft();
        ResourceSet leftSet = left.getResourceSet();
        ResourceSet originSet = origin.getResourceSet();
        ResourceSet rightSet = right.getResourceSet();
        Assert.assertNotNull((Object)leftSet);
        Assert.assertNotNull((Object)originSet);
        Assert.assertNotNull((Object)rightSet);
        EcoreUtil.resolveAll((ResourceSet)leftSet);
        EcoreUtil.resolveAll((ResourceSet)originSet);
        EcoreUtil.resolveAll((ResourceSet)rightSet);
        Assert.assertEquals((long)2L, (long)leftSet.getResources().size());
        Assert.assertEquals((long)1L, (long)originSet.getResources().size());
        Assert.assertEquals((long)1L, (long)rightSet.getResources().size());
        this.mergeControlDiffsAndAssertResult(leftSet, originSet, rightSet, true);
    }

    private void mergeUncontrolDiffsAndAssertResult(ResourceSet leftSet, ResourceSet originSet, ResourceSet rightSet, boolean fragmentedOnLeft) {
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)leftSet, (Notifier)rightSet, (Notifier)originSet);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Collection racFilter = Collections2.filter((Collection)differences, (Predicate)Predicates.instanceOf(ResourceAttachmentChange.class));
        Collection rcFilter = Collections2.filter((Collection)differences, (Predicate)Predicates.instanceOf(ReferenceChange.class));
        Assert.assertEquals((long)1L, (long)racFilter.size());
        Assert.assertEquals((long)2L, (long)rcFilter.size());
        Diff rac = (Diff)racFilter.iterator().next();
        Diff container = null;
        Diff innerNode = null;
        for (Diff diff : rcFilter) {
            if (fragmentedOnLeft && diff.getMatch().getLeft() == null) {
                innerNode = diff;
                continue;
            }
            if (!fragmentedOnLeft && diff.getMatch().getRight() == null) {
                innerNode = diff;
                continue;
            }
            container = diff;
        }
        Assert.assertNotNull(container);
        Assert.assertNotNull(innerNode);
        if (fragmentedOnLeft) {
            this.batchMerger.copyAllRightToLeft(Arrays.asList(rac), (Monitor)new BasicMonitor());
        } else {
            this.batchMerger.copyAllLeftToRight(Arrays.asList(rac), (Monitor)new BasicMonitor());
        }
        Assert.assertEquals((Object)DifferenceState.DISCARDED, (Object)rac.getState());
        Assert.assertEquals((Object)DifferenceState.DISCARDED, (Object)container.getState());
        Assert.assertEquals((Object)DifferenceState.UNRESOLVED, (Object)innerNode.getState());
        if (fragmentedOnLeft) {
            this.batchMerger.copyAllRightToLeft(Arrays.asList(innerNode), (Monitor)new BasicMonitor());
        } else {
            this.batchMerger.copyAllLeftToRight(Arrays.asList(innerNode), (Monitor)new BasicMonitor());
        }
        Assert.assertEquals((Object)DifferenceState.DISCARDED, (Object)rac.getState());
        Assert.assertEquals((Object)DifferenceState.DISCARDED, (Object)container.getState());
        Assert.assertEquals((Object)DifferenceState.DISCARDED, (Object)innerNode.getState());
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    private void mergeControlDiffsAndAssertResult(ResourceSet leftSet, ResourceSet originSet, ResourceSet rightSet, boolean fragmentedOnLeft) {
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)leftSet, (Notifier)rightSet, (Notifier)originSet);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Collection racFilter = Collections2.filter((Collection)differences, (Predicate)Predicates.instanceOf(ResourceAttachmentChange.class));
        Collection rcFilter = Collections2.filter((Collection)differences, (Predicate)Predicates.instanceOf(ReferenceChange.class));
        Assert.assertEquals((long)1L, (long)racFilter.size());
        Assert.assertEquals((long)2L, (long)rcFilter.size());
        Diff rac = (Diff)racFilter.iterator().next();
        Diff container = null;
        Diff innerNode = null;
        for (Diff diff : rcFilter) {
            if (fragmentedOnLeft && diff.getMatch().getRight() == null) {
                innerNode = diff;
                continue;
            }
            if (!fragmentedOnLeft && diff.getMatch().getLeft() == null) {
                innerNode = diff;
                continue;
            }
            container = diff;
        }
        Assert.assertNotNull(container);
        Assert.assertNotNull(innerNode);
        if (fragmentedOnLeft) {
            this.batchMerger.copyAllRightToLeft(Arrays.asList(rac), (Monitor)new BasicMonitor());
        } else {
            this.batchMerger.copyAllLeftToRight(Arrays.asList(rac), (Monitor)new BasicMonitor());
        }
        Assert.assertEquals((Object)DifferenceState.DISCARDED, (Object)rac.getState());
        Assert.assertEquals((Object)DifferenceState.UNRESOLVED, (Object)container.getState());
        Assert.assertEquals((Object)DifferenceState.UNRESOLVED, (Object)innerNode.getState());
        if (fragmentedOnLeft) {
            this.batchMerger.copyAllRightToLeft(Arrays.asList(container), (Monitor)new BasicMonitor());
        } else {
            this.batchMerger.copyAllLeftToRight(Arrays.asList(container), (Monitor)new BasicMonitor());
        }
        Assert.assertEquals((Object)DifferenceState.DISCARDED, (Object)rac.getState());
        Assert.assertEquals((Object)DifferenceState.DISCARDED, (Object)container.getState());
        Assert.assertEquals((Object)DifferenceState.DISCARDED, (Object)innerNode.getState());
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }
}

