/*******************************************************************************
 * Copyright (C) 2015 Obeo and others.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package org.eclipse.emf.compare.ide.ui.tests.models;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ModelProvider;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

/**
 * This model provider will make all files of a given extension to be part of the same model. In this test,
 * this will be used on files with extension {@link #SAMPLE_FILE_EXTENSION}.
 */
public class SampleModelProvider extends ModelProvider {
	public static final String SAMPLE_PROVIDER_ID = "org.eclipse.emf.compare.ide.ui.tests.models.sampleModelProvider"; //$NON-NLS-1$

	public static final String SAMPLE_FILE_EXTENSION = "sample"; //$NON-NLS-1$

	@Override
	public ResourceMapping[] getMappings(IResource resource, ResourceMappingContext context,
			IProgressMonitor monitor) throws CoreException {
		if (resource instanceof IFile && SAMPLE_FILE_EXTENSION.equals(resource.getFileExtension())) {
			return new ResourceMapping[] {new SampleResourceMapping((IFile)resource, SAMPLE_PROVIDER_ID), };
		}
		return super.getMappings(resource, context, monitor);
	}
}
