/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.tests.git.framework.internal.statements;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.compare.ide.ui.tests.framework.AbstractCompareStatement;
import org.eclipse.emf.compare.ide.ui.tests.framework.EMFCompareTestConfiguration;
import org.eclipse.emf.compare.ide.ui.tests.framework.ResolutionStrategyID;
import org.eclipse.emf.compare.ide.ui.tests.git.framework.GitTestSupport;
import org.eclipse.emf.compare.ide.ui.tests.git.framework.annotations.GitCherryPick;
import org.eclipse.emf.compare.ide.ui.tests.git.framework.annotations.GitMerge;
import org.eclipse.emf.compare.ide.ui.tests.git.framework.annotations.GitRebase;
import org.eclipse.jgit.api.CherryPickResult;
import org.eclipse.jgit.api.MergeResult;
import org.eclipse.jgit.api.RebaseResult;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.lib.Repository;
import org.junit.runners.model.FrameworkMethod;

public abstract class AbstractGitStatement
extends AbstractCompareStatement {
    public AbstractGitStatement(Object testObject, FrameworkMethod test, ResolutionStrategyID resolutionStrategy, EMFCompareTestConfiguration configuration) {
        super(testObject, test, resolutionStrategy, configuration);
    }

    protected Object[] createParameters(Method method, GitTestSupport gitTestsSupport) throws Exception {
        Class<?>[] paramTypes;
        ImmutableList.Builder builder = ImmutableList.builder();
        Class<?>[] classArray = paramTypes = method.getParameterTypes();
        int n = paramTypes.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> paramType = classArray[n2];
            if (paramType.equals(GitTestSupport.class)) {
                builder.add((Object)gitTestsSupport);
            } else if (paramType.equals(MergeResult.class) && method.getAnnotation(GitMerge.class) != null) {
                builder.add((Object)gitTestsSupport.getMergeResult());
            } else if (paramType.equals(RebaseResult.class) && method.getAnnotation(GitRebase.class) != null) {
                builder.add((Object)gitTestsSupport.getRebaseResult());
            } else if (paramType.equals(CherryPickResult.class) && method.getAnnotation(GitCherryPick.class) != null) {
                builder.add((Object)gitTestsSupport.getCherryPickResult());
            } else if (this.isCollectionCompatible(paramType)) {
                builder.add(gitTestsSupport.getProjects());
            } else if (paramType.equals(Repository.class)) {
                builder.add((Object)gitTestsSupport.getRepository());
            } else if (paramType.equals(Status.class)) {
                builder.add((Object)gitTestsSupport.getStatus());
            } else {
                throw new IllegalArgumentException("Unsupported parameter type " + paramType.getCanonicalName());
            }
            ++n2;
        }
        return builder.build().toArray();
    }

    private boolean isCollectionCompatible(Class<?> paramType) {
        return paramType.equals(Collection.class) || paramType.equals(List.class) || paramType.equals(Iterable.class);
    }
}

