/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.tests.merge;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.io.IOException;
import java.util.Collection;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.compare.scope.DefaultComparisonScope;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.compare.tests.checkers.MergeDependenciesChecker;
import org.eclipse.emf.compare.tests.merge.data.IndividualDiffInputData;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.resource.Resource;
import org.junit.Assert;
import org.junit.Test;

public class ConflictImplicationsTest_Bug484579 {
    private IndividualDiffInputData input = new IndividualDiffInputData();
    private final IMerger.Registry mergerRegistry = IMerger.RegistryImpl.createStandaloneInstance();

    @Test
    public void testImplicationBetweenConflicts() throws IOException {
        Diff deletePackageY = this.setupImplicationBetweenConflicts();
        MergeDependenciesChecker checker = this.getChecker(deletePackageY);
        checker.rightToLeft().implies(1).rejects(0).check();
        checker.leftToRight().implies(1).rejects(0).check();
    }

    @Test
    public void testImplicationsBetweenMoveAndDeleteConflicts() throws IOException {
        Collection<Conflict> realConflicts = this.setupImplicationBetweenMoveAndDelete();
        Conflict next = realConflicts.iterator().next();
        Collection conflict1FromLeft = Collections2.filter((Collection)next.getDifferences(), (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT));
        Collection conflict1FromRight = Collections2.filter((Collection)next.getDifferences(), (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT));
        Assert.assertEquals((long)1L, (long)conflict1FromLeft.size());
        Assert.assertEquals((long)1L, (long)conflict1FromRight.size());
        Diff deletePackageD = (Diff)conflict1FromLeft.iterator().next();
        Diff movePackageD = (Diff)conflict1FromRight.iterator().next();
        MergeDependenciesChecker checker = this.getChecker(deletePackageD);
        checker.rightToLeft().implies(1).rejects(0).check();
        checker.leftToRight().implies(2).rejects(1).check();
        checker = this.getChecker(movePackageD);
        checker.rightToLeft().implies(1).rejects(1).check();
        checker.leftToRight().implies(1).rejects(0).check();
    }

    private MergeDependenciesChecker getChecker(Diff diff) {
        return MergeDependenciesChecker.getDependenciesChecker(this.mergerRegistry, diff);
    }

    private Diff setupImplicationBetweenConflicts() throws IOException {
        Resource origin = this.input.getConflictAndPseudoConflictImplicationsAncestor();
        Resource left = this.input.getConflictAndPseudoConflictImplicationsLeft();
        Resource right = this.input.getConflictAndPseudoConflictImplicationsRight();
        MergeDependenciesChecker checker = null;
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList conflicts = comparison.getConflicts();
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)9L, (long)comparison.getDifferences().size());
        Assert.assertEquals((long)4L, (long)conflicts.size());
        Collection pseudoConflicts = Collections2.filter((Collection)conflicts, (Predicate)EMFComparePredicates.containsConflictOfTypes((ConflictKind[])new ConflictKind[]{ConflictKind.PSEUDO}));
        Collection realConflicts = Collections2.filter((Collection)conflicts, (Predicate)EMFComparePredicates.containsConflictOfTypes((ConflictKind[])new ConflictKind[]{ConflictKind.REAL}));
        Assert.assertEquals((long)2L, (long)pseudoConflicts.size());
        Assert.assertEquals((long)2L, (long)realConflicts.size());
        Conflict pseudo1 = null;
        Conflict pseudo2 = null;
        for (Conflict conflict : pseudoConflicts) {
            if (((Diff)conflict.getLeftDifferences().get(0)).getMatch().getOrigin().toString().contains("ClassZ")) {
                pseudo1 = conflict;
                continue;
            }
            if (!((Diff)conflict.getLeftDifferences().get(0)).getMatch().getOrigin().toString().contains("PackageY")) continue;
            pseudo2 = conflict;
        }
        Assert.assertNotNull(pseudo1);
        Assert.assertNotNull(pseudo2);
        Conflict real1 = null;
        Conflict real2 = null;
        for (Conflict conflict : realConflicts) {
            if (((Diff)conflict.getLeftDifferences().get(0)).getMatch().getDifferences().size() == 1) {
                real2 = conflict;
                continue;
            }
            if (((Diff)conflict.getLeftDifferences().get(0)).getMatch().getDifferences().size() != 2) continue;
            real1 = conflict;
        }
        Assert.assertNotNull(real1);
        Assert.assertNotNull(real2);
        Collection conflict1FromLeft = Collections2.filter((Collection)real1.getDifferences(), (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT));
        Collection conflict1FromRight = Collections2.filter((Collection)real1.getDifferences(), (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT));
        Assert.assertEquals((long)1L, (long)conflict1FromLeft.size());
        Assert.assertEquals((long)1L, (long)conflict1FromRight.size());
        Collection conflict2FromLeft = Collections2.filter((Collection)real2.getDifferences(), (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT));
        Collection conflict2FromRight = Collections2.filter((Collection)real2.getDifferences(), (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT));
        Assert.assertEquals((long)1L, (long)conflict2FromLeft.size());
        Assert.assertEquals((long)1L, (long)conflict2FromRight.size());
        Diff deleteClassB = (Diff)conflict1FromLeft.iterator().next();
        differences.remove((Object)deleteClassB);
        Diff renameClassB = (Diff)conflict1FromRight.iterator().next();
        differences.remove((Object)renameClassB);
        Diff deletePackageA = (Diff)conflict2FromLeft.iterator().next();
        differences.remove((Object)deletePackageA);
        Diff renamePackageA = (Diff)conflict2FromRight.iterator().next();
        differences.remove((Object)renamePackageA);
        for (Diff diff : pseudo1.getDifferences()) {
            differences.remove((Object)diff);
            checker = this.getChecker(diff);
            if (diff.getSource() == DifferenceSource.LEFT) {
                checker.rightToLeft().implies(4).rejects(0).check();
                checker.leftToRight().implies(2).rejects(0).check();
                continue;
            }
            checker.rightToLeft().implies(2).rejects(0).check();
            checker.leftToRight().implies(2).rejects(0).check();
        }
        for (Diff diff : pseudo2.getDifferences()) {
            differences.remove((Object)diff);
            checker = this.getChecker(diff);
            if (diff.getSource() == DifferenceSource.LEFT) {
                checker.rightToLeft().implies(3).rejects(0).check();
                checker.leftToRight().implies(2).rejects(0).check();
                continue;
            }
            checker.rightToLeft().implies(2).rejects(0).check();
            checker.leftToRight().implies(2).rejects(0).check();
        }
        checker = this.getChecker(deleteClassB);
        checker.rightToLeft().implies(2).rejects(0).check();
        checker.leftToRight().implies(1).rejects(1).check();
        checker = this.getChecker(renameClassB);
        checker.rightToLeft().implies(1).rejects(2).check();
        checker.leftToRight().implies(1).rejects(0).check();
        checker = this.getChecker(deletePackageA);
        checker.rightToLeft().implies(1).rejects(0).check();
        checker.leftToRight().implies(2).rejects(2).check();
        checker = this.getChecker(renamePackageA);
        checker.rightToLeft().implies(1).rejects(1).check();
        checker.leftToRight().implies(1).rejects(0).check();
        Assert.assertEquals((long)1L, (long)differences.size());
        return (Diff)differences.get(0);
    }

    private Collection<Conflict> setupImplicationBetweenMoveAndDelete() throws IOException {
        Resource origin = this.input.getMoveConflictAndPseudoConflictImplicationsAncestor();
        Resource left = this.input.getMoveConflictAndPseudoConflictImplicationsLeft();
        Resource right = this.input.getMoveConflictAndPseudoConflictImplicationsRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList conflicts = comparison.getConflicts();
        Assert.assertEquals((long)17L, (long)comparison.getDifferences().size());
        Assert.assertEquals((long)7L, (long)conflicts.size());
        Collection pseudoConflicts = Collections2.filter((Collection)conflicts, (Predicate)EMFComparePredicates.containsConflictOfTypes((ConflictKind[])new ConflictKind[]{ConflictKind.PSEUDO}));
        Collection realConflicts = Collections2.filter((Collection)conflicts, (Predicate)EMFComparePredicates.containsConflictOfTypes((ConflictKind[])new ConflictKind[]{ConflictKind.REAL}));
        Assert.assertEquals((long)6L, (long)pseudoConflicts.size());
        Assert.assertEquals((long)1L, (long)realConflicts.size());
        return realConflicts;
    }
}

