/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.tests.fullcomparison;

import java.io.IOException;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.match.DefaultComparisonFactory;
import org.eclipse.emf.compare.match.DefaultEqualityHelperFactory;
import org.eclipse.emf.compare.match.DefaultMatchEngine;
import org.eclipse.emf.compare.match.IComparisonFactory;
import org.eclipse.emf.compare.match.IEqualityHelperFactory;
import org.eclipse.emf.compare.match.eobject.EditionDistance;
import org.eclipse.emf.compare.match.eobject.IEObjectMatcher;
import org.eclipse.emf.compare.match.eobject.IdentifierEObjectMatcher;
import org.eclipse.emf.compare.match.eobject.ProximityEObjectMatcher;
import org.eclipse.emf.compare.scope.DefaultComparisonScope;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.compare.tests.fullcomparison.data.distance.DistanceMatchInputData;
import org.eclipse.emf.compare.tests.suite.AllTests;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.internal.resource.UMLResourceFactoryImpl;
import org.junit.Before;
import org.junit.Test;

public class MatchPerformanceComparisonTest {
    DistanceMatchInputData data = new DistanceMatchInputData();
    int nbIterations = 10;
    Resource left;
    Resource right;
    Resource origin;

    @Before
    public void setUp() throws Exception {
        AllTests.fillEMFRegistries();
        EPackage.Registry.INSTANCE.put((Object)"http://www.eclipse.org/uml2/5.0.0/UML", (Object)UMLPackage.eINSTANCE);
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("uml", new UMLResourceFactoryImpl());
        this.left = this.data.getNominalUMLLeft();
        this.right = this.data.getNominalUMLRight();
        this.origin = this.data.getNominalUMLOrigin();
    }

    @Test
    public void warmup() throws IOException {
        ProximityEObjectMatcher contentMatcher = new ProximityEObjectMatcher((ProximityEObjectMatcher.DistanceFunction)EditionDistance.builder().build());
        IdentifierEObjectMatcher matcher = new IdentifierEObjectMatcher((IEObjectMatcher)contentMatcher);
        DefaultMatchEngine matchEngine = new DefaultMatchEngine((IEObjectMatcher)matcher, (IComparisonFactory)new DefaultComparisonFactory((IEqualityHelperFactory)new DefaultEqualityHelperFactory()));
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)this.left, (Notifier)this.right, (Notifier)this.origin);
        matchEngine.match((IComparisonScope)scope, (Monitor)new BasicMonitor());
    }

    @Test
    public void matchPerIdAlmostIdenticalModels() throws IOException {
        IdentifierEObjectMatcher matcher = new IdentifierEObjectMatcher();
        DefaultMatchEngine matchEngine = new DefaultMatchEngine((IEObjectMatcher)matcher, (IComparisonFactory)new DefaultComparisonFactory((IEqualityHelperFactory)new DefaultEqualityHelperFactory()));
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)this.left, (Notifier)this.right, (Notifier)this.origin);
        int i = 0;
        while (i < this.nbIterations) {
            matchEngine.match((IComparisonScope)scope, (Monitor)new BasicMonitor());
            ++i;
        }
    }

    @Test
    public void matchPerContentAlmostIdenticalModels() throws IOException {
        ProximityEObjectMatcher contentMatcher = new ProximityEObjectMatcher((ProximityEObjectMatcher.DistanceFunction)EditionDistance.builder().build());
        DefaultMatchEngine matchEngine = new DefaultMatchEngine((IEObjectMatcher)contentMatcher, (IComparisonFactory)new DefaultComparisonFactory((IEqualityHelperFactory)new DefaultEqualityHelperFactory()));
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)this.left, (Notifier)this.right, (Notifier)this.origin);
        int i = 0;
        while (i < this.nbIterations) {
            matchEngine.match((IComparisonScope)scope, (Monitor)new BasicMonitor());
            ++i;
        }
    }
}

