/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.tests.logical.resolver;

import com.google.common.base.Optional;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.DependencyFoundEvent;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.ResolvedEvent;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.ResourceDependencyFoundEvent;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.junit.Assert;
import org.junit.Test;

public class ResolutionEventsTest {
    @Test
    public void testResolvedEvent() {
        String node = "a";
        Assert.assertEquals((Object)node, (Object)new ResolvedEvent((Object)node).getNode());
    }

    @Test
    public void testDependencyFoundEvent() {
        String from = "from";
        String to = "to";
        String parent = "parent";
        DependencyFoundEvent evt = new DependencyFoundEvent((Object)from, (Object)to);
        Assert.assertEquals((Object)from, (Object)evt.getFrom());
        Assert.assertEquals((Object)to, (Object)evt.getTo());
        Assert.assertFalse((boolean)evt.hasParent());
        Assert.assertNull((Object)evt.getParent().orNull());
        evt = new DependencyFoundEvent((Object)from, (Object)to, Optional.of((Object)parent));
        Assert.assertEquals((Object)from, (Object)evt.getFrom());
        Assert.assertEquals((Object)to, (Object)evt.getTo());
        Assert.assertTrue((boolean)evt.hasParent());
        Assert.assertEquals((Object)parent, (Object)evt.getParent().orNull());
    }

    @Test
    public void testResourceDependencyFoundEvent() {
        URI from = URI.createURI((String)"from");
        URI to = URI.createURI((String)"to");
        EClass parent = EcorePackage.eINSTANCE.getEClass();
        EAttribute attribute = EcorePackage.eINSTANCE.getENamedElement_Name();
        EReference crossReference = EcorePackage.eINSTANCE.getEClass_ESuperTypes();
        EReference containmentReference = EcorePackage.eINSTANCE.getEClass_EStructuralFeatures();
        ResourceDependencyFoundEvent evt = new ResourceDependencyFoundEvent(from, to, (EObject)parent, (EStructuralFeature)attribute);
        Assert.assertEquals((Object)from, (Object)evt.getFrom());
        Assert.assertEquals((Object)to, (Object)evt.getTo());
        Assert.assertFalse((boolean)evt.hasParent());
        Assert.assertNull((Object)evt.getParent().orNull());
        evt = new ResourceDependencyFoundEvent(from, to, (EObject)parent, (EStructuralFeature)crossReference);
        Assert.assertEquals((Object)from, (Object)evt.getFrom());
        Assert.assertEquals((Object)to, (Object)evt.getTo());
        Assert.assertFalse((boolean)evt.hasParent());
        Assert.assertNull((Object)evt.getParent().orNull());
        evt = new ResourceDependencyFoundEvent(from, to, (EObject)parent, (EStructuralFeature)containmentReference);
        Assert.assertEquals((Object)from, (Object)evt.getFrom());
        Assert.assertEquals((Object)to, (Object)evt.getTo());
        Assert.assertTrue((boolean)evt.hasParent());
        Assert.assertEquals((Object)ResourceDependencyFoundEvent.getUri((EObject)parent), (Object)evt.getParent().orNull());
    }
}

