/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.tests.structuremergeviewer.actions;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.domain.impl.EMFCompareEditingDomain;
import org.eclipse.emf.compare.ide.ui.tests.structuremergeviewer.actions.AbstractTestUITreeNodeItemProviderAdapter;
import org.eclipse.emf.compare.ide.ui.tests.structuremergeviewer.actions.MockMergeAction;
import org.eclipse.emf.compare.internal.merge.MergeMode;
import org.eclipse.emf.compare.internal.merge.MergeOperation;
import org.eclipse.emf.compare.merge.IMergeOptionAware;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.compare.rcp.EMFCompareRCPPlugin;
import org.eclipse.emf.compare.rcp.ui.internal.configuration.IEMFCompareConfiguration;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.impl.DefaultGroupProvider;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.provider.TreeNodeItemProviderSpec;
import org.eclipse.emf.compare.scope.DefaultComparisonScope;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.compare.tests.framework.AbstractInputData;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.tree.TreeFactory;
import org.eclipse.emf.edit.tree.TreeNode;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestBug470503
extends AbstractTestUITreeNodeItemProviderAdapter {
    private static TreeNodeItemProviderSpec itemProvider;
    private IMerger.Registry mergerRegistry;
    private TreeNode titledItemESuperTypesDelete;
    private TreeNode titledItemEClassifiersDelete;
    private TreeNode titleESFDelete;

    @Before
    public void before() throws IOException {
        super.before();
        itemProvider = (TreeNodeItemProviderSpec)this.treeItemProviderAdapterFactory.createTreeNodeAdapter();
        this.mergerRegistry = EMFCompareRCPPlugin.getDefault().getMergerRegistry();
        Bug470503InputData inputData = new Bug470503InputData();
        Resource left = inputData.getResource("left.ecore");
        Resource right = inputData.getResource("right.ecore");
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        this.editingDomain = EMFCompareEditingDomain.create((Notifier)left, (Notifier)right, null);
        TreeNode extLibraryNode = TestBug470503.getExtlibrary_EPackageMatch(comparison);
        EList extLibraryNodeChildren = extLibraryNode.getChildren();
        TreeNode bookNode = (TreeNode)extLibraryNodeChildren.get(0);
        this.titledItemESuperTypesDelete = (TreeNode)bookNode.getChildren().get(0);
        TreeNode titledItemNode = (TreeNode)extLibraryNodeChildren.get(1);
        this.titledItemEClassifiersDelete = (TreeNode)titledItemNode.getChildren().get(0);
        this.titleESFDelete = (TreeNode)((TreeNode)titledItemNode.getChildren().get(1)).getChildren().get(0);
    }

    @Test
    public void testMergeWithCascadingFilter() {
        MergeMode rightToLeft = MergeMode.RIGHT_TO_LEFT;
        boolean leftEditable = true;
        boolean rightEditable = true;
        boolean cascadingFilter = true;
        IEMFCompareConfiguration emfCC = this.createConfiguration(true, true);
        MockMergeAction action = new MockMergeAction(emfCC, this.mergerRegistry, rightToLeft, null);
        Diff titledItemESuperTypesDeleteDiff = (Diff)this.titledItemESuperTypesDelete.getData();
        Assert.assertFalse((boolean)rightToLeft.isLeftToRight(titledItemESuperTypesDeleteDiff, true, true));
        Assert.assertEquals((Object)MergeOperation.MERGE, (Object)rightToLeft.getMergeAction(titledItemESuperTypesDeleteDiff, true, true));
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.titledItemESuperTypesDelete));
        this.setCascadingDifferencesFilterEnabled(true);
        action.run();
        Assert.assertEquals((Object)DifferenceState.DISCARDED, (Object)titledItemESuperTypesDeleteDiff.getState());
        Diff titledItemEClassifiersDeleteDiff = (Diff)this.titledItemEClassifiersDelete.getData();
        Assert.assertEquals((Object)DifferenceState.DISCARDED, (Object)titledItemEClassifiersDeleteDiff.getState());
        Diff titleESFDeleteDiff = (Diff)this.titleESFDelete.getData();
        Assert.assertEquals((Object)DifferenceState.DISCARDED, (Object)titleESFDeleteDiff.getState());
    }

    @Test
    public void testMergeWithoutCascadingFilter() {
        MergeMode rightToLeft = MergeMode.RIGHT_TO_LEFT;
        boolean leftEditable = true;
        boolean rightEditable = true;
        boolean cascadingFilter = false;
        IEMFCompareConfiguration emfCC = this.createConfiguration(true, true);
        MockMergeAction action = new MockMergeAction(emfCC, this.mergerRegistry, rightToLeft, null);
        Diff titledItemESuperTypesDeleteDiff = (Diff)this.titledItemESuperTypesDelete.getData();
        Assert.assertFalse((boolean)rightToLeft.isLeftToRight(titledItemESuperTypesDeleteDiff, true, true));
        Assert.assertEquals((Object)MergeOperation.MERGE, (Object)rightToLeft.getMergeAction(titledItemESuperTypesDeleteDiff, true, true));
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.titledItemESuperTypesDelete));
        this.setCascadingDifferencesFilterEnabled(false);
        action.run();
        Assert.assertEquals((Object)DifferenceState.DISCARDED, (Object)titledItemESuperTypesDeleteDiff.getState());
        Diff titledItemEClassifiersDeleteDiff = (Diff)this.titledItemEClassifiersDelete.getData();
        Assert.assertEquals((Object)DifferenceState.DISCARDED, (Object)titledItemEClassifiersDeleteDiff.getState());
        Diff titleESFDeleteDiff = (Diff)this.titleESFDelete.getData();
        Assert.assertEquals((Object)DifferenceState.UNRESOLVED, (Object)titleESFDeleteDiff.getState());
    }

    private void setCascadingDifferencesFilterEnabled(boolean enabled) {
        for (IMergeOptionAware merger : Iterables.filter((Iterable)this.mergerRegistry.getMergers(null), IMergeOptionAware.class)) {
            Map mergeOptions = merger.getMergeOptions();
            mergeOptions.put("subDiffAwareOption", enabled);
        }
    }

    private static TreeNode getExtlibrary_EPackageMatch(Comparison comparison) throws IOException {
        TreeNode treeNode = TreeFactory.eINSTANCE.createTreeNode();
        treeNode.setData((EObject)comparison);
        treeNode.eAdapters().add((Object)new DefaultGroupProvider());
        Collection children = itemProvider.getChildren((Object)treeNode);
        Iterable matches = Iterables.filter((Iterable)children, (Predicate)matchTreeNode);
        return (TreeNode)matches.iterator().next();
    }

    public class Bug470503InputData
    extends AbstractInputData {
        private static final String PATH_PREFIX = "data/_470503/";

        public Resource getResource(String resourceName) throws IOException {
            StringBuilder resourceURL = new StringBuilder(PATH_PREFIX);
            resourceURL.append(resourceName);
            return this.loadFromClassLoader(resourceURL.toString());
        }
    }
}

