/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.tests.framework.junit.internal;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.compare.tests.framework.junit.annotation.BeforeMatch;
import org.eclipse.emf.compare.tests.framework.junit.annotation.ConflictTest;
import org.eclipse.emf.compare.tests.framework.junit.annotation.DiffTest;
import org.eclipse.emf.compare.tests.framework.junit.annotation.MatchTest;
import org.eclipse.emf.compare.tests.framework.junit.annotation.UseCase;
import org.eclipse.emf.compare.tests.framework.junit.internal.ConflictStatement;
import org.eclipse.emf.compare.tests.framework.junit.internal.DiffStatement;
import org.eclipse.emf.compare.tests.framework.junit.internal.MatchStatement;
import org.eclipse.emf.compare.tests.framework.junit.internal.UseCaseStatement;
import org.junit.Assert;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;

public class UseCaseRunner
extends BlockJUnit4ClassRunner {
    private FrameworkMethod useCase;

    public UseCaseRunner(Class<?> clazz, FrameworkMethod useCaseMethod) throws InitializationError {
        super(clazz);
        this.useCase = useCaseMethod;
    }

    protected String testName(FrameworkMethod method) {
        StringBuilder name = new StringBuilder();
        name.append(super.testName(method));
        name.append(" - ");
        name.append(((UseCase)this.useCase.getAnnotation(UseCase.class)).value());
        return name.toString();
    }

    protected String getName() {
        StringBuilder name = new StringBuilder();
        name.append(((UseCase)this.useCase.getAnnotation(UseCase.class)).value());
        return name.toString();
    }

    protected List<FrameworkMethod> computeTestMethods() {
        ArrayList allMethods = Lists.newArrayList((Iterable)this.getTestClass().getAnnotatedMethods(MatchTest.class));
        allMethods.addAll(this.getTestClass().getAnnotatedMethods(DiffTest.class));
        allMethods.addAll(this.getTestClass().getAnnotatedMethods(ConflictTest.class));
        return allMethods;
    }

    protected Statement methodBlock(FrameworkMethod method) {
        Statement result;
        Object testObject = null;
        try {
            testObject = this.createTest();
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        UseCaseStatement useCaseStatement = new UseCaseStatement(this.useCase, testObject);
        if (method.getAnnotation(MatchTest.class) != null) {
            List befores = this.getTestClass().getAnnotatedMethods(BeforeMatch.class);
            result = new MatchStatement(testObject, useCaseStatement, befores, method);
        } else {
            result = method.getAnnotation(DiffTest.class) != null ? new DiffStatement(testObject, useCaseStatement, method) : (method.getAnnotation(ConflictTest.class) != null ? new ConflictStatement(testObject, useCaseStatement, method) : null);
        }
        return result;
    }
}

