/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.tests.equi;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import java.io.IOException;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.scope.DefaultComparisonScope;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.compare.tests.equi.data.EquiInputData;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.resource.Resource;
import org.junit.Assert;
import org.junit.Test;

public class EquiComputingTest {
    private EquiInputData input = new EquiInputData();

    @Test
    public void testA1UseCase() throws IOException {
        Resource left = this.input.getA1Left();
        Resource right = this.input.getA1Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right);
        EquiComputingTest.testA1(TestKind.LEFT, comparison);
    }

    private static void testA1(TestKind kind, Comparison comparison) {
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)6L, (long)differences.size());
        Predicate changeRefA2BDiffDescription = null;
        Predicate changeRefB2ADiffDescription = null;
        Predicate changeRefC2DDiffDescription = null;
        Predicate changeRefD2CDiffDescription = null;
        Predicate changeRefE2FDiffDescription = null;
        Predicate changeRefF2EDiffDescription = null;
        if (kind.equals((Object)TestKind.LEFT)) {
            changeRefA2BDiffDescription = EMFComparePredicates.changedReference((String)"Requirements.A", (String)"destination", null, (String)"Requirements.B");
            changeRefB2ADiffDescription = EMFComparePredicates.changedReference((String)"Requirements.B", (String)"source", null, (String)"Requirements.A");
            changeRefC2DDiffDescription = EMFComparePredicates.addedToReference((String)"Requirements.C", (String)"destination", (String)"Requirements.D");
            changeRefD2CDiffDescription = EMFComparePredicates.changedReference((String)"Requirements.D", (String)"source", null, (String)"Requirements.C");
            changeRefE2FDiffDescription = EMFComparePredicates.addedToReference((String)"Requirements.E", (String)"destination", (String)"Requirements.F");
            changeRefF2EDiffDescription = EMFComparePredicates.addedToReference((String)"Requirements.F", (String)"source", (String)"Requirements.E");
        } else {
            changeRefA2BDiffDescription = EMFComparePredicates.changedReference((String)"Requirements.A", (String)"destination", (String)"Requirements.B", null);
            changeRefB2ADiffDescription = EMFComparePredicates.changedReference((String)"Requirements.B", (String)"source", (String)"Requirements.A", null);
            changeRefC2DDiffDescription = EMFComparePredicates.removedFromReference((String)"Requirements.C", (String)"destination", (String)"Requirements.D");
            changeRefD2CDiffDescription = EMFComparePredicates.changedReference((String)"Requirements.D", (String)"source", (String)"Requirements.C", null);
            changeRefE2FDiffDescription = EMFComparePredicates.removedFromReference((String)"Requirements.E", (String)"destination", (String)"Requirements.F");
            changeRefF2EDiffDescription = EMFComparePredicates.removedFromReference((String)"Requirements.F", (String)"source", (String)"Requirements.E");
        }
        Diff changeRefA2BDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)changeRefA2BDiffDescription);
        Diff changeRefB2ADiff = (Diff)Iterators.find(differences.iterator(), (Predicate)changeRefB2ADiffDescription);
        Diff changeRefC2DDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)changeRefC2DDiffDescription);
        Diff changeRefD2CDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)changeRefD2CDiffDescription);
        Diff changeRefE2FDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)changeRefE2FDiffDescription);
        Diff changeRefF2EDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)changeRefF2EDiffDescription);
        Assert.assertNotNull((Object)changeRefA2BDiff);
        Assert.assertNotNull((Object)changeRefB2ADiff);
        Assert.assertNotNull((Object)changeRefC2DDiff);
        Assert.assertNotNull((Object)changeRefD2CDiff);
        Assert.assertNotNull((Object)changeRefE2FDiff);
        Assert.assertNotNull((Object)changeRefF2EDiff);
        Assert.assertEquals((long)3L, (long)comparison.getEquivalences().size());
        Assert.assertNotNull((Object)changeRefA2BDiff.getEquivalence());
        Assert.assertEquals((long)2L, (long)changeRefA2BDiff.getEquivalence().getDifferences().size());
        Assert.assertTrue((boolean)changeRefA2BDiff.getEquivalence().getDifferences().contains((Object)changeRefA2BDiff));
        Assert.assertTrue((boolean)changeRefA2BDiff.getEquivalence().getDifferences().contains((Object)changeRefB2ADiff));
        Assert.assertNotNull((Object)changeRefC2DDiff.getEquivalence());
        Assert.assertEquals((long)2L, (long)changeRefC2DDiff.getEquivalence().getDifferences().size());
        Assert.assertTrue((boolean)changeRefC2DDiff.getEquivalence().getDifferences().contains((Object)changeRefC2DDiff));
        Assert.assertTrue((boolean)changeRefC2DDiff.getEquivalence().getDifferences().contains((Object)changeRefD2CDiff));
        Assert.assertNotNull((Object)changeRefE2FDiff.getEquivalence());
        Assert.assertEquals((long)2L, (long)changeRefE2FDiff.getEquivalence().getDifferences().size());
        Assert.assertTrue((boolean)changeRefE2FDiff.getEquivalence().getDifferences().contains((Object)changeRefE2FDiff));
        Assert.assertTrue((boolean)changeRefE2FDiff.getEquivalence().getDifferences().contains((Object)changeRefF2EDiff));
    }

    @Test
    public void testA2UseCase() throws IOException {
        Resource left = this.input.getA2Left();
        Resource right = this.input.getA2Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right);
        EquiComputingTest.testA2(TestKind.LEFT, comparison);
    }

    private static void testA2(TestKind kind, Comparison comparison) {
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)8L, (long)differences.size());
        Predicate changeRefC2D1DiffDescription = null;
        Predicate changeRefC2D2DiffDescription = null;
        Predicate changeRefD12CDiffDescription = null;
        Predicate changeRefD22CDiffDescription = null;
        Predicate changeRefE2F1DiffDescription = null;
        Predicate changeRefE2F2DiffDescription = null;
        Predicate changeRefF12EDiffDescription = null;
        Predicate changeRefF22EDiffDescription = null;
        if (kind.equals((Object)TestKind.LEFT)) {
            changeRefC2D1DiffDescription = EMFComparePredicates.addedToReference((String)"Requirements.C", (String)"destination", (String)"Requirements.D1");
            changeRefC2D2DiffDescription = EMFComparePredicates.addedToReference((String)"Requirements.C", (String)"destination", (String)"Requirements.D2");
            changeRefD12CDiffDescription = EMFComparePredicates.changedReference((String)"Requirements.D1", (String)"source", null, (String)"Requirements.C");
            changeRefD22CDiffDescription = EMFComparePredicates.changedReference((String)"Requirements.D2", (String)"source", null, (String)"Requirements.C");
            changeRefE2F1DiffDescription = EMFComparePredicates.addedToReference((String)"Requirements.E", (String)"destination", (String)"Requirements.F1");
            changeRefE2F2DiffDescription = EMFComparePredicates.addedToReference((String)"Requirements.E", (String)"destination", (String)"Requirements.F2");
            changeRefF12EDiffDescription = EMFComparePredicates.addedToReference((String)"Requirements.F1", (String)"source", (String)"Requirements.E");
            changeRefF22EDiffDescription = EMFComparePredicates.addedToReference((String)"Requirements.F2", (String)"source", (String)"Requirements.E");
        } else {
            changeRefC2D1DiffDescription = EMFComparePredicates.removedFromReference((String)"Requirements.C", (String)"destination", (String)"Requirements.D1");
            changeRefC2D2DiffDescription = EMFComparePredicates.removedFromReference((String)"Requirements.C", (String)"destination", (String)"Requirements.D2");
            changeRefD12CDiffDescription = EMFComparePredicates.changedReference((String)"Requirements.D1", (String)"source", (String)"Requirements.C", null);
            changeRefD22CDiffDescription = EMFComparePredicates.changedReference((String)"Requirements.D2", (String)"source", (String)"Requirements.C", null);
            changeRefE2F1DiffDescription = EMFComparePredicates.removedFromReference((String)"Requirements.E", (String)"destination", (String)"Requirements.F1");
            changeRefE2F2DiffDescription = EMFComparePredicates.removedFromReference((String)"Requirements.E", (String)"destination", (String)"Requirements.F2");
            changeRefF12EDiffDescription = EMFComparePredicates.removedFromReference((String)"Requirements.F1", (String)"source", (String)"Requirements.E");
            changeRefF22EDiffDescription = EMFComparePredicates.removedFromReference((String)"Requirements.F2", (String)"source", (String)"Requirements.E");
        }
        Diff changeRefC2D1Diff = (Diff)Iterators.find(differences.iterator(), (Predicate)changeRefC2D1DiffDescription);
        Diff changeRefC2D2Diff = (Diff)Iterators.find(differences.iterator(), (Predicate)changeRefC2D2DiffDescription);
        Diff changeRefD12CDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)changeRefD12CDiffDescription);
        Diff changeRefD22CDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)changeRefD22CDiffDescription);
        Diff changeRefE2F1Diff = (Diff)Iterators.find(differences.iterator(), (Predicate)changeRefE2F1DiffDescription);
        Diff changeRefE2F2Diff = (Diff)Iterators.find(differences.iterator(), (Predicate)changeRefE2F2DiffDescription);
        Diff changeRefF12EDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)changeRefF12EDiffDescription);
        Diff changeRefF22EDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)changeRefF22EDiffDescription);
        Assert.assertNotNull((Object)changeRefC2D1Diff);
        Assert.assertNotNull((Object)changeRefC2D2Diff);
        Assert.assertNotNull((Object)changeRefD12CDiff);
        Assert.assertNotNull((Object)changeRefD22CDiff);
        Assert.assertNotNull((Object)changeRefE2F1Diff);
        Assert.assertNotNull((Object)changeRefE2F2Diff);
        Assert.assertNotNull((Object)changeRefF12EDiff);
        Assert.assertNotNull((Object)changeRefF22EDiff);
        Assert.assertEquals((long)4L, (long)comparison.getEquivalences().size());
        Assert.assertNotNull((Object)changeRefC2D1Diff.getEquivalence());
        Assert.assertEquals((long)2L, (long)changeRefC2D1Diff.getEquivalence().getDifferences().size());
        Assert.assertTrue((boolean)changeRefC2D1Diff.getEquivalence().getDifferences().contains((Object)changeRefC2D1Diff));
        Assert.assertTrue((boolean)changeRefC2D1Diff.getEquivalence().getDifferences().contains((Object)changeRefD12CDiff));
        Assert.assertNotNull((Object)changeRefC2D2Diff.getEquivalence());
        Assert.assertEquals((long)2L, (long)changeRefC2D2Diff.getEquivalence().getDifferences().size());
        Assert.assertTrue((boolean)changeRefC2D2Diff.getEquivalence().getDifferences().contains((Object)changeRefC2D2Diff));
        Assert.assertTrue((boolean)changeRefC2D2Diff.getEquivalence().getDifferences().contains((Object)changeRefD22CDiff));
        Assert.assertNotNull((Object)changeRefE2F1Diff.getEquivalence());
        Assert.assertEquals((long)2L, (long)changeRefE2F1Diff.getEquivalence().getDifferences().size());
        Assert.assertTrue((boolean)changeRefE2F1Diff.getEquivalence().getDifferences().contains((Object)changeRefE2F1Diff));
        Assert.assertTrue((boolean)changeRefE2F1Diff.getEquivalence().getDifferences().contains((Object)changeRefF12EDiff));
        Assert.assertNotNull((Object)changeRefE2F2Diff.getEquivalence());
        Assert.assertEquals((long)2L, (long)changeRefE2F2Diff.getEquivalence().getDifferences().size());
        Assert.assertTrue((boolean)changeRefE2F2Diff.getEquivalence().getDifferences().contains((Object)changeRefE2F2Diff));
        Assert.assertTrue((boolean)changeRefE2F2Diff.getEquivalence().getDifferences().contains((Object)changeRefF22EDiff));
    }

    @Test
    public void testA3UseCase() throws IOException {
        Resource left = this.input.getA3Left();
        Resource right = this.input.getA3Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right);
        EquiComputingTest.testA3(TestKind.LEFT, comparison);
    }

    private static void testA3(TestKind kind, Comparison comparison) {
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)8L, (long)differences.size());
        Predicate C1toD1DiffDescription = null;
        Predicate C1toD2DiffDescription = null;
        Predicate C2toD1DiffDescription = null;
        Predicate C2toD2DiffDescription = null;
        Predicate D1toC1DiffDescription = null;
        Predicate D1toC2DiffDescription = null;
        Predicate D2toC2DiffDescription = null;
        Predicate D2toC1DiffDescription = null;
        if (kind.equals((Object)TestKind.LEFT)) {
            C1toD1DiffDescription = EMFComparePredicates.addedToReference((String)"Requirements.C1", (String)"destination", (String)"Requirements.D1");
            C1toD2DiffDescription = EMFComparePredicates.addedToReference((String)"Requirements.C1", (String)"destination", (String)"Requirements.D2");
            C2toD1DiffDescription = EMFComparePredicates.addedToReference((String)"Requirements.C2", (String)"destination", (String)"Requirements.D1");
            C2toD2DiffDescription = EMFComparePredicates.addedToReference((String)"Requirements.C2", (String)"source", (String)"Requirements.D2");
            D1toC1DiffDescription = EMFComparePredicates.addedToReference((String)"Requirements.D1", (String)"source", (String)"Requirements.C1");
            D1toC2DiffDescription = EMFComparePredicates.addedToReference((String)"Requirements.D1", (String)"source", (String)"Requirements.C2");
            D2toC2DiffDescription = EMFComparePredicates.addedToReference((String)"Requirements.D2", (String)"destination", (String)"Requirements.C2");
            D2toC1DiffDescription = EMFComparePredicates.addedToReference((String)"Requirements.D2", (String)"source", (String)"Requirements.C1");
        } else {
            C1toD1DiffDescription = EMFComparePredicates.removedFromReference((String)"Requirements.C1", (String)"destination", (String)"Requirements.D1");
            C1toD2DiffDescription = EMFComparePredicates.removedFromReference((String)"Requirements.C1", (String)"destination", (String)"Requirements.D2");
            C2toD1DiffDescription = EMFComparePredicates.removedFromReference((String)"Requirements.C2", (String)"destination", (String)"Requirements.D1");
            C2toD2DiffDescription = EMFComparePredicates.removedFromReference((String)"Requirements.C2", (String)"source", (String)"Requirements.D2");
            D1toC1DiffDescription = EMFComparePredicates.removedFromReference((String)"Requirements.D1", (String)"source", (String)"Requirements.C1");
            D1toC2DiffDescription = EMFComparePredicates.removedFromReference((String)"Requirements.D1", (String)"source", (String)"Requirements.C2");
            D2toC2DiffDescription = EMFComparePredicates.removedFromReference((String)"Requirements.D2", (String)"destination", (String)"Requirements.C2");
            D2toC1DiffDescription = EMFComparePredicates.removedFromReference((String)"Requirements.D2", (String)"source", (String)"Requirements.C1");
        }
        Diff C1toD1Diff = (Diff)Iterators.find(differences.iterator(), (Predicate)C1toD1DiffDescription);
        Diff C1toD2Diff = (Diff)Iterators.find(differences.iterator(), (Predicate)C1toD2DiffDescription);
        Diff C2toD1Diff = (Diff)Iterators.find(differences.iterator(), (Predicate)C2toD1DiffDescription);
        Diff C2toD2Diff = (Diff)Iterators.find(differences.iterator(), (Predicate)C2toD2DiffDescription);
        Diff D1toC1Diff = (Diff)Iterators.find(differences.iterator(), (Predicate)D1toC1DiffDescription);
        Diff D1toC2Diff = (Diff)Iterators.find(differences.iterator(), (Predicate)D1toC2DiffDescription);
        Diff D2toC2Diff = (Diff)Iterators.find(differences.iterator(), (Predicate)D2toC2DiffDescription);
        Diff D2toC1Diff = (Diff)Iterators.find(differences.iterator(), (Predicate)D2toC1DiffDescription);
        Assert.assertNotNull((Object)C1toD1Diff);
        Assert.assertNotNull((Object)C1toD2Diff);
        Assert.assertNotNull((Object)C2toD1Diff);
        Assert.assertNotNull((Object)C2toD2Diff);
        Assert.assertNotNull((Object)D1toC1Diff);
        Assert.assertNotNull((Object)D1toC2Diff);
        Assert.assertNotNull((Object)D2toC2Diff);
        Assert.assertNotNull((Object)D2toC1Diff);
        Assert.assertEquals((long)4L, (long)comparison.getEquivalences().size());
        Assert.assertNotNull((Object)C1toD1Diff.getEquivalence());
        Assert.assertEquals((long)2L, (long)C1toD1Diff.getEquivalence().getDifferences().size());
        Assert.assertTrue((boolean)C1toD1Diff.getEquivalence().getDifferences().contains((Object)C1toD1Diff));
        Assert.assertTrue((boolean)C1toD1Diff.getEquivalence().getDifferences().contains((Object)D1toC1Diff));
        Assert.assertNotNull((Object)C1toD2Diff.getEquivalence());
        Assert.assertEquals((long)2L, (long)C1toD2Diff.getEquivalence().getDifferences().size());
        Assert.assertTrue((boolean)C1toD2Diff.getEquivalence().getDifferences().contains((Object)C1toD2Diff));
        Assert.assertTrue((boolean)C1toD2Diff.getEquivalence().getDifferences().contains((Object)D2toC1Diff));
        Assert.assertNotNull((Object)C2toD1Diff.getEquivalence());
        Assert.assertEquals((long)2L, (long)C2toD1Diff.getEquivalence().getDifferences().size());
        Assert.assertTrue((boolean)C2toD1Diff.getEquivalence().getDifferences().contains((Object)C2toD1Diff));
        Assert.assertTrue((boolean)C2toD1Diff.getEquivalence().getDifferences().contains((Object)D1toC2Diff));
        Assert.assertNotNull((Object)C2toD2Diff.getEquivalence());
        Assert.assertEquals((long)2L, (long)C2toD2Diff.getEquivalence().getDifferences().size());
        Assert.assertTrue((boolean)C2toD2Diff.getEquivalence().getDifferences().contains((Object)C2toD2Diff));
        Assert.assertTrue((boolean)C2toD2Diff.getEquivalence().getDifferences().contains((Object)D2toC2Diff));
    }

    @Test
    public void testA4UseCase() throws IOException {
        Resource left = this.input.getA4Left();
        Resource right = this.input.getA4Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right);
        EquiComputingTest.testA4(TestKind.LEFT, comparison);
    }

    private static void testA4(TestKind kind, Comparison comparison) {
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Predicate AtoBdestDiffDescription = null;
        Predicate AtoBsourceDiffDescription = null;
        Predicate BtoAdestDiffDescription = null;
        Predicate BtoAsourceDiffDescription = null;
        if (kind.equals((Object)TestKind.LEFT)) {
            AtoBdestDiffDescription = EMFComparePredicates.addedToReference((String)"Requirements.A", (String)"destination", (String)"Requirements.B");
            AtoBsourceDiffDescription = EMFComparePredicates.addedToReference((String)"Requirements.A", (String)"source", (String)"Requirements.B");
            BtoAdestDiffDescription = EMFComparePredicates.addedToReference((String)"Requirements.B", (String)"destination", (String)"Requirements.A");
            BtoAsourceDiffDescription = EMFComparePredicates.addedToReference((String)"Requirements.B", (String)"source", (String)"Requirements.A");
        } else {
            AtoBdestDiffDescription = EMFComparePredicates.removedFromReference((String)"Requirements.A", (String)"destination", (String)"Requirements.B");
            AtoBsourceDiffDescription = EMFComparePredicates.removedFromReference((String)"Requirements.A", (String)"source", (String)"Requirements.B");
            BtoAdestDiffDescription = EMFComparePredicates.removedFromReference((String)"Requirements.B", (String)"destination", (String)"Requirements.A");
            BtoAsourceDiffDescription = EMFComparePredicates.removedFromReference((String)"Requirements.B", (String)"source", (String)"Requirements.A");
        }
        Diff AtoBdestDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)AtoBdestDiffDescription);
        Diff AtoBsourceDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)AtoBsourceDiffDescription);
        Diff BtoAdestDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)BtoAdestDiffDescription);
        Diff BtoAsourceDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)BtoAsourceDiffDescription);
        Assert.assertNotNull((Object)AtoBdestDiff);
        Assert.assertNotNull((Object)AtoBsourceDiff);
        Assert.assertNotNull((Object)BtoAdestDiff);
        Assert.assertNotNull((Object)BtoAsourceDiff);
        Assert.assertEquals((long)2L, (long)comparison.getEquivalences().size());
        Assert.assertNotNull((Object)AtoBdestDiff.getEquivalence());
        Assert.assertEquals((long)2L, (long)AtoBdestDiff.getEquivalence().getDifferences().size());
        Assert.assertTrue((boolean)AtoBdestDiff.getEquivalence().getDifferences().contains((Object)AtoBdestDiff));
        Assert.assertTrue((boolean)AtoBdestDiff.getEquivalence().getDifferences().contains((Object)BtoAsourceDiff));
        Assert.assertNotNull((Object)AtoBsourceDiff.getEquivalence());
        Assert.assertEquals((long)2L, (long)AtoBsourceDiff.getEquivalence().getDifferences().size());
        Assert.assertTrue((boolean)AtoBsourceDiff.getEquivalence().getDifferences().contains((Object)AtoBsourceDiff));
        Assert.assertTrue((boolean)AtoBsourceDiff.getEquivalence().getDifferences().contains((Object)BtoAdestDiff));
    }

    @Test
    public void testA5UseCase() throws IOException {
        Resource left = this.input.getA5Left();
        Resource right = this.input.getA5Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right);
        EquiComputingTest.testA5(TestKind.LEFT, comparison);
    }

    private static void testA5(TestKind kind, Comparison comparison) {
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)12L, (long)differences.size());
        Predicate changeRefA2BDiffDescription = null;
        Predicate changeRefB2ADiffDescription = null;
        Predicate changeRefC2DDiffDescription = null;
        Predicate changeRefD2CDiffDescription = null;
        Predicate changeRefE2FDiffDescription = null;
        Predicate changeRefF2EDiffDescription = null;
        Predicate addADiffDescription = null;
        Predicate addBDiffDescription = null;
        Predicate addCDiffDescription = null;
        Predicate addDDiffDescription = null;
        Predicate addEDiffDescription = null;
        Predicate addFDiffDescription = null;
        if (kind.equals((Object)TestKind.LEFT)) {
            changeRefA2BDiffDescription = EMFComparePredicates.changedReference((String)"Requirements.A", (String)"destination", null, (String)"Requirements.B");
            changeRefB2ADiffDescription = EMFComparePredicates.changedReference((String)"Requirements.B", (String)"source", null, (String)"Requirements.A");
            changeRefC2DDiffDescription = EMFComparePredicates.addedToReference((String)"Requirements.C", (String)"destination", (String)"Requirements.D");
            changeRefD2CDiffDescription = EMFComparePredicates.changedReference((String)"Requirements.D", (String)"source", null, (String)"Requirements.C");
            changeRefE2FDiffDescription = EMFComparePredicates.addedToReference((String)"Requirements.E", (String)"destination", (String)"Requirements.F");
            changeRefF2EDiffDescription = EMFComparePredicates.addedToReference((String)"Requirements.F", (String)"source", (String)"Requirements.E");
            addADiffDescription = EMFComparePredicates.addedToReference((String)"Requirements", (String)"containmentRef1", (String)"Requirements.A");
            addBDiffDescription = EMFComparePredicates.addedToReference((String)"Requirements", (String)"containmentRef1", (String)"Requirements.B");
            addCDiffDescription = EMFComparePredicates.addedToReference((String)"Requirements", (String)"containmentRef1", (String)"Requirements.C");
            addDDiffDescription = EMFComparePredicates.addedToReference((String)"Requirements", (String)"containmentRef1", (String)"Requirements.D");
            addEDiffDescription = EMFComparePredicates.addedToReference((String)"Requirements", (String)"containmentRef1", (String)"Requirements.E");
            addFDiffDescription = EMFComparePredicates.addedToReference((String)"Requirements", (String)"containmentRef1", (String)"Requirements.F");
        } else {
            changeRefA2BDiffDescription = EMFComparePredicates.changedReference((String)"Requirements.A", (String)"destination", (String)"Requirements.B", null);
            changeRefB2ADiffDescription = EMFComparePredicates.changedReference((String)"Requirements.B", (String)"source", (String)"Requirements.A", null);
            changeRefC2DDiffDescription = EMFComparePredicates.removedFromReference((String)"Requirements.C", (String)"destination", (String)"Requirements.D");
            changeRefD2CDiffDescription = EMFComparePredicates.changedReference((String)"Requirements.D", (String)"source", (String)"Requirements.C", null);
            changeRefE2FDiffDescription = EMFComparePredicates.removedFromReference((String)"Requirements.E", (String)"destination", (String)"Requirements.F");
            changeRefF2EDiffDescription = EMFComparePredicates.removedFromReference((String)"Requirements.F", (String)"source", (String)"Requirements.E");
            addADiffDescription = EMFComparePredicates.removedFromReference((String)"Requirements", (String)"containmentRef1", (String)"Requirements.A");
            addBDiffDescription = EMFComparePredicates.removedFromReference((String)"Requirements", (String)"containmentRef1", (String)"Requirements.B");
            addCDiffDescription = EMFComparePredicates.removedFromReference((String)"Requirements", (String)"containmentRef1", (String)"Requirements.C");
            addDDiffDescription = EMFComparePredicates.removedFromReference((String)"Requirements", (String)"containmentRef1", (String)"Requirements.D");
            addEDiffDescription = EMFComparePredicates.removedFromReference((String)"Requirements", (String)"containmentRef1", (String)"Requirements.E");
            addFDiffDescription = EMFComparePredicates.removedFromReference((String)"Requirements", (String)"containmentRef1", (String)"Requirements.F");
        }
        Diff changeRefA2BDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)changeRefA2BDiffDescription);
        Diff changeRefB2ADiff = (Diff)Iterators.find(differences.iterator(), (Predicate)changeRefB2ADiffDescription);
        Diff changeRefC2DDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)changeRefC2DDiffDescription);
        Diff changeRefD2CDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)changeRefD2CDiffDescription);
        Diff changeRefE2FDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)changeRefE2FDiffDescription);
        Diff changeRefF2EDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)changeRefF2EDiffDescription);
        Diff addADiff = (Diff)Iterators.find(differences.iterator(), (Predicate)addADiffDescription);
        Diff addBDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)addBDiffDescription);
        Diff addCDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)addCDiffDescription);
        Diff addDDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)addDDiffDescription);
        Diff addEDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)addEDiffDescription);
        Diff addFDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)addFDiffDescription);
        Assert.assertNotNull((Object)changeRefA2BDiff);
        Assert.assertNotNull((Object)changeRefB2ADiff);
        Assert.assertNotNull((Object)changeRefC2DDiff);
        Assert.assertNotNull((Object)changeRefD2CDiff);
        Assert.assertNotNull((Object)changeRefE2FDiff);
        Assert.assertNotNull((Object)changeRefF2EDiff);
        Assert.assertNotNull((Object)addADiff);
        Assert.assertNotNull((Object)addBDiff);
        Assert.assertNotNull((Object)addCDiff);
        Assert.assertNotNull((Object)addDDiff);
        Assert.assertNotNull((Object)addEDiff);
        Assert.assertNotNull((Object)addFDiff);
        Assert.assertEquals((long)3L, (long)comparison.getEquivalences().size());
        Assert.assertNotNull((Object)changeRefA2BDiff.getEquivalence());
        Assert.assertEquals((long)2L, (long)changeRefA2BDiff.getEquivalence().getDifferences().size());
        Assert.assertTrue((boolean)changeRefA2BDiff.getEquivalence().getDifferences().contains((Object)changeRefA2BDiff));
        Assert.assertTrue((boolean)changeRefA2BDiff.getEquivalence().getDifferences().contains((Object)changeRefB2ADiff));
        Assert.assertNotNull((Object)changeRefC2DDiff.getEquivalence());
        Assert.assertEquals((long)2L, (long)changeRefC2DDiff.getEquivalence().getDifferences().size());
        Assert.assertTrue((boolean)changeRefC2DDiff.getEquivalence().getDifferences().contains((Object)changeRefC2DDiff));
        Assert.assertTrue((boolean)changeRefC2DDiff.getEquivalence().getDifferences().contains((Object)changeRefD2CDiff));
        Assert.assertNotNull((Object)changeRefE2FDiff.getEquivalence());
        Assert.assertEquals((long)2L, (long)changeRefE2FDiff.getEquivalence().getDifferences().size());
        Assert.assertTrue((boolean)changeRefE2FDiff.getEquivalence().getDifferences().contains((Object)changeRefE2FDiff));
        Assert.assertTrue((boolean)changeRefE2FDiff.getEquivalence().getDifferences().contains((Object)changeRefF2EDiff));
    }

    @Test
    public void testB1UseCase() throws IOException {
        Resource left = this.input.getA1Left();
        Resource right = this.input.getA1Right();
        Comparison comparison = this.compare((Notifier)right, (Notifier)left);
        EquiComputingTest.testA1(TestKind.RIGHT, comparison);
    }

    @Test
    public void testB2UseCase() throws IOException {
        Resource left = this.input.getA2Left();
        Resource right = this.input.getA2Right();
        Comparison comparison = this.compare((Notifier)right, (Notifier)left);
        EquiComputingTest.testA2(TestKind.RIGHT, comparison);
    }

    @Test
    public void testB3UseCase() throws IOException {
        Resource left = this.input.getA3Left();
        Resource right = this.input.getA3Right();
        Comparison comparison = this.compare((Notifier)right, (Notifier)left);
        EquiComputingTest.testA3(TestKind.RIGHT, comparison);
    }

    @Test
    public void testB4UseCase() throws IOException {
        Resource left = this.input.getA4Left();
        Resource right = this.input.getA4Right();
        Comparison comparison = this.compare((Notifier)right, (Notifier)left);
        EquiComputingTest.testA4(TestKind.RIGHT, comparison);
    }

    @Test
    public void testB5UseCase() throws IOException {
        Resource left = this.input.getA5Left();
        Resource right = this.input.getA5Right();
        Comparison comparison = this.compare((Notifier)right, (Notifier)left);
        EquiComputingTest.testA5(TestKind.RIGHT, comparison);
    }

    @Test
    public void testC1UseCase() throws IOException {
        Resource left = this.input.getC1Left();
        Resource right = this.input.getC1Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right);
        EquiComputingTest.testC1(TestKind.LEFT, comparison);
    }

    private static void testC1(TestKind kind, Comparison comparison) {
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)3L, (long)differences.size());
        Predicate changeRefA2BDiffDescription = null;
        Predicate changeRefB2ADiffDescription = null;
        Predicate changeRefC2ADiffDescription = null;
        if (kind.equals((Object)TestKind.LEFT)) {
            changeRefA2BDiffDescription = EMFComparePredicates.changedReference((String)"Requirements.A", (String)"destination", (String)"Requirements.B", (String)"Requirements.C");
            changeRefB2ADiffDescription = EMFComparePredicates.changedReference((String)"Requirements.B", (String)"source", (String)"Requirements.A", null);
            changeRefC2ADiffDescription = EMFComparePredicates.changedReference((String)"Requirements.C", (String)"source", null, (String)"Requirements.A");
        } else {
            changeRefA2BDiffDescription = EMFComparePredicates.changedReference((String)"Requirements.A", (String)"destination", (String)"Requirements.C", (String)"Requirements.B");
            changeRefB2ADiffDescription = EMFComparePredicates.changedReference((String)"Requirements.B", (String)"source", null, (String)"Requirements.A");
            changeRefC2ADiffDescription = EMFComparePredicates.changedReference((String)"Requirements.C", (String)"source", (String)"Requirements.A", null);
        }
        Diff changeRefA2BDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)changeRefA2BDiffDescription);
        Diff changeRefB2ADiff = (Diff)Iterators.find(differences.iterator(), (Predicate)changeRefB2ADiffDescription);
        Diff changeRefC2ADiff = (Diff)Iterators.find(differences.iterator(), (Predicate)changeRefC2ADiffDescription);
        Assert.assertNotNull((Object)changeRefA2BDiff);
        Assert.assertNotNull((Object)changeRefB2ADiff);
        Assert.assertNotNull((Object)changeRefC2ADiff);
        Assert.assertEquals((long)1L, (long)comparison.getEquivalences().size());
        Assert.assertNotNull((Object)changeRefA2BDiff.getEquivalence());
        Assert.assertEquals((long)3L, (long)changeRefA2BDiff.getEquivalence().getDifferences().size());
        Assert.assertTrue((boolean)changeRefA2BDiff.getEquivalence().getDifferences().contains((Object)changeRefA2BDiff));
        Assert.assertTrue((boolean)changeRefA2BDiff.getEquivalence().getDifferences().contains((Object)changeRefB2ADiff));
        Assert.assertTrue((boolean)changeRefA2BDiff.getEquivalence().getDifferences().contains((Object)changeRefC2ADiff));
    }

    @Test
    public void testC2UseCase() throws IOException {
        Resource left = this.input.getC2Left();
        Resource right = this.input.getC2Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right);
        EquiComputingTest.testC2(TestKind.LEFT, comparison);
    }

    private static void testC2(TestKind kind, Comparison comparison) {
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Predicate changeRefA2BDiffDescription = null;
        Predicate changeRefB2ADiffDescription = null;
        Predicate changeRefC2ADiffDescription = null;
        Predicate addCDiffDescription = null;
        if (kind.equals((Object)TestKind.LEFT)) {
            changeRefA2BDiffDescription = EMFComparePredicates.changedReference((String)"Requirements.A", (String)"destination", (String)"Requirements.B", (String)"Requirements.C");
            changeRefB2ADiffDescription = EMFComparePredicates.changedReference((String)"Requirements.B", (String)"source", (String)"Requirements.A", null);
            changeRefC2ADiffDescription = EMFComparePredicates.changedReference((String)"Requirements.C", (String)"source", null, (String)"Requirements.A");
            addCDiffDescription = EMFComparePredicates.addedToReference((String)"Requirements", (String)"containmentRef1", (String)"Requirements.C");
        } else {
            changeRefA2BDiffDescription = EMFComparePredicates.changedReference((String)"Requirements.A", (String)"destination", (String)"Requirements.C", (String)"Requirements.B");
            changeRefB2ADiffDescription = EMFComparePredicates.changedReference((String)"Requirements.B", (String)"source", null, (String)"Requirements.A");
            changeRefC2ADiffDescription = EMFComparePredicates.changedReference((String)"Requirements.C", (String)"source", (String)"Requirements.A", null);
            addCDiffDescription = EMFComparePredicates.removedFromReference((String)"Requirements", (String)"containmentRef1", (String)"Requirements.C");
        }
        Diff changeRefA2BDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)changeRefA2BDiffDescription);
        Diff changeRefB2ADiff = (Diff)Iterators.find(differences.iterator(), (Predicate)changeRefB2ADiffDescription);
        Diff changeRefC2ADiff = (Diff)Iterators.find(differences.iterator(), (Predicate)changeRefC2ADiffDescription);
        Diff addCDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)addCDiffDescription);
        Assert.assertNotNull((Object)changeRefA2BDiff);
        Assert.assertNotNull((Object)changeRefB2ADiff);
        Assert.assertNotNull((Object)changeRefC2ADiff);
        Assert.assertNotNull((Object)addCDiff);
        Assert.assertEquals((long)1L, (long)comparison.getEquivalences().size());
        Assert.assertNotNull((Object)changeRefA2BDiff.getEquivalence());
        Assert.assertEquals((long)3L, (long)changeRefA2BDiff.getEquivalence().getDifferences().size());
        Assert.assertTrue((boolean)changeRefA2BDiff.getEquivalence().getDifferences().contains((Object)changeRefA2BDiff));
        Assert.assertTrue((boolean)changeRefA2BDiff.getEquivalence().getDifferences().contains((Object)changeRefB2ADiff));
        Assert.assertTrue((boolean)changeRefA2BDiff.getEquivalence().getDifferences().contains((Object)changeRefC2ADiff));
    }

    @Test
    public void testC3UseCase() throws IOException {
        Resource left = this.input.getC3Left();
        Resource right = this.input.getC3Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right);
        EquiComputingTest.testC3(TestKind.LEFT, comparison);
    }

    private static void testC3(TestKind kind, Comparison comparison) {
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Predicate changeRefA2CDiffDescription = null;
        Predicate deleteBDiffDescription = null;
        Predicate changeRefC2ADiffDescription = null;
        Predicate changeRefB2ADiffDescription = null;
        if (kind.equals((Object)TestKind.LEFT)) {
            changeRefA2CDiffDescription = EMFComparePredicates.changedReference((String)"Requirements.A", (String)"destination", (String)"Requirements.B", (String)"Requirements.C");
            changeRefC2ADiffDescription = EMFComparePredicates.changedReference((String)"Requirements.C", (String)"source", null, (String)"Requirements.A");
            deleteBDiffDescription = EMFComparePredicates.removedFromReference((String)"Requirements", (String)"containmentRef1", (String)"Requirements.B");
            changeRefB2ADiffDescription = EMFComparePredicates.changedReference((String)"Requirements.B", (String)"source", (String)"Requirements.A", null);
        } else {
            changeRefA2CDiffDescription = EMFComparePredicates.changedReference((String)"Requirements.A", (String)"destination", (String)"Requirements.C", (String)"Requirements.B");
            changeRefC2ADiffDescription = EMFComparePredicates.changedReference((String)"Requirements.C", (String)"source", (String)"Requirements.A", null);
            deleteBDiffDescription = EMFComparePredicates.addedToReference((String)"Requirements", (String)"containmentRef1", (String)"Requirements.B");
            changeRefB2ADiffDescription = EMFComparePredicates.changedReference((String)"Requirements.B", (String)"source", null, (String)"Requirements.A");
        }
        Diff changeRefA2CDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)changeRefA2CDiffDescription);
        Diff changeRefC2ADiff = (Diff)Iterators.find(differences.iterator(), (Predicate)changeRefC2ADiffDescription);
        Diff deleteBDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)deleteBDiffDescription);
        Diff changeRefB2ADiff = (Diff)Iterators.find(differences.iterator(), (Predicate)changeRefB2ADiffDescription);
        Assert.assertNotNull((Object)changeRefA2CDiff);
        Assert.assertNotNull((Object)changeRefC2ADiff);
        Assert.assertNotNull((Object)deleteBDiff);
        Assert.assertNotNull((Object)changeRefB2ADiff);
        Assert.assertEquals((long)1L, (long)comparison.getEquivalences().size());
        Assert.assertNotNull((Object)changeRefA2CDiff.getEquivalence());
        Assert.assertEquals((long)3L, (long)changeRefA2CDiff.getEquivalence().getDifferences().size());
        Assert.assertTrue((boolean)changeRefA2CDiff.getEquivalence().getDifferences().contains((Object)changeRefA2CDiff));
        Assert.assertTrue((boolean)changeRefA2CDiff.getEquivalence().getDifferences().contains((Object)changeRefC2ADiff));
        Assert.assertTrue((boolean)changeRefA2CDiff.getEquivalence().getDifferences().contains((Object)changeRefB2ADiff));
    }

    @Test
    public void testC4UseCase() throws IOException {
        Resource left = this.input.getC4Left();
        Resource right = this.input.getC4Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right);
        EquiComputingTest.testC4(TestKind.LEFT, comparison);
    }

    private static void testC4(TestKind kind, Comparison comparison) {
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)5L, (long)differences.size());
        Predicate changeRefA2CDiffDescription = null;
        Predicate deleteBDiffDescription = null;
        Predicate changeRefC2ADiffDescription = null;
        Predicate changeRefB2ADiffDescription = null;
        Predicate addCDiffDescription = null;
        if (kind.equals((Object)TestKind.LEFT)) {
            changeRefA2CDiffDescription = EMFComparePredicates.changedReference((String)"Requirements.A", (String)"destination", (String)"Requirements.B", (String)"Requirements.C");
            changeRefC2ADiffDescription = EMFComparePredicates.changedReference((String)"Requirements.C", (String)"source", null, (String)"Requirements.A");
            deleteBDiffDescription = EMFComparePredicates.removedFromReference((String)"Requirements", (String)"containmentRef1", (String)"Requirements.B");
            changeRefB2ADiffDescription = EMFComparePredicates.changedReference((String)"Requirements.B", (String)"source", (String)"Requirements.A", null);
            addCDiffDescription = EMFComparePredicates.addedToReference((String)"Requirements", (String)"containmentRef1", (String)"Requirements.C");
        } else {
            changeRefA2CDiffDescription = EMFComparePredicates.changedReference((String)"Requirements.A", (String)"destination", (String)"Requirements.C", (String)"Requirements.B");
            changeRefC2ADiffDescription = EMFComparePredicates.changedReference((String)"Requirements.C", (String)"source", (String)"Requirements.A", null);
            deleteBDiffDescription = EMFComparePredicates.addedToReference((String)"Requirements", (String)"containmentRef1", (String)"Requirements.B");
            changeRefB2ADiffDescription = EMFComparePredicates.changedReference((String)"Requirements.B", (String)"source", null, (String)"Requirements.A");
            addCDiffDescription = EMFComparePredicates.removedFromReference((String)"Requirements", (String)"containmentRef1", (String)"Requirements.C");
        }
        Diff changeRefA2CDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)changeRefA2CDiffDescription);
        Diff changeRefC2ADiff = (Diff)Iterators.find(differences.iterator(), (Predicate)changeRefC2ADiffDescription);
        Diff deleteBDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)deleteBDiffDescription);
        Diff changeRefB2ADiff = (Diff)Iterators.find(differences.iterator(), (Predicate)changeRefB2ADiffDescription);
        Diff addCDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)addCDiffDescription);
        Assert.assertNotNull((Object)changeRefA2CDiff);
        Assert.assertNotNull((Object)changeRefC2ADiff);
        Assert.assertNotNull((Object)deleteBDiff);
        Assert.assertNotNull((Object)changeRefB2ADiff);
        Assert.assertNotNull((Object)addCDiff);
        Assert.assertEquals((long)1L, (long)comparison.getEquivalences().size());
        Assert.assertNotNull((Object)changeRefA2CDiff.getEquivalence());
        Assert.assertEquals((long)3L, (long)changeRefA2CDiff.getEquivalence().getDifferences().size());
        Assert.assertTrue((boolean)changeRefA2CDiff.getEquivalence().getDifferences().contains((Object)changeRefA2CDiff));
        Assert.assertTrue((boolean)changeRefA2CDiff.getEquivalence().getDifferences().contains((Object)changeRefC2ADiff));
        Assert.assertTrue((boolean)changeRefA2CDiff.getEquivalence().getDifferences().contains((Object)changeRefB2ADiff));
    }

    @Test
    public void testD1UseCase() throws IOException {
        Resource left = this.input.getD1Left();
        Resource right = this.input.getD1Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right);
        EquiComputingTest.testD1(TestKind.LEFT, comparison);
    }

    private static void testD1(TestKind kind, Comparison comparison) {
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)16L, (long)differences.size());
        Predicate delBonADiffDescription = null;
        Predicate delAonBDiffDescription = null;
        Predicate addDonADiffDescription = null;
        Predicate addEonADiffDescription = null;
        Predicate delFonBDiffDescription = null;
        Predicate addFonCDiffDescription = null;
        Predicate addAonDDiffDescription = null;
        Predicate delFonDDiffDescription = null;
        Predicate addAonEDiffDescription = null;
        Predicate addFonEDiffDescription = null;
        Predicate delDonFDiffDescription = null;
        Predicate delBonFDiffDescription = null;
        Predicate addEonFDiffDescription = null;
        Predicate addConFDiffDescription = null;
        Predicate delBDiffDescription = null;
        Predicate addEDiffDescription = null;
        if (kind.equals((Object)TestKind.LEFT)) {
            delBonADiffDescription = EMFComparePredicates.removedFromReference((String)"Requirements.A", (String)"destination", (String)"Requirements.B");
            delAonBDiffDescription = EMFComparePredicates.removedFromReference((String)"Requirements.B", (String)"source", (String)"Requirements.A");
            addDonADiffDescription = EMFComparePredicates.addedToReference((String)"Requirements.A", (String)"destination", (String)"Requirements.D");
            addEonADiffDescription = EMFComparePredicates.addedToReference((String)"Requirements.A", (String)"destination", (String)"Requirements.E");
            delFonBDiffDescription = EMFComparePredicates.removedFromReference((String)"Requirements.B", (String)"source", (String)"Requirements.F");
            addFonCDiffDescription = EMFComparePredicates.addedToReference((String)"Requirements.C", (String)"source", (String)"Requirements.F");
            addAonDDiffDescription = EMFComparePredicates.addedToReference((String)"Requirements.D", (String)"source", (String)"Requirements.A");
            delFonDDiffDescription = EMFComparePredicates.removedFromReference((String)"Requirements.D", (String)"source", (String)"Requirements.F");
            addAonEDiffDescription = EMFComparePredicates.addedToReference((String)"Requirements.E", (String)"source", (String)"Requirements.A");
            addFonEDiffDescription = EMFComparePredicates.addedToReference((String)"Requirements.E", (String)"source", (String)"Requirements.F");
            delDonFDiffDescription = EMFComparePredicates.removedFromReference((String)"Requirements.F", (String)"destination", (String)"Requirements.D");
            delBonFDiffDescription = EMFComparePredicates.removedFromReference((String)"Requirements.F", (String)"destination", (String)"Requirements.B");
            addEonFDiffDescription = EMFComparePredicates.addedToReference((String)"Requirements.F", (String)"destination", (String)"Requirements.E");
            addConFDiffDescription = EMFComparePredicates.addedToReference((String)"Requirements.F", (String)"destination", (String)"Requirements.C");
            delBDiffDescription = EMFComparePredicates.removedFromReference((String)"Requirements", (String)"containmentRef1", (String)"Requirements.B");
            addEDiffDescription = EMFComparePredicates.addedToReference((String)"Requirements", (String)"containmentRef1", (String)"Requirements.E");
        } else {
            delBonADiffDescription = EMFComparePredicates.addedToReference((String)"Requirements.A", (String)"destination", (String)"Requirements.B");
            delAonBDiffDescription = EMFComparePredicates.addedToReference((String)"Requirements.B", (String)"source", (String)"Requirements.A");
            addDonADiffDescription = EMFComparePredicates.removedFromReference((String)"Requirements.A", (String)"destination", (String)"Requirements.D");
            addEonADiffDescription = EMFComparePredicates.removedFromReference((String)"Requirements.A", (String)"destination", (String)"Requirements.E");
            delFonBDiffDescription = EMFComparePredicates.addedToReference((String)"Requirements.B", (String)"source", (String)"Requirements.F");
            addFonCDiffDescription = EMFComparePredicates.removedFromReference((String)"Requirements.C", (String)"source", (String)"Requirements.F");
            addAonDDiffDescription = EMFComparePredicates.removedFromReference((String)"Requirements.D", (String)"source", (String)"Requirements.A");
            delFonDDiffDescription = EMFComparePredicates.addedToReference((String)"Requirements.D", (String)"source", (String)"Requirements.F");
            addAonEDiffDescription = EMFComparePredicates.removedFromReference((String)"Requirements.E", (String)"source", (String)"Requirements.A");
            addFonEDiffDescription = EMFComparePredicates.removedFromReference((String)"Requirements.E", (String)"source", (String)"Requirements.F");
            delDonFDiffDescription = EMFComparePredicates.addedToReference((String)"Requirements.F", (String)"destination", (String)"Requirements.D");
            delBonFDiffDescription = EMFComparePredicates.addedToReference((String)"Requirements.F", (String)"destination", (String)"Requirements.B");
            addEonFDiffDescription = EMFComparePredicates.removedFromReference((String)"Requirements.F", (String)"destination", (String)"Requirements.E");
            addConFDiffDescription = EMFComparePredicates.removedFromReference((String)"Requirements.F", (String)"destination", (String)"Requirements.C");
            delBDiffDescription = EMFComparePredicates.addedToReference((String)"Requirements", (String)"containmentRef1", (String)"Requirements.B");
            addEDiffDescription = EMFComparePredicates.removedFromReference((String)"Requirements", (String)"containmentRef1", (String)"Requirements.E");
        }
        Diff delBonADiff = (Diff)Iterators.find(differences.iterator(), (Predicate)delBonADiffDescription);
        Diff delAonBDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)delAonBDiffDescription);
        Diff addDonADiff = (Diff)Iterators.find(differences.iterator(), (Predicate)addDonADiffDescription);
        Diff addEonADiff = (Diff)Iterators.find(differences.iterator(), (Predicate)addEonADiffDescription);
        Diff delFonBDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)delFonBDiffDescription);
        Diff addFonCDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)addFonCDiffDescription);
        Diff addAonDDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)addAonDDiffDescription);
        Diff delFonDDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)delFonDDiffDescription);
        Diff addAonEDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)addAonEDiffDescription);
        Diff addFonEDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)addFonEDiffDescription);
        Diff delDonFDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)delDonFDiffDescription);
        Diff delBonFDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)delBonFDiffDescription);
        Diff addEonFDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)addEonFDiffDescription);
        Diff addConFDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)addConFDiffDescription);
        Diff delBDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)delBDiffDescription);
        Diff addEDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)addEDiffDescription);
        Assert.assertNotNull((Object)delBonADiff);
        Assert.assertNotNull((Object)delAonBDiff);
        Assert.assertNotNull((Object)addDonADiff);
        Assert.assertNotNull((Object)addEonADiff);
        Assert.assertNotNull((Object)delFonBDiff);
        Assert.assertNotNull((Object)addFonCDiff);
        Assert.assertNotNull((Object)addAonDDiff);
        Assert.assertNotNull((Object)delFonDDiff);
        Assert.assertNotNull((Object)addAonEDiff);
        Assert.assertNotNull((Object)addFonEDiff);
        Assert.assertNotNull((Object)delDonFDiff);
        Assert.assertNotNull((Object)delBonFDiff);
        Assert.assertNotNull((Object)addEonFDiff);
        Assert.assertNotNull((Object)addConFDiff);
        Assert.assertNotNull((Object)delBDiff);
        Assert.assertNotNull((Object)addEDiff);
        Assert.assertEquals((long)7L, (long)comparison.getEquivalences().size());
        Assert.assertNotNull((Object)delBonADiff.getEquivalence());
        Assert.assertEquals((long)2L, (long)delBonADiff.getEquivalence().getDifferences().size());
        Assert.assertTrue((boolean)delBonADiff.getEquivalence().getDifferences().contains((Object)delBonADiff));
        Assert.assertTrue((boolean)delBonADiff.getEquivalence().getDifferences().contains((Object)delAonBDiff));
        Assert.assertNotNull((Object)addDonADiff.getEquivalence());
        Assert.assertEquals((long)2L, (long)addDonADiff.getEquivalence().getDifferences().size());
        Assert.assertTrue((boolean)addDonADiff.getEquivalence().getDifferences().contains((Object)addDonADiff));
        Assert.assertTrue((boolean)addDonADiff.getEquivalence().getDifferences().contains((Object)addAonDDiff));
        Assert.assertNotNull((Object)addEonADiff.getEquivalence());
        Assert.assertEquals((long)2L, (long)addEonADiff.getEquivalence().getDifferences().size());
        Assert.assertTrue((boolean)addEonADiff.getEquivalence().getDifferences().contains((Object)addEonADiff));
        Assert.assertTrue((boolean)addEonADiff.getEquivalence().getDifferences().contains((Object)addAonEDiff));
        Assert.assertNotNull((Object)delFonBDiff.getEquivalence());
        Assert.assertEquals((long)2L, (long)delFonBDiff.getEquivalence().getDifferences().size());
        Assert.assertTrue((boolean)delFonBDiff.getEquivalence().getDifferences().contains((Object)delFonBDiff));
        Assert.assertTrue((boolean)delFonBDiff.getEquivalence().getDifferences().contains((Object)delBonFDiff));
        Assert.assertNotNull((Object)addFonCDiff.getEquivalence());
        Assert.assertEquals((long)2L, (long)addFonCDiff.getEquivalence().getDifferences().size());
        Assert.assertTrue((boolean)addFonCDiff.getEquivalence().getDifferences().contains((Object)addFonCDiff));
        Assert.assertTrue((boolean)addFonCDiff.getEquivalence().getDifferences().contains((Object)addConFDiff));
        Assert.assertNotNull((Object)delFonDDiff.getEquivalence());
        Assert.assertEquals((long)2L, (long)delFonDDiff.getEquivalence().getDifferences().size());
        Assert.assertTrue((boolean)delFonDDiff.getEquivalence().getDifferences().contains((Object)delFonDDiff));
        Assert.assertTrue((boolean)delFonDDiff.getEquivalence().getDifferences().contains((Object)delDonFDiff));
        Assert.assertNotNull((Object)addFonEDiff.getEquivalence());
        Assert.assertEquals((long)2L, (long)addFonEDiff.getEquivalence().getDifferences().size());
        Assert.assertTrue((boolean)addFonEDiff.getEquivalence().getDifferences().contains((Object)addFonEDiff));
        Assert.assertTrue((boolean)addFonEDiff.getEquivalence().getDifferences().contains((Object)addEonFDiff));
    }

    @Test
    public void testE1UseCase() throws IOException {
        Resource left = this.input.getE1Left();
        Resource right = this.input.getE1Right();
        Resource ancestor = this.input.getE1Ancestor();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)ancestor);
        EquiComputingTest.testA1(TestKind.LEFT, comparison);
    }

    @Test
    public void testE2UseCase() throws IOException {
        Resource left = this.input.getE2Left();
        Resource right = this.input.getE2Right();
        Resource ancestor = this.input.getE2Ancestor();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)ancestor);
        EquiComputingTest.testA2(TestKind.LEFT, comparison);
    }

    @Test
    public void testE3UseCase() throws IOException {
        Resource left = this.input.getE3Left();
        Resource right = this.input.getE3Right();
        Resource ancestor = this.input.getE3Ancestor();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)ancestor);
        EquiComputingTest.testA3(TestKind.LEFT, comparison);
    }

    @Test
    public void testE4UseCase() throws IOException {
        Resource left = this.input.getE4Left();
        Resource right = this.input.getE4Right();
        Resource ancestor = this.input.getE4Ancestor();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)ancestor);
        EquiComputingTest.testA4(TestKind.LEFT, comparison);
    }

    @Test
    public void testE5UseCase() throws IOException {
        Resource left = this.input.getE5Left();
        Resource right = this.input.getE5Right();
        Resource ancestor = this.input.getE5Ancestor();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)ancestor);
        EquiComputingTest.testA5(TestKind.LEFT, comparison);
    }

    @Test
    public void testE6UseCase() throws IOException {
        Resource left = this.input.getE6Left();
        Resource right = this.input.getE6Right();
        Resource ancestor = this.input.getE6Ancestor();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)ancestor);
        EquiComputingTest.testC1(TestKind.LEFT, comparison);
    }

    @Test
    public void testE7UseCase() throws IOException {
        Resource left = this.input.getE7Left();
        Resource right = this.input.getE7Right();
        Resource ancestor = this.input.getE7Ancestor();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)ancestor);
        EquiComputingTest.testC2(TestKind.LEFT, comparison);
    }

    @Test
    public void testE8UseCase() throws IOException {
        Resource left = this.input.getE8Left();
        Resource right = this.input.getE8Right();
        Resource ancestor = this.input.getE8Ancestor();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)ancestor);
        EquiComputingTest.testC3(TestKind.LEFT, comparison);
    }

    @Test
    public void testE9UseCase() throws IOException {
        Resource left = this.input.getE9Left();
        Resource right = this.input.getE9Right();
        Resource ancestor = this.input.getE9Ancestor();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)ancestor);
        EquiComputingTest.testC4(TestKind.LEFT, comparison);
    }

    @Test
    public void testE10UseCase() throws IOException {
        Resource left = this.input.getE10Left();
        Resource right = this.input.getE10Right();
        Resource ancestor = this.input.getE10Ancestor();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)ancestor);
        EquiComputingTest.testD1(TestKind.LEFT, comparison);
    }

    @Test
    public void testF1UseCase() throws IOException {
        Resource left = this.input.getF1Left();
        Resource right = this.input.getF1Right();
        Resource ancestor = this.input.getF1Ancestor();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)ancestor);
        EquiComputingTest.testA1(TestKind.RIGHT, comparison);
    }

    @Test
    public void testF2UseCase() throws IOException {
        Resource left = this.input.getF2Left();
        Resource right = this.input.getF2Right();
        Resource ancestor = this.input.getF2Ancestor();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)ancestor);
        EquiComputingTest.testA2(TestKind.RIGHT, comparison);
    }

    @Test
    public void testF3UseCase() throws IOException {
        Resource left = this.input.getF3Left();
        Resource right = this.input.getF3Right();
        Resource ancestor = this.input.getF3Ancestor();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)ancestor);
        EquiComputingTest.testA3(TestKind.RIGHT, comparison);
    }

    @Test
    public void testF4UseCase() throws IOException {
        Resource left = this.input.getF4Left();
        Resource right = this.input.getF4Right();
        Resource ancestor = this.input.getF4Ancestor();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)ancestor);
        EquiComputingTest.testA4(TestKind.RIGHT, comparison);
    }

    @Test
    public void testF5UseCase() throws IOException {
        Resource left = this.input.getF5Left();
        Resource right = this.input.getF5Right();
        Resource ancestor = this.input.getF5Ancestor();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)ancestor);
        EquiComputingTest.testA5(TestKind.RIGHT, comparison);
    }

    @Test
    public void testF6UseCase() throws IOException {
        Resource left = this.input.getF6Left();
        Resource right = this.input.getF6Right();
        Resource ancestor = this.input.getF6Ancestor();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)ancestor);
        EquiComputingTest.testC1(TestKind.RIGHT, comparison);
    }

    @Test
    public void testF7UseCase() throws IOException {
        Resource left = this.input.getF7Left();
        Resource right = this.input.getF7Right();
        Resource ancestor = this.input.getF7Ancestor();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)ancestor);
        EquiComputingTest.testC2(TestKind.RIGHT, comparison);
    }

    @Test
    public void testF8UseCase() throws IOException {
        Resource left = this.input.getF8Left();
        Resource right = this.input.getF8Right();
        Resource ancestor = this.input.getF8Ancestor();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)ancestor);
        EquiComputingTest.testC3(TestKind.RIGHT, comparison);
    }

    @Test
    public void testF9UseCase() throws IOException {
        Resource left = this.input.getF9Left();
        Resource right = this.input.getF9Right();
        Resource ancestor = this.input.getF9Ancestor();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)ancestor);
        EquiComputingTest.testC4(TestKind.RIGHT, comparison);
    }

    @Test
    public void testF10UseCase() throws IOException {
        Resource left = this.input.getF10Left();
        Resource right = this.input.getF10Right();
        Resource ancestor = this.input.getF10Ancestor();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)ancestor);
        EquiComputingTest.testD1(TestKind.RIGHT, comparison);
    }

    private Comparison compare(Notifier left, Notifier right) {
        return this.compare(left, right, null);
    }

    private Comparison compare(Notifier left, Notifier right, Notifier ancestor) {
        DefaultComparisonScope scope = new DefaultComparisonScope(left, right, ancestor);
        return EMFCompare.builder().build().compare((IComparisonScope)scope);
    }

    static enum TestKind {
        LEFT,
        RIGHT;

    }
}

