/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.internal.utils;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xmi.XMIException;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.XMLHandler;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ForwardingXMLHandler
extends XMLHandler {
    private static final Map<String, Method> METHOD_CACHE = Maps.newHashMap();
    private static final LoadingCache<String, Field> FIELD_CACHE = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, Field>(){

        public Field load(String key) throws Exception {
            final Field field = ForwardingXMLHandler.findField(key);
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    field.setAccessible(true);
                    return null;
                }
            });
            return field;
        }
    });
    protected final XMLHandler delegate;

    public ForwardingXMLHandler(XMLHandler delegate, XMLResource xmlResource, XMLHelper helper, Map<?, ?> options) {
        super(xmlResource, helper, options);
        this.delegate = delegate;
    }

    protected XMLHandler delegate() {
        return this.delegate;
    }

    public void endDocument() {
        this.delegate().endDocument();
    }

    public void characters(char[] ch, int start, int length) {
        this.delegate().characters(ch, start, length);
    }

    public void comment(char[] ch, int start, int length) {
        this.delegate().comment(ch, start, length);
    }

    public void endCDATA() {
        this.delegate().endCDATA();
    }

    public void endDTD() {
        this.delegate().endDTD();
    }

    public void endElement(String uri, String localName, String name) {
        this.delegate().endElement(uri, localName, name);
    }

    public void endEntity(String name) {
        this.delegate().endEntity(name);
    }

    public void endPrefixMapping(String prefix) {
        this.delegate().endPrefixMapping(prefix);
    }

    public boolean equals(Object obj) {
        return this.delegate().equals(obj);
    }

    public void error(SAXParseException e) throws SAXException {
        this.delegate().error(e);
    }

    public void error(XMIException e) {
        this.delegate().error(e);
    }

    public void fatalError(SAXParseException e) throws SAXException {
        this.delegate().fatalError(e);
    }

    public void fatalError(XMIException e) {
        this.delegate().fatalError(e);
    }

    public int hashCode() {
        return this.delegate().hashCode();
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.delegate().ignorableWhitespace(ch, start, length);
    }

    public void notationDecl(String name, String publicId, String systemId) throws SAXException {
        this.delegate().notationDecl(name, publicId, systemId);
    }

    public void prepare(XMLResource resource, XMLHelper xmlHelper, Map<?, ?> options) {
        this.delegate().prepare(resource, xmlHelper, options);
    }

    public void processingInstruction(String target, String data) {
        this.delegate().processingInstruction(target, data);
    }

    public void reset() {
        this.delegate().reset();
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        return this.delegate().resolveEntity(publicId, systemId);
    }

    public void setDocumentLocator(Locator locator) {
        this.delegate().setDocumentLocator(locator);
    }

    public void skippedEntity(String name) throws SAXException {
        this.delegate().skippedEntity(name);
    }

    public void startCDATA() {
        this.delegate().startCDATA();
    }

    public void startDocument() {
        this.delegate().startDocument();
    }

    public void startDTD(String name, String publicId, String systemId) {
        this.delegate().startDTD(name, publicId, systemId);
    }

    public void startElement(String uri, String localName, String name) {
        this.delegate().startElement(uri, localName, name);
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.delegate().startElement(uri, localName, qName, attributes);
    }

    public void startEntity(String name) {
        this.delegate().startEntity(name);
    }

    public void startPrefixMapping(String prefix, String uri) {
        this.delegate().startPrefixMapping(prefix, uri);
    }

    public String toString() {
        return this.delegate().toString();
    }

    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
        this.delegate().unparsedEntityDecl(name, publicId, systemId, notationName);
    }

    public void warning(SAXParseException e) throws SAXException {
        this.delegate().warning(e);
    }

    public void warning(XMIException e) {
        this.delegate().warning(e);
    }

    protected String getXSIType() {
        String key = "getXSIType1";
        return (String)ForwardingXMLHandler.reflectiveCall("getXSIType1", this.delegate(), "getXSIType", new Object[0]);
    }

    protected void handleObjectAttribs(EObject obj) {
        String key = "handleObjectAttribs1";
        ForwardingXMLHandler.reflectiveCall("handleObjectAttribs1", this.delegate(), "handleObjectAttribs", obj);
    }

    protected static Object reflectiveCall(String key, Object target, String methodName, Object ... params) {
        Method method = METHOD_CACHE.get(key);
        if (method == null) {
            Class[] paramTypes = new Class[params.length];
            int i = 0;
            while (i < params.length) {
                paramTypes[i] = params[i].getClass();
                ++i;
            }
            final Method temp = ForwardingXMLHandler.findMethod(methodName, paramTypes);
            if (temp != null) {
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        temp.setAccessible(true);
                        return null;
                    }
                });
                METHOD_CACHE.put(key, temp);
            }
            method = temp;
        }
        try {
            if (method != null) {
                return method.invoke(target, params);
            }
            throw new RuntimeException(new NoSuchMethodException("Could not find method " + methodName + " on " + XMLHandler.class.getName()));
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    protected static void setField(String fieldName, Object target, Object value) {
        try {
            Field field = (Field)FIELD_CACHE.get((Object)fieldName);
            if (field == null) {
                throw new RuntimeException(new NoSuchFieldException("Could not find field " + fieldName + " on " + XMLHandler.class.getName()));
            }
            field.set(target, value);
        }
        catch (IllegalAccessException | IllegalArgumentException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private static Field findField(String fieldName) {
        Field[] fields = XMLHandler.class.getDeclaredFields();
        Field result = null;
        int i = 0;
        while (i < fields.length && result == null) {
            Field candidate = fields[i];
            if (fieldName.equals(candidate.getName())) {
                result = candidate;
            }
            ++i;
        }
        return result;
    }

    private static Method findMethod(String methodName, Class<?> ... paramTypes) {
        Method[] methods = XMLHandler.class.getDeclaredMethods();
        Method result = null;
        int i = 0;
        while (i < methods.length && result == null) {
            Method candidate = methods[i];
            if (methodName.equals(candidate.getName()) && ForwardingXMLHandler.equalArrays(paramTypes, candidate.getParameterTypes())) {
                result = candidate;
            }
            ++i;
        }
        return result;
    }

    private static boolean equalArrays(Object[] a1, Object[] a2) {
        boolean equal = false;
        if (a1 == null) {
            equal = a2 == null || a2.length == 0;
        } else if (a2 == null) {
            equal = a1.length == 0;
        } else if (a1.length != a2.length) {
            equal = false;
        } else {
            equal = true;
            int i = 0;
            while (i < a1.length && equal) {
                if (a1[i] != a2[i]) {
                    equal = false;
                }
                ++i;
            }
        }
        return equal;
    }
}

