/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.tests.contentmergeviewer.accessor.match;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import java.io.IOException;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.rcp.internal.extension.impl.EMFCompareBuilderConfigurator;
import org.eclipse.emf.compare.rcp.ui.contentmergeviewer.accessor.legacy.ITypedElement;
import org.eclipse.emf.compare.rcp.ui.internal.contentmergeviewer.accessor.factory.impl.MatchAccessorFactory;
import org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.item.impl.MergeViewerItem;
import org.eclipse.emf.compare.rcp.ui.internal.util.MergeViewerUtil;
import org.eclipse.emf.compare.rcp.ui.tests.contentmergeviewer.accessor.match.data.MatchAccessorInputData;
import org.eclipse.emf.compare.scope.DefaultComparisonScope;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class MatchAccessorTest {
    private static final MatchAccessorInputData inputData = new MatchAccessorInputData();
    private static final ComposedAdapterFactory fAdapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    private static Comparison comparison;

    @BeforeClass
    public static void beforeClass() throws IOException {
        fAdapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        fAdapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
        Resource leftResource = inputData.getLeft();
        Resource rightResource = inputData.getRight();
        Resource originResource = inputData.getOrigin();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)leftResource, (Notifier)rightResource, (Notifier)originResource);
        EMFCompare.Builder comparisonBuilder = EMFCompare.builder();
        EMFCompareBuilderConfigurator.createDefault().configure(comparisonBuilder);
        comparison = comparisonBuilder.build().compare((IComparisonScope)scope);
    }

    @Test
    public void testEClassifiersAdd() {
        Diff diff;
        EList differences = comparison.getDifferences();
        Predicate item = EMFComparePredicates.addedToReference((String)"extlibrary", (String)"eClassifiers", (String)"extlibrary.Item");
        Diff itemDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)item);
        EObject itemValue = (EObject)MergeViewerUtil.getDiffValue((Diff)itemDiff);
        Match itemMatch = comparison.getMatch(itemValue);
        MatchAccessorFactory factory = new MatchAccessorFactory();
        ITypedElement leftTypedElement = factory.createLeft((AdapterFactory)fAdapterFactory, (Object)itemMatch);
        ITypedElement rightTypedElement = factory.createRight((AdapterFactory)fAdapterFactory, (Object)itemMatch);
        ITypedElement originTypedElement = factory.createAncestor((AdapterFactory)fAdapterFactory, (Object)itemMatch);
        if (leftTypedElement instanceof MergeViewerItem) {
            diff = ((MergeViewerItem)leftTypedElement).getDiff();
            Assert.assertEquals((Object)diff, (Object)itemDiff);
        }
        if (rightTypedElement instanceof MergeViewerItem) {
            diff = ((MergeViewerItem)rightTypedElement).getDiff();
            Assert.assertEquals((Object)diff, (Object)itemDiff);
        }
        if (originTypedElement instanceof MergeViewerItem) {
            diff = ((MergeViewerItem)originTypedElement).getDiff();
            Assert.assertEquals((Object)diff, (Object)itemDiff);
        }
    }

    @Test
    public void testEStructuralFeaturesDelete() {
        Diff diff;
        EList differences = comparison.getDifferences();
        Predicate title = EMFComparePredicates.removedFromReference((String)"extlibrary.Book", (String)"eStructuralFeatures", (String)"extlibrary.Book.title");
        Diff titleDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)title);
        EObject titleValue = (EObject)MergeViewerUtil.getDiffValue((Diff)titleDiff);
        Match titleMatch = comparison.getMatch(titleValue);
        MatchAccessorFactory factory = new MatchAccessorFactory();
        ITypedElement leftTypedElement = factory.createLeft((AdapterFactory)fAdapterFactory, (Object)titleMatch);
        ITypedElement rightTypedElement = factory.createRight((AdapterFactory)fAdapterFactory, (Object)titleMatch);
        ITypedElement originTypedElement = factory.createAncestor((AdapterFactory)fAdapterFactory, (Object)titleMatch);
        if (leftTypedElement instanceof MergeViewerItem) {
            diff = ((MergeViewerItem)leftTypedElement).getDiff();
            Assert.assertEquals((Object)diff, (Object)titleDiff);
        }
        if (rightTypedElement instanceof MergeViewerItem) {
            diff = ((MergeViewerItem)rightTypedElement).getDiff();
            Assert.assertEquals((Object)diff, (Object)titleDiff);
        }
        if (originTypedElement instanceof MergeViewerItem) {
            diff = ((MergeViewerItem)originTypedElement).getDiff();
            Assert.assertEquals((Object)diff, (Object)titleDiff);
        }
    }

    @Test
    public void testELiteralsMultipleDelete() {
        Diff diff;
        Diff diff2;
        EList differences = comparison.getDifferences();
        MatchAccessorFactory factory = new MatchAccessorFactory();
        Predicate encyclopedia = EMFComparePredicates.removedFromReference((String)"extlibrary.BookCategory", (String)"eLiterals", (String)"extlibrary.BookCategory.Encyclopedia");
        Diff encyclopediaDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)encyclopedia);
        EObject encyclopediaValue = (EObject)MergeViewerUtil.getDiffValue((Diff)encyclopediaDiff);
        Match encyclopediaMatch = comparison.getMatch(encyclopediaValue);
        ITypedElement encyclopediaLeftTypedElement = factory.createLeft((AdapterFactory)fAdapterFactory, (Object)encyclopediaMatch);
        ITypedElement encyclopediaRightTypedElement = factory.createRight((AdapterFactory)fAdapterFactory, (Object)encyclopediaMatch);
        ITypedElement encyclopediaOriginTypedElement = factory.createAncestor((AdapterFactory)fAdapterFactory, (Object)encyclopediaMatch);
        if (encyclopediaLeftTypedElement instanceof MergeViewerItem) {
            diff2 = ((MergeViewerItem)encyclopediaLeftTypedElement).getDiff();
            Assert.assertEquals((Object)diff2, (Object)encyclopediaDiff);
        }
        if (encyclopediaRightTypedElement instanceof MergeViewerItem) {
            diff2 = ((MergeViewerItem)encyclopediaRightTypedElement).getDiff();
            Assert.assertEquals((Object)diff2, (Object)encyclopediaDiff);
        }
        if (encyclopediaOriginTypedElement instanceof MergeViewerItem) {
            diff2 = ((MergeViewerItem)encyclopediaOriginTypedElement).getDiff();
            Assert.assertEquals((Object)diff2, (Object)encyclopediaDiff);
        }
        Predicate dictionary = EMFComparePredicates.removedFromReference((String)"extlibrary.BookCategory", (String)"eLiterals", (String)"extlibrary.BookCategory.Dictionary");
        Diff dictionaryDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)dictionary);
        EObject dictionaryValue = (EObject)MergeViewerUtil.getDiffValue((Diff)dictionaryDiff);
        Match dictionaryMatch = comparison.getMatch(dictionaryValue);
        ITypedElement dictionaryLeftTypedElement = factory.createLeft((AdapterFactory)fAdapterFactory, (Object)dictionaryMatch);
        ITypedElement dictionaryRightTypedElement = factory.createRight((AdapterFactory)fAdapterFactory, (Object)dictionaryMatch);
        ITypedElement dictionaryOriginTypedElement = factory.createAncestor((AdapterFactory)fAdapterFactory, (Object)dictionaryMatch);
        if (dictionaryLeftTypedElement instanceof MergeViewerItem) {
            diff = ((MergeViewerItem)dictionaryLeftTypedElement).getDiff();
            Assert.assertEquals((Object)diff, (Object)dictionaryDiff);
        }
        if (dictionaryRightTypedElement instanceof MergeViewerItem) {
            diff = ((MergeViewerItem)dictionaryRightTypedElement).getDiff();
            Assert.assertEquals((Object)diff, (Object)dictionaryDiff);
        }
        if (dictionaryOriginTypedElement instanceof MergeViewerItem) {
            diff = ((MergeViewerItem)dictionaryOriginTypedElement).getDiff();
            Assert.assertEquals((Object)diff, (Object)dictionaryDiff);
        }
    }

    @Test
    public void testEStructuralFeaturesMultipleAdd() {
        Diff diff;
        Diff diff2;
        EList differences = comparison.getDifferences();
        MatchAccessorFactory factory = new MatchAccessorFactory();
        Predicate borrowed = EMFComparePredicates.addedToReference((String)"extlibrary.Borrower", (String)"eStructuralFeatures", (String)"extlibrary.Borrower.borrowed");
        Diff borrowedDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)borrowed);
        EObject borrowedValue = (EObject)MergeViewerUtil.getDiffValue((Diff)borrowedDiff);
        Match borrowedMatch = comparison.getMatch(borrowedValue);
        ITypedElement borrowedLeftTypedElement = factory.createLeft((AdapterFactory)fAdapterFactory, (Object)borrowedMatch);
        ITypedElement borrowedRightTypedElement = factory.createRight((AdapterFactory)fAdapterFactory, (Object)borrowedMatch);
        ITypedElement borrowedOriginTypedElement = factory.createAncestor((AdapterFactory)fAdapterFactory, (Object)borrowedMatch);
        if (borrowedLeftTypedElement instanceof MergeViewerItem) {
            diff2 = ((MergeViewerItem)borrowedLeftTypedElement).getDiff();
            Assert.assertEquals((Object)diff2, (Object)borrowedDiff);
        }
        if (borrowedRightTypedElement instanceof MergeViewerItem) {
            diff2 = ((MergeViewerItem)borrowedRightTypedElement).getDiff();
            Assert.assertEquals((Object)diff2, (Object)borrowedDiff);
        }
        if (borrowedOriginTypedElement instanceof MergeViewerItem) {
            diff2 = ((MergeViewerItem)borrowedOriginTypedElement).getDiff();
            Assert.assertEquals((Object)diff2, (Object)borrowedDiff);
        }
        Predicate containmentBorrowed = EMFComparePredicates.addedToReference((String)"extlibrary.Borrower", (String)"eStructuralFeatures", (String)"extlibrary.Borrower.containmentBorrowed");
        Diff containmentBorrowedDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)containmentBorrowed);
        EObject containmentBorrowedValue = (EObject)MergeViewerUtil.getDiffValue((Diff)containmentBorrowedDiff);
        Match containmentBorrowedMatch = comparison.getMatch(containmentBorrowedValue);
        ITypedElement containmentBorrowedLeftTypedElement = factory.createLeft((AdapterFactory)fAdapterFactory, (Object)containmentBorrowedMatch);
        ITypedElement containmentBorrowedRightTypedElement = factory.createRight((AdapterFactory)fAdapterFactory, (Object)containmentBorrowedMatch);
        ITypedElement containmentBorrowedOriginTypedElement = factory.createAncestor((AdapterFactory)fAdapterFactory, (Object)containmentBorrowedMatch);
        if (containmentBorrowedLeftTypedElement instanceof MergeViewerItem) {
            diff = ((MergeViewerItem)containmentBorrowedLeftTypedElement).getDiff();
            Assert.assertEquals((Object)diff, (Object)containmentBorrowedDiff);
        }
        if (containmentBorrowedRightTypedElement instanceof MergeViewerItem) {
            diff = ((MergeViewerItem)containmentBorrowedRightTypedElement).getDiff();
            Assert.assertEquals((Object)diff, (Object)containmentBorrowedDiff);
        }
        if (containmentBorrowedOriginTypedElement instanceof MergeViewerItem) {
            diff = ((MergeViewerItem)containmentBorrowedOriginTypedElement).getDiff();
            Assert.assertEquals((Object)diff, (Object)containmentBorrowedDiff);
        }
    }
}

