/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.tests.unit;

import org.eclipse.emf.compare.ide.ui.tests.unit.AbstractGitLogicalModelTest;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jgit.revwalk.RevCommit;
import org.junit.Before;
import org.junit.Test;

public class GitLogicalModelTest
extends AbstractGitLogicalModelTest {
    private static final String FILE1_SUFFIX = "_file1";
    private static final String FILE2_SUFFIX = "_file2";
    private String[] masterTipSynonyms;
    private String[] branchTipSynonyms;
    private RevCommit[] commits = new RevCommit[7];

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.resource1.getContents().add((Object)this.createBasicModel(FILE1_SUFFIX));
        this.resource2.getContents().add((Object)this.createBasicModel(FILE2_SUFFIX));
        this.makeCrossReference(this.resource1, this.resource2, "Class_A", "Class_A");
        this.makeCrossReference(this.resource2, this.resource1, "Class_B", "Class_B");
        this.save(new Resource[]{this.resource1, this.resource2});
        this.commits[0] = this.repository.addAndCommit(this.project, "master-commit-1", this.file1, this.file2);
        EPackage packFile2 = (EPackage)this.findObject(this.resource2, "package");
        EClass newClassFile2 = this.createClass(packFile2, "Class_C_file2");
        this.save(new Resource[]{this.resource2});
        this.commits[1] = this.repository.addAndCommit(this.project, "master-commit-2", this.file2);
        newClassFile2.setName("Class_D_file2");
        this.save(new Resource[]{this.resource2});
        this.commits[2] = this.repository.addAndCommit(this.project, "master-commit-3", this.file2);
        this.repository.createBranch("refs/heads/master", "refs/heads/branch");
        packFile2.getEClassifiers().remove((Object)newClassFile2);
        this.save(new Resource[]{this.resource2});
        this.commits[3] = this.repository.addAndCommit(this.project, "master-commit-4", this.file2);
        EClass classBFile1 = (EClass)this.findObject(this.resource1, "Class_B");
        EClass classBFile2 = (EClass)this.findObject(this.resource2, "Class_B");
        classBFile1.setName("Class_C_file1");
        classBFile2.setName("Class_C_file2");
        this.save(new Resource[]{this.resource1, this.resource2});
        this.commits[4] = this.repository.addAndCommit(this.project, "master-commit-5", this.file1, this.file2);
        this.repository.checkoutBranch("refs/heads/branch");
        this.reload(new Resource[]{this.resource1, this.resource2});
        EClass classAFile1 = (EClass)this.findObject(this.resource1, "Class_A");
        EClass classAFile2 = (EClass)this.findObject(this.resource2, "Class_A");
        classAFile1.setName("Class_C_file1");
        classAFile2.setName("Class_C_file2");
        this.save(new Resource[]{this.resource1, this.resource2});
        this.commits[5] = this.repository.addAndCommit(this.project, "branch-commit-1", this.file1, this.file2);
        EcoreUtil.remove((EObject)this.findObject(this.resource2, "Class_D"));
        this.save(new Resource[]{this.resource2});
        this.commits[6] = this.repository.addAndCommit(this.project, "branch-commit-2", this.file2);
        this.masterTipSynonyms = new String[]{"refs/heads/master", this.commits[4].getName()};
        this.branchTipSynonyms = new String[]{"refs/heads/branch", this.commits[6].getName()};
    }

    @Test
    public void testCompareTipsFile1() throws Exception {
        String[] stringArray = this.masterTipSynonyms;
        int n = this.masterTipSynonyms.length;
        int n2 = 0;
        while (n2 < n) {
            String masterTip = stringArray[n2];
            String[] stringArray2 = this.branchTipSynonyms;
            int n3 = this.branchTipSynonyms.length;
            int n4 = 0;
            while (n4 < n3) {
                String branchTip = stringArray2[n4];
                this.compareBothDirectionsAndCheck(this.iFile1, masterTip, branchTip, 1, 3, 3);
                ++n4;
            }
            ++n2;
        }
    }

    @Test
    public void testCompareMasterTipWithBranchingPoint() throws Exception {
        String branchingPoint = this.commits[2].getName();
        String[] stringArray = this.masterTipSynonyms;
        int n = this.masterTipSynonyms.length;
        int n2 = 0;
        while (n2 < n) {
            String masterTip = stringArray[n2];
            this.compareBothDirectionsAndCheck(this.iFile1, masterTip, branchingPoint, 0, 3, 0);
            ++n2;
        }
    }

    @Test
    public void testCompareBranchTipWithBranchingPoint() throws Exception {
        String branchingPoint = this.commits[2].getName();
        String[] stringArray = this.branchTipSynonyms;
        int n = this.branchTipSynonyms.length;
        int n2 = 0;
        while (n2 < n) {
            String branchTip = stringArray[n2];
            this.compareBothDirectionsAndCheck(this.iFile1, branchTip, branchingPoint, 0, 3, 0);
            ++n2;
        }
    }

    @Test
    public void testCompareMasterTipWithInitial() throws Exception {
        String initialCommit = this.commits[0].getName();
        String[] stringArray = this.masterTipSynonyms;
        int n = this.masterTipSynonyms.length;
        int n2 = 0;
        while (n2 < n) {
            String masterTip = stringArray[n2];
            this.compareBothDirectionsAndCheck(this.iFile1, masterTip, initialCommit, 0, 2, 0);
            ++n2;
        }
    }

    @Test
    public void testCompareBranchTipWithInitial() throws Exception {
        String initialCommit = this.commits[0].getName();
        String[] stringArray = this.branchTipSynonyms;
        int n = this.branchTipSynonyms.length;
        int n2 = 0;
        while (n2 < n) {
            String branchTip = stringArray[n2];
            this.compareBothDirectionsAndCheck(this.iFile1, branchTip, initialCommit, 0, 2, 0);
            ++n2;
        }
    }

    @Test
    public void testCompareSecondToLastCommitBothBranch() throws Exception {
        String masterCommit = this.commits[3].getName();
        String branchCommit = this.commits[5].getName();
        this.compareBothDirectionsAndCheck(this.iFile1, masterCommit, branchCommit, 0, 1, 2);
    }
}

