/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.tests.conflict.data.bug484557;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.Collection;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.AttributeChange;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.ResourceAttachmentChange;
import org.eclipse.emf.compare.scope.DefaultComparisonScope;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.compare.tests.conflict.data.bug484557.Conflict484557InputData;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.resource.Resource;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class Bug484557ConflictTest {
    private Conflict484557InputData input = new Conflict484557InputData();

    @Test
    public void testAttributeConflict() throws IOException {
        Resource ancestor = this.input.getAttributeAncestorResource();
        Resource left = this.input.getAttributeLeftResource();
        Resource right = this.input.getAttributeRightResource();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)ancestor);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        EList conflicts = comparison.getConflicts();
        Assert.assertEquals((long)2L, (long)differences.size());
        Assert.assertEquals((long)1L, (long)conflicts.size());
        Assert.assertTrue((boolean)((Conflict)conflicts.get(0)).getDifferences().containsAll((Collection)differences));
        Iterable raChanges = Iterables.filter((Iterable)differences, ResourceAttachmentChange.class);
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)raChanges));
        Assert.assertEquals((Object)DifferenceSource.LEFT, (Object)((ResourceAttachmentChange)raChanges.iterator().next()).getSource());
        Iterable attChanges = Iterables.filter((Iterable)differences, AttributeChange.class);
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)attChanges));
        Assert.assertEquals((Object)DifferenceSource.RIGHT, (Object)((AttributeChange)attChanges.iterator().next()).getSource());
    }

    @Test
    public void testSingleReferenceConflict() throws IOException {
        Resource ancestor = this.input.getSingleRefAncestorResource();
        Resource left = this.input.getSingleRefLeftResource();
        Resource right = this.input.getSingleRefRightResource();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)ancestor);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        EList conflicts = comparison.getConflicts();
        Assert.assertEquals((long)3L, (long)differences.size());
        Assert.assertEquals((long)1L, (long)conflicts.size());
        Assert.assertTrue((boolean)((Conflict)conflicts.get(0)).getDifferences().containsAll((Collection)differences));
        Iterable raChanges = Iterables.filter((Iterable)differences, ResourceAttachmentChange.class);
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)raChanges));
        ResourceAttachmentChange rac = (ResourceAttachmentChange)raChanges.iterator().next();
        Assert.assertEquals((Object)DifferenceSource.LEFT, (Object)rac.getSource());
        Assert.assertEquals((Object)DifferenceKind.DELETE, (Object)rac.getKind());
        Iterable refChanges = Iterables.filter((Iterable)differences, ReferenceChange.class);
        Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)refChanges));
        Assert.assertTrue((boolean)Iterables.any((Iterable)refChanges, (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT)));
        Assert.assertTrue((boolean)Iterables.any((Iterable)refChanges, (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT)));
    }

    @Test
    public void testMultiReferenceConflict() throws IOException {
        Resource ancestor = this.input.getMultiRefAncestorResource();
        Resource left = this.input.getMultiRefLeftResource();
        Resource right = this.input.getMultiRefRightResource();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)ancestor);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        EList conflicts = comparison.getConflicts();
        Assert.assertEquals((long)3L, (long)differences.size());
        Assert.assertEquals((long)1L, (long)conflicts.size());
        Assert.assertEquals((long)2L, (long)((Conflict)conflicts.get(0)).getDifferences().size());
        Iterable raChanges = Iterables.filter((Iterable)differences, ResourceAttachmentChange.class);
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)raChanges));
        ResourceAttachmentChange rac = (ResourceAttachmentChange)raChanges.iterator().next();
        Assert.assertEquals((Object)DifferenceSource.LEFT, (Object)rac.getSource());
        Assert.assertEquals((Object)DifferenceKind.DELETE, (Object)rac.getKind());
        Iterable refChanges = Iterables.filter((Iterable)differences, ReferenceChange.class);
        Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)refChanges));
        Assert.assertTrue((boolean)Iterables.any((Iterable)refChanges, (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT)));
        Assert.assertTrue((boolean)Iterables.any((Iterable)refChanges, (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT)));
        ReferenceChange leftRefChange = (ReferenceChange)Iterables.filter((Iterable)refChanges, (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT)).iterator().next();
        Assert.assertNull((Object)leftRefChange.getConflict());
        ReferenceChange rightRefChange = (ReferenceChange)Iterables.filter((Iterable)refChanges, (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT)).iterator().next();
        Assert.assertNotNull((Object)rightRefChange.getConflict());
    }

    @Test
    @Ignore(value="Need to resolve a NPE")
    public void testFeatureMapConflict() throws IOException {
        Resource ancestor = this.input.getFeatureMapAncestorResource();
        Resource left = this.input.getFeatureMapLeftResource();
        Resource right = this.input.getFeatureMapRightResource();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)ancestor);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        EList conflicts = comparison.getConflicts();
        Assert.assertEquals((long)7L, (long)differences.size());
        Assert.assertEquals((long)1L, (long)conflicts.size());
        Assert.assertEquals((long)6L, (long)((Conflict)conflicts.get(0)).getDifferences().size());
    }
}

