/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.postprocessor;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.eclipse.emf.compare.postprocessor.IPostProcessor;
import org.eclipse.emf.compare.scope.IComparisonScope;

public class PostProcessorDescriptorRegistryImpl<K>
implements IPostProcessor.Descriptor.Registry<K> {
    private static Function<IPostProcessor.Descriptor, Integer> ordinal = new Function<IPostProcessor.Descriptor, Integer>(){

        public Integer apply(IPostProcessor.Descriptor from) {
            return from.getOrdinal();
        }
    };
    private final Map<K, IPostProcessor.Descriptor> postProcessorFactories = new ConcurrentHashMap<K, IPostProcessor.Descriptor>();

    @Override
    public void clear() {
        this.postProcessorFactories.clear();
    }

    @Override
    public IPostProcessor.Descriptor put(K key, IPostProcessor.Descriptor postProcessor) {
        return this.postProcessorFactories.put(key, postProcessor);
    }

    @Override
    public List<IPostProcessor.Descriptor> getDescriptors() {
        return Ordering.natural().onResultOf(ordinal).immutableSortedCopy(this.postProcessorFactories.values());
    }

    @Override
    public IPostProcessor.Descriptor remove(K key) {
        return this.postProcessorFactories.remove(key);
    }

    @Override
    public List<IPostProcessor> getPostProcessors(IComparisonScope scope) {
        ImmutableList.Builder processors = ImmutableList.builder();
        block0: for (IPostProcessor.Descriptor factory : this.getDescriptors()) {
            Pattern resourceURIPattern;
            Pattern nsURIPattern = factory.getNsURI();
            if (nsURIPattern != null) {
                for (String nsURI : scope.getNsURIs()) {
                    if (!nsURIPattern.matcher(nsURI).matches()) continue;
                    processors.add((Object)factory.getPostProcessor());
                    break;
                }
            }
            if ((resourceURIPattern = factory.getResourceURI()) == null) continue;
            for (String resourceURI : scope.getResourceURIs()) {
                if (!resourceURIPattern.matcher(resourceURI).matches()) continue;
                processors.add((Object)factory.getPostProcessor());
                continue block0;
            }
        }
        return processors.build();
    }
}

