/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.uml2.papyrus.internal.hook;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.ide.hook.AbstractResourceSetHooks;
import org.eclipse.emf.compare.uml2.papyrus.internal.hook.migration.StereotypeApplicationRepair;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.papyrus.uml.modelrepair.internal.stereotypes.IRepairAction;
import org.eclipse.papyrus.uml.modelrepair.internal.stereotypes.ZombieStereotypesDescriptor;

public class ProfileMigrationHook
extends AbstractResourceSetHooks {
    public void postLoadingHook(ResourceSet resourceSet, Collection<? extends URI> uris) {
        List<Resource> umlResources = this.getUMLResources(resourceSet);
        if (umlResources.isEmpty()) {
            return;
        }
        for (Resource umlResource : umlResources) {
            this.repairProfileApplications(umlResource);
        }
    }

    public boolean isHookFor(Collection<? extends URI> uris) {
        for (URI uRI : uris) {
            if (!this.isUMLResource(uRI)) continue;
            return true;
        }
        return false;
    }

    private boolean isUMLResource(URI uri) {
        return uri != null && "uml".equals(uri.fileExtension());
    }

    private boolean isUMLResource(Resource resource) {
        return resource != null && this.isUMLResource(resource.getURI());
    }

    private List<Resource> getUMLResources(ResourceSet resourceSet) {
        ArrayList<Resource> umlResources = new ArrayList<Resource>();
        for (Resource resource : resourceSet.getResources()) {
            if (!this.isUMLResource(resource)) continue;
            umlResources.add(resource);
        }
        return umlResources;
    }

    protected void repairProfileApplications(Resource resource) {
        if (resource == null) {
            return;
        }
        StereotypeApplicationRepair repair = new StereotypeApplicationRepair(resource);
        ZombieStereotypesDescriptor stereotypesDescriptor = repair.repair();
        if (stereotypesDescriptor == null || !stereotypesDescriptor.hasZombies()) {
            return;
        }
        for (IAdaptable schema : stereotypesDescriptor.getZombieSchemas()) {
            IRepairAction repairAction = stereotypesDescriptor.getSuggestedRepairAction(schema);
            if (repairAction == null) continue;
            stereotypesDescriptor.repair(schema, repairAction, (DiagnosticChain)new BasicDiagnostic(), (IProgressMonitor)new NullProgressMonitor());
        }
    }
}

