/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.match.impl;

import org.eclipse.emf.compare.match.DefaultComparisonFactory;
import org.eclipse.emf.compare.match.DefaultEqualityHelperFactory;
import org.eclipse.emf.compare.match.DefaultMatchEngine;
import org.eclipse.emf.compare.match.IComparisonFactory;
import org.eclipse.emf.compare.match.IMatchEngine;
import org.eclipse.emf.compare.match.eobject.IEObjectMatcher;
import org.eclipse.emf.compare.match.eobject.WeightProvider;
import org.eclipse.emf.compare.match.eobject.WeightProviderDescriptorRegistryImpl;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.compare.utils.UseIdentifiers;

public class MatchEngineFactoryImpl
implements IMatchEngine.Factory {
    protected IMatchEngine matchEngine;
    private int ranking;
    private WeightProvider.Descriptor.Registry weightProviderRegistry;

    public MatchEngineFactoryImpl() {
        this(UseIdentifiers.WHEN_AVAILABLE, WeightProviderDescriptorRegistryImpl.createStandaloneInstance());
    }

    public MatchEngineFactoryImpl(UseIdentifiers useIDs) {
        this(useIDs, WeightProviderDescriptorRegistryImpl.createStandaloneInstance());
    }

    public MatchEngineFactoryImpl(UseIdentifiers useIDs, WeightProvider.Descriptor.Registry registry) {
        DefaultComparisonFactory comparisonFactory = new DefaultComparisonFactory(new DefaultEqualityHelperFactory());
        this.weightProviderRegistry = registry;
        IEObjectMatcher matcher = DefaultMatchEngine.createDefaultEObjectMatcher(useIDs, this.weightProviderRegistry);
        this.matchEngine = new DefaultMatchEngine(matcher, comparisonFactory);
    }

    public MatchEngineFactoryImpl(IEObjectMatcher matcher, IComparisonFactory comparisonFactory) {
        this.matchEngine = new DefaultMatchEngine(matcher, comparisonFactory);
    }

    @Override
    public IMatchEngine getMatchEngine() {
        return this.matchEngine;
    }

    @Override
    public int getRanking() {
        return this.ranking;
    }

    @Override
    public void setRanking(int r) {
        this.ranking = r;
    }

    @Override
    public boolean isMatchEngineFactoryFor(IComparisonScope scope) {
        return true;
    }

    void setWeightProviderRegistry(WeightProvider.Descriptor.Registry registry) {
        this.weightProviderRegistry = registry;
    }
}

