/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.handler;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.ICompareContainer;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.domain.ICompareEditingDomain;
import org.eclipse.emf.compare.domain.impl.EMFCompareEditingDomain;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIMessages;
import org.eclipse.emf.compare.ide.ui.internal.configuration.EMFCompareConfiguration;
import org.eclipse.emf.compare.ide.ui.internal.editor.ComparisonScopeEditorInput;
import org.eclipse.emf.compare.ide.ui.internal.handler.SelectAncestorDialog;
import org.eclipse.emf.compare.ide.ui.internal.logical.ComparisonScopeBuilder;
import org.eclipse.emf.compare.ide.ui.logical.SynchronizationModel;
import org.eclipse.emf.compare.ide.ui.source.IEMFComparisonSource;
import org.eclipse.emf.compare.ide.utils.StorageTraversal;
import org.eclipse.emf.compare.rcp.EMFCompareRCPPlugin;
import org.eclipse.emf.compare.rcp.internal.extension.impl.EMFCompareBuilderConfigurator;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class EMFComparisonSourceActionHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEMFComparisonSource originSource;
        IEMFComparisonSource rightSource;
        IEMFComparisonSource leftSource;
        IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        IEMFComparisonSource[] sources = this.adaptSelection(selection.toList());
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory((ComposedAdapterFactory.Descriptor.Registry)EMFCompareRCPPlugin.getDefault().createFilteredAdapterFactoryRegistry((Map)Maps.newLinkedHashMap()));
        if (sources.length == 3) {
            Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
            SelectAncestorDialog<IEMFComparisonSource> dialog = new SelectAncestorDialog<IEMFComparisonSource>(shell, (AdapterFactory)adapterFactory, sources);
            if (dialog.open() == 1) {
                return null;
            }
            leftSource = (IEMFComparisonSource)dialog.leftElement;
            rightSource = (IEMFComparisonSource)dialog.rightElement;
            originSource = (IEMFComparisonSource)dialog.originElement;
        } else if (sources.length == 2) {
            leftSource = sources[0];
            rightSource = sources[1];
            originSource = null;
        } else {
            return null;
        }
        StorageTraversal left = this.getStorageTraversal(leftSource);
        StorageTraversal right = this.getStorageTraversal(rightSource);
        StorageTraversal origin = this.getStorageTraversal(originSource);
        if (left.getStorages().size() == 0 && right.getStorages().size() == 0 && origin.getStorages().size() == 0) {
            MessageDialog.openError((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)EMFCompareIDEUIMessages.getString("EMFComparisonSourceActionHandler_NoResourcesFound_Title"), (String)EMFCompareIDEUIMessages.getString("EMFComparisonSourceActionHandler_NoResourcesFound_Message"));
            return null;
        }
        SynchronizationModel model = new SynchronizationModel(left, right, origin);
        IComparisonScope scope = ComparisonScopeBuilder.create(model, (IProgressMonitor)new NullProgressMonitor());
        IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        CommandStack commandStack = this.getCommandStack(activePart);
        String inputTitle = MessageFormat.format(EMFCompareIDEUIMessages.getString("EMFComparisonSourceActionHandler_InputTitle_Base"), leftSource.getName(), rightSource.getName());
        if (originSource != null) {
            inputTitle = String.valueOf(inputTitle) + MessageFormat.format(String.valueOf(' ') + EMFCompareIDEUIMessages.getString("EMFComparisonSourceActionHandler_InputTitle_Origin"), originSource.getName());
        }
        CompareEditorInput input = this.createCompareEditorInput(commandStack, (AdapterFactory)adapterFactory, scope, inputTitle);
        CompareUI.openCompareEditor((CompareEditorInput)input);
        return null;
    }

    private IEMFComparisonSource[] adaptSelection(Collection<?> selection) {
        final IAdapterManager adapterManager = Platform.getAdapterManager();
        Iterable sources = Iterables.transform(selection, (Function)new Function<Object, IEMFComparisonSource>(){

            public IEMFComparisonSource apply(Object input) {
                return (IEMFComparisonSource)adapterManager.loadAdapter(input, IEMFComparisonSource.class.getName());
            }
        });
        return (IEMFComparisonSource[])Iterables.toArray((Iterable)sources, IEMFComparisonSource.class);
    }

    private StorageTraversal getStorageTraversal(IEMFComparisonSource source) {
        if (source == null) {
            return new StorageTraversal(new HashSet());
        }
        return source.getStorageTraversal();
    }

    private CompareEditorInput createCompareEditorInput(CommandStack commandStack, AdapterFactory adapterFactory, IComparisonScope scope, String inputTitle) {
        final ICompareEditingDomain editingDomain = this.createEMFCompareEditingDomain(commandStack, scope.getLeft(), scope.getRight(), scope.getOrigin());
        EMFCompareConfiguration configuration = new EMFCompareConfiguration(new CompareConfiguration());
        EMFCompare.Builder builder = EMFCompare.builder();
        IEclipsePreferences preferences = EMFCompareRCPPlugin.getDefault().getEMFComparePreferences();
        EMFCompareBuilderConfigurator engineProvider = preferences != null ? new EMFCompareBuilderConfigurator(preferences, EMFCompareRCPPlugin.getDefault().getMatchEngineFactoryRegistry(), EMFCompareRCPPlugin.getDefault().getPostProcessorRegistry()) : EMFCompareBuilderConfigurator.createDefault();
        engineProvider.configure(builder);
        EMFCompare comparator = builder.build();
        ComparisonScopeEditorInput input = new ComparisonScopeEditorInput(configuration, editingDomain, adapterFactory, comparator, scope){

            protected void handleDispose() {
                super.handleDispose();
                if (editingDomain instanceof IDisposable) {
                    ((IDisposable)editingDomain).dispose();
                }
            }
        };
        input.setTitle(inputTitle);
        configuration.setContainer((ICompareContainer)input);
        return input;
    }

    private CommandStack getCommandStack(Object object) {
        IEditingDomainProvider provider;
        EditingDomain domain;
        if (object instanceof IEditingDomainProvider && (domain = (provider = (IEditingDomainProvider)object).getEditingDomain()) != null) {
            return domain.getCommandStack();
        }
        return null;
    }

    private ICompareEditingDomain createEMFCompareEditingDomain(CommandStack delegatingCommandStack, Notifier left, Notifier right, Notifier origin) {
        if (delegatingCommandStack == null) {
            return EMFCompareEditingDomain.create((Notifier)left, (Notifier)right, (Notifier)origin);
        }
        return EMFCompareEditingDomain.create((Notifier)left, (Notifier)right, (Notifier)origin, (CommandStack)delegatingCommandStack);
    }
}

