/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.provider.spec;

import com.google.common.base.Strings;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.match.MatchOfContainmentReferenceChangeAdapter;
import org.eclipse.emf.compare.match.impl.NotLoadedFragmentMatch;
import org.eclipse.emf.compare.provider.IItemDescriptionProvider;
import org.eclipse.emf.compare.provider.IItemStyledLabelProvider;
import org.eclipse.emf.compare.provider.ISemanticObjectLabelProvider;
import org.eclipse.emf.compare.provider.MatchItemProvider;
import org.eclipse.emf.compare.provider.spec.OverlayImageProvider;
import org.eclipse.emf.compare.provider.spec.ReferenceChangeItemProviderSpec;
import org.eclipse.emf.compare.provider.utils.ComposedStyledString;
import org.eclipse.emf.compare.provider.utils.IStyledString;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;

public class MatchItemProviderSpec
extends MatchItemProvider
implements IItemStyledLabelProvider,
IItemDescriptionProvider,
ISemanticObjectLabelProvider {
    private final OverlayImageProvider overlayProvider;
    private final AdapterFactoryItemDelegator itemDelegator = new AdapterFactoryItemDelegator(this.getRootAdapterFactory());

    public MatchItemProviderSpec(AdapterFactory adapterFactory) {
        super(adapterFactory);
        this.overlayProvider = new OverlayImageProvider(this.getResourceLocator());
    }

    public Object getImage(Object object) {
        ReferenceChange referenceChange;
        Adapter adapter;
        Match match = (Match)object;
        Object ret = this.itemDelegator.getImage((Object)match.getLeft());
        if (ret == null) {
            ret = this.itemDelegator.getImage((Object)match.getOrigin());
        }
        if (ret == null) {
            ret = this.itemDelegator.getImage((Object)match.getRight());
        }
        if (ret == null && match instanceof NotLoadedFragmentMatch) {
            ret = this.itemDelegator.getImage((Object)((NotLoadedFragmentMatch)match).getResource());
        }
        if (ret == null && (adapter = EcoreUtil.getAdapter((List)match.eAdapters(), MatchOfContainmentReferenceChangeAdapter.class)) instanceof MatchOfContainmentReferenceChangeAdapter && (referenceChange = ((MatchOfContainmentReferenceChangeAdapter)adapter).getReferenceChange()) != null) {
            ret = this.itemDelegator.getImage((Object)referenceChange.getValue());
        }
        if (ret == null) {
            ret = super.getImage(object);
        }
        Object matchImage = this.overlayProvider.getComposedImage(match, ret);
        ret = this.overlayImage(object, matchImage);
        return ret;
    }

    public String getText(Object object) {
        Match match = (Match)object;
        String ret = this.itemDelegator.getText((Object)match.getLeft());
        if (Strings.isNullOrEmpty((String)ret)) {
            ret = this.itemDelegator.getText((Object)match.getOrigin());
        }
        if (Strings.isNullOrEmpty((String)ret)) {
            ret = this.itemDelegator.getText((Object)match.getRight());
        }
        if (Strings.isNullOrEmpty((String)ret)) {
            if (match instanceof NotLoadedFragmentMatch) {
                ret = "[ ... ]";
                String name = ((NotLoadedFragmentMatch)match).getName();
                if (!Strings.isNullOrEmpty((String)name)) {
                    ret = String.valueOf(ret) + " (" + name + ")";
                }
            } else {
                Adapter matchAdapter = EcoreUtil.getAdapter((List)match.eAdapters(), MatchOfContainmentReferenceChangeAdapter.class);
                if (matchAdapter instanceof MatchOfContainmentReferenceChangeAdapter) {
                    ReferenceChange referenceChange = ((MatchOfContainmentReferenceChangeAdapter)matchAdapter).getReferenceChange();
                    Adapter rcAdapter = null;
                    if (referenceChange != null) {
                        rcAdapter = EcoreUtil.getAdapter((List)referenceChange.eAdapters(), ReferenceChangeItemProviderSpec.class);
                    }
                    if (rcAdapter instanceof ReferenceChangeItemProviderSpec) {
                        ret = ((ReferenceChangeItemProviderSpec)rcAdapter).getValueText(referenceChange);
                    }
                }
                if (Strings.isNullOrEmpty((String)ret)) {
                    ret = super.getText(object);
                }
            }
        }
        return ret;
    }

    public IStyledString.IComposedStyledString getStyledText(Object object) {
        ComposedStyledString styledString = new ComposedStyledString(this.getText(object));
        return styledString;
    }

    public String getSemanticObjectLabel(Object object) {
        Match match = (Match)object;
        String ret = this.itemDelegator.getText((Object)match.getLeft());
        if (Strings.isNullOrEmpty((String)ret)) {
            ret = this.itemDelegator.getText((Object)match.getOrigin());
        }
        if (Strings.isNullOrEmpty((String)ret)) {
            ret = this.itemDelegator.getText((Object)match.getRight());
        }
        return ret;
    }

    public String getDescription(Object object) {
        return this.getText(object);
    }
}

