/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diagram.ide.ui.papyrus.internal.postprocessor;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.ResourceAttachmentChange;
import org.eclipse.emf.compare.diagram.ide.ui.papyrus.internal.CompareUIPapyrusMessages;
import org.eclipse.emf.compare.utils.EMFComparePredicates;

public class AddEquivalencesBetweenPapyrusRenames {
    private static final String UML_EXTENSION = ".uml";
    private final Comparison comparison;
    private final Monitor monitor;
    private final Multimap<String, ResourceAttachmentChange> changesByTrimmedURI = LinkedHashMultimap.create((int)10, (int)4);

    public AddEquivalencesBetweenPapyrusRenames(Comparison comparison, Monitor monitor) {
        this.comparison = (Comparison)Preconditions.checkNotNull((Object)comparison);
        this.monitor = (Monitor)Preconditions.checkNotNull((Object)monitor);
    }

    public void run() {
        this.monitor.subTask(CompareUIPapyrusMessages.getString("AddEquivalencesBetweenPapyrusRenames.TaskLabel"));
        this.indexLocationChanges();
        for (ResourceAttachmentChange resourceAttachmentChange : this.changesByTrimmedURI.values()) {
            String resourceURI = resourceAttachmentChange.getResourceURI();
            if (!resourceURI.endsWith(UML_EXTENSION)) continue;
            this.addEquivalences(resourceAttachmentChange);
        }
    }

    private void indexLocationChanges() {
        for (Diff change : Iterables.filter((Iterable)this.comparison.getDifferences(), (Predicate)Predicates.and((Predicate)Predicates.instanceOf(ResourceAttachmentChange.class), (Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.MOVE)))) {
            this.changesByTrimmedURI.put((Object)this.getIndexKey((ResourceAttachmentChange)change), (Object)((ResourceAttachmentChange)change));
        }
    }

    private void addEquivalences(ResourceAttachmentChange umlLocationChange) {
        for (ResourceAttachmentChange relatedChange : this.changesByTrimmedURI.get((Object)this.getIndexKey(umlLocationChange))) {
            if (relatedChange == umlLocationChange || relatedChange.getSource() != umlLocationChange.getSource()) continue;
            umlLocationChange.getRequires().add((Object)relatedChange);
            relatedChange.getRequires().add((Object)umlLocationChange);
        }
    }

    private String getIndexKey(ResourceAttachmentChange change) {
        String uri = change.getResourceURI();
        int dot = uri.lastIndexOf(".");
        if (dot >= 0) {
            return uri.substring(0, dot);
        }
        return uri;
    }
}

