/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.internal.contentmergeviewer.accessor.impl;

import com.google.common.collect.ImmutableList;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.MatchResource;
import org.eclipse.emf.compare.ResourceLocationChange;
import org.eclipse.emf.compare.rcp.ui.contentmergeviewer.accessor.ICompareAccessor;
import org.eclipse.emf.compare.rcp.ui.contentmergeviewer.accessor.legacy.impl.AbstractTypedElementAdapter;
import org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.item.impl.MergeViewerItem;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.IMergeViewer;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.item.IMergeViewerItem;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceLocationChangeAccessorImpl
extends AbstractTypedElementAdapter
implements ICompareAccessor {
    private final ResourceLocationChange fDiff;
    private final IMergeViewer.MergeViewerSide fSide;
    private final MatchResource fOwnerMatchResource;
    private final Comparison fComparison;

    public ResourceLocationChangeAccessorImpl(AdapterFactory adapterFactory, ResourceLocationChange diff, IMergeViewer.MergeViewerSide side) {
        super(adapterFactory);
        this.fDiff = diff;
        this.fSide = side;
        this.fOwnerMatchResource = (MatchResource)diff.eContainer();
        this.fComparison = this.fOwnerMatchResource.getComparison();
    }

    @Override
    public Comparison getComparison() {
        return this.fComparison;
    }

    @Override
    public IMergeViewerItem getInitialItem() {
        return new MergeViewerItem(this.fComparison, (Diff)this.fDiff, this.fOwnerMatchResource.getLeft(), this.fOwnerMatchResource.getRight(), this.fOwnerMatchResource.getOrigin(), this.fSide, this.getRootAdapterFactory());
    }

    @Override
    public ImmutableList<? extends IMergeViewerItem> getItems() {
        return ImmutableList.of((Object)this.getInitialItem());
    }

    @Override
    public String getName() {
        return ResourceLocationChangeAccessorImpl.class.getName();
    }

    @Override
    public Image getImage() {
        Object image = this.getItemDelegator().getImage((Object)this.getResource());
        return ExtendedImageRegistry.getInstance().getImage(image);
    }

    @Override
    public String getType() {
        return "org.eclipse.emf.compare.rcp.ui.eResourceDiff";
    }

    private Resource getResource() {
        Resource resource = this.fOwnerMatchResource.getLeft();
        if (resource == null) {
            resource = this.fOwnerMatchResource.getRight();
        }
        if (resource == null) {
            resource = this.fOwnerMatchResource.getOrigin();
        }
        return resource;
    }
}

