/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer;

import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.structuremergeviewer.ICompareInputChangeListener;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.MatchResource;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.accessor.AccessorAdapter;
import org.eclipse.emf.compare.provider.ExtendedAdapterFactoryItemDelegator;
import org.eclipse.emf.compare.rcp.ui.EMFCompareRCPUIPlugin;
import org.eclipse.emf.compare.rcp.ui.internal.contentmergeviewer.accessor.factory.IAccessorFactory;
import org.eclipse.emf.compare.rcp.ui.internal.contentmergeviewer.accessor.legacy.ITypedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.tree.TreeNode;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.swt.graphics.Image;

public abstract class CompareInputAdapter
extends AdapterImpl
implements ICompareInput,
IDisposable {
    private final ListenerList fListener;
    private final AdapterFactory fAdapterFactory;
    private final ExtendedAdapterFactoryItemDelegator itemDelegator;

    public CompareInputAdapter(AdapterFactory adapterFactory) {
        this.fAdapterFactory = adapterFactory;
        this.itemDelegator = new ExtendedAdapterFactoryItemDelegator(this.getRootAdapterFactory());
        this.fListener = new ListenerList();
    }

    public boolean isAdapterForType(Object type) {
        return type == this.fAdapterFactory;
    }

    protected final AdapterFactory getAdapterFactory() {
        return this.fAdapterFactory;
    }

    protected final AdapterFactory getRootAdapterFactory() {
        if (this.fAdapterFactory instanceof ComposeableAdapterFactory) {
            return ((ComposeableAdapterFactory)this.fAdapterFactory).getRootAdapterFactory();
        }
        return this.fAdapterFactory;
    }

    public void addCompareInputChangeListener(ICompareInputChangeListener listener) {
        this.fListener.add((Object)listener);
    }

    public void removeCompareInputChangeListener(ICompareInputChangeListener listener) {
        this.fListener.remove((Object)listener);
    }

    protected void fireChange() {
        if (this.fListener != null) {
            Object[] listeners = this.fListener.getListeners();
            int i = 0;
            while (i < listeners.length) {
                final ICompareInputChangeListener listener = (ICompareInputChangeListener)listeners[i];
                SafeRunnable runnable = new SafeRunnable(){

                    public void run() throws Exception {
                        listener.compareInputChanged((ICompareInput)CompareInputAdapter.this);
                    }
                };
                SafeRunner.run((ISafeRunnable)runnable);
                ++i;
            }
        }
    }

    public EObject getComparisonObject() {
        if (this.getTarget() != null) {
            return ((TreeNode)this.getTarget()).getData();
        }
        return null;
    }

    public void copy(boolean leftToRight) {
    }

    protected IAccessorFactory getAccessorFactoryForTarget() {
        IAccessorFactory.Registry factoryRegistry = EMFCompareRCPUIPlugin.getDefault().getAccessorFactoryRegistry();
        return factoryRegistry.getHighestRankingFactory((Object)this.getComparisonObject());
    }

    public Image getImage() {
        Object imageObject = this.itemDelegator.getImage((Object)this.getComparisonObject());
        return ExtendedImageRegistry.getInstance().getImage(imageObject);
    }

    public int getKind() {
        EObject notifier = this.getComparisonObject();
        boolean isThreeWay = false;
        if (notifier instanceof Diff) {
            isThreeWay = ((Diff)notifier).getMatch().getComparison().isThreeWay();
        } else if (notifier instanceof Match) {
            isThreeWay = ((Match)notifier).getComparison().isThreeWay();
        } else if (notifier instanceof Conflict) {
            isThreeWay = true;
        } else if (notifier instanceof MatchResource) {
            isThreeWay = ((MatchResource)notifier).getComparison().isThreeWay();
        }
        if (isThreeWay) {
            return 12;
        }
        return 0;
    }

    public String getName() {
        return this.itemDelegator.getText((Object)this.getComparisonObject());
    }

    public org.eclipse.compare.ITypedElement getAncestor() {
        ITypedElement typedElement;
        IAccessorFactory accessorFactory;
        EObject notifier = this.getComparisonObject();
        boolean isThreeWay = this.isThreeWay((Notifier)notifier);
        AccessorAdapter ret = isThreeWay ? ((accessorFactory = this.getAccessorFactoryForTarget()) != null ? ((typedElement = accessorFactory.createAncestor(this.getAdapterFactory(), (Object)this.getComparisonObject())) != null ? AccessorAdapter.adapt(typedElement) : null) : null) : null;
        return ret;
    }

    protected boolean isThreeWay(Notifier notifier) {
        boolean isThreeWay = notifier instanceof Diff ? ((Diff)notifier).getMatch().getComparison().isThreeWay() : (notifier instanceof Match ? ((Match)notifier).getComparison().isThreeWay() : (notifier instanceof Conflict ? true : (notifier instanceof MatchResource ? ((MatchResource)notifier).getComparison().isThreeWay() : (notifier instanceof Comparison ? ((Comparison)notifier).isThreeWay() : false))));
        return isThreeWay;
    }

    public org.eclipse.compare.ITypedElement getLeft() {
        ITypedElement typedElement;
        IAccessorFactory accessorFactory = this.getAccessorFactoryForTarget();
        AccessorAdapter ret = accessorFactory != null ? ((typedElement = accessorFactory.createLeft(this.getAdapterFactory(), (Object)this.getComparisonObject())) != null ? AccessorAdapter.adapt(typedElement) : null) : null;
        return ret;
    }

    public org.eclipse.compare.ITypedElement getRight() {
        ITypedElement typedElement;
        IAccessorFactory accessorFactory = this.getAccessorFactoryForTarget();
        AccessorAdapter ret = accessorFactory != null ? ((typedElement = accessorFactory.createRight(this.getAdapterFactory(), (Object)this.getComparisonObject())) != null ? AccessorAdapter.adapt(typedElement) : null) : null;
        return ret;
    }

    public void dispose() {
        Notifier oldTarget = this.target;
        this.target = null;
        if (oldTarget != null) {
            oldTarget.eAdapters().remove((Object)this);
        }
    }
}

