/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.impl;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.MatchResource;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.BasicDifferenceGroupImpl;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.IDifferenceGroup;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.IDifferenceGroupProvider;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.impl.AbstractDifferenceGroupProvider;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.edit.tree.TreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ByResourceGroupProvider
extends AbstractDifferenceGroupProvider {
    private String label;
    private boolean activeByDefault;
    private IDifferenceGroup group;
    private Comparison comp;

    @Override
    public Collection<? extends IDifferenceGroup> getGroups(Comparison comparison) {
        if (this.group == null || !comparison.equals(this.comp)) {
            this.dispose();
            this.comp = comparison;
            this.group = new ResourceGroup(comparison, this, this.getCrossReferenceAdapter());
        }
        return ImmutableList.of((Object)this.group);
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public boolean defaultSelected() {
        return this.activeByDefault;
    }

    @Override
    public void setDefaultSelected(boolean activeByDefault) {
        this.activeByDefault = activeByDefault;
    }

    @Override
    public boolean isEnabled(IComparisonScope scope, Comparison comparison) {
        return true;
    }

    @Override
    public void dispose() {
        this.comp = null;
        if (this.group != null) {
            this.group.dispose();
            this.group = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ResourceGroup
    extends BasicDifferenceGroupImpl {
        public ResourceGroup(Comparison comparison, IDifferenceGroupProvider groupProvider, ECrossReferenceAdapter crossReferenceAdapter) {
            super(comparison, groupProvider, (Predicate<? super Diff>)Predicates.alwaysTrue(), crossReferenceAdapter);
        }

        @Override
        public List<? extends TreeNode> getChildren() {
            if (this.children == null) {
                this.children = Lists.newArrayList();
                for (MatchResource matchResource : this.getComparison().getMatchedResources()) {
                    this.children.add(this.buildSubTree(matchResource));
                }
                this.registerCrossReferenceAdapter(this.children);
            }
            return this.children;
        }

        @Override
        protected TreeNode buildSubTree(MatchResource matchResource) {
            TreeNode ret = this.wrap((EObject)matchResource);
            for (Match match : this.getComparison().getMatches()) {
                ret.getChildren().addAll(this.buildSubTree(matchResource, match));
            }
            return ret;
        }

        @Override
        protected List<TreeNode> buildSubTree(MatchResource matchResource, Match match) {
            ArrayList ret = Lists.newArrayList();
            if (this.isRootOfResourceURI(match.getLeft(), matchResource.getLeftURI()) || this.isRootOfResourceURI(match.getRight(), matchResource.getRightURI()) || this.isRootOfResourceURI(match.getOrigin(), matchResource.getOriginURI())) {
                ret.addAll(this.buildSubTree((Match)null, match));
            } else {
                for (Match subMatch : match.getSubmatches()) {
                    ret.addAll(this.buildSubTree(matchResource, subMatch));
                }
            }
            return ret;
        }

        @Override
        public List<TreeNode> buildSubTree(Match parentMatch, Match match) {
            ArrayList ret = Lists.newArrayList();
            boolean isContainment = false;
            if (parentMatch != null) {
                Collection containmentChanges = Collections2.filter((Collection)parentMatch.getDifferences(), this.containmentReferenceForMatch(match));
                if (!containmentChanges.isEmpty()) {
                    isContainment = true;
                    for (Diff diff : containmentChanges) {
                        ret.add(this.wrap((EObject)diff));
                    }
                }
            } else {
                Collection resourceAttachmentChanges = Collections2.filter((Collection)match.getDifferences(), ResourceGroup.resourceAttachmentChange());
                if (!resourceAttachmentChanges.isEmpty()) {
                    for (Diff diff : resourceAttachmentChanges) {
                        ret.add(this.wrap((EObject)diff));
                    }
                }
            }
            if (ret.isEmpty() && !this.matchWithLeftAndRightInDifferentContainer(match)) {
                ret.add(this.wrap((EObject)match));
            }
            ArrayList toRemove = Lists.newArrayList();
            for (TreeNode treeNode : ret) {
                TreeNode buildSubTree;
                boolean hasDiff = false;
                boolean hasNonEmptySubMatch = false;
                for (Diff diff : Collections2.filter((Collection)match.getDifferences(), (Predicate)Predicates.and((Predicate)this.filter, (Predicate)Predicates.not((Predicate)Predicates.or((Predicate)EMFComparePredicates.containmentReferenceChange(), ResourceGroup.resourceAttachmentChange()))))) {
                    hasDiff = true;
                    treeNode.getChildren().add((Object)this.wrap((EObject)diff));
                }
                for (Match subMatch : match.getSubmatches()) {
                    buildSubTree = this.buildSubTree(match, subMatch);
                    if (buildSubTree.isEmpty()) continue;
                    hasNonEmptySubMatch = true;
                    treeNode.getChildren().addAll(buildSubTree);
                }
                for (Diff diff : Collections2.filter((Collection)match.getDifferences(), (Predicate)Predicates.and((Predicate)this.filter, (Predicate)EMFComparePredicates.containmentMoveReferenceChange()))) {
                    if (this.containsChildrenWithDataEqualsToDiff(treeNode, diff) || (buildSubTree = this.buildSubTree(diff)) == null) continue;
                    hasDiff = true;
                    treeNode.getChildren().add((Object)buildSubTree);
                    List<TreeNode> matchSubTree = this.buildSubTree((Match)null, this.getComparison().getMatch(((ReferenceChange)diff).getValue()));
                    for (TreeNode matchSubTreeNode : matchSubTree) {
                        buildSubTree.getChildren().addAll((Collection)matchSubTreeNode.getChildren());
                    }
                }
                if (isContainment || hasDiff || hasNonEmptySubMatch || this.filter.equals((Object)Predicates.alwaysTrue())) continue;
                toRemove.add(treeNode);
            }
            ret.removeAll(toRemove);
            return ret;
        }
    }
}

