/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j;

import java.util.concurrent.ExecutorService;
import org.eclipse.internal.net4j.buffer.BufferPoolFactory;
import org.eclipse.net4j.ContainerProtocolProvider;
import org.eclipse.net4j.ITransportConfig;
import org.eclipse.net4j.buffer.IBufferProvider;
import org.eclipse.net4j.util.concurrent.ExecutorServiceFactory;
import org.eclipse.net4j.util.container.IElementProcessor;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.spi.net4j.InternalAcceptor;
import org.eclipse.spi.net4j.InternalConnector;

public class TransportInjector
implements IElementProcessor {
    public Object process(IManagedContainer container, String productGroup, String factoryType, String description, Object element) {
        if (element instanceof InternalAcceptor) {
            InternalAcceptor acceptor = (InternalAcceptor)element;
            this.processAcceptor(container, factoryType, description, acceptor);
        } else if (element instanceof InternalConnector) {
            InternalConnector connector = (InternalConnector)element;
            this.processConnector(container, factoryType, description, connector);
        }
        return element;
    }

    protected void processAcceptor(IManagedContainer container, String factoryType, String description, InternalAcceptor acceptor) {
        ITransportConfig config = acceptor.getConfig();
        if (acceptor.needsBufferProvider() && config.getBufferProvider() == null) {
            config.setBufferProvider(this.getBufferProvider(container));
        }
        if (config.getReceiveExecutor() == null) {
            config.setReceiveExecutor(this.getExecutorService(container));
        }
        if (config.getProtocolProvider() == null) {
            config.setProtocolProvider(new ContainerProtocolProvider.Server(container));
        }
    }

    protected void processConnector(IManagedContainer container, String factoryType, String description, InternalConnector connector) {
        ITransportConfig config = connector.getConfig();
        if (connector.needsBufferProvider() && config.getBufferProvider() == null) {
            config.setBufferProvider(this.getBufferProvider(container));
        }
        if (config.getReceiveExecutor() == null) {
            config.setReceiveExecutor(this.getExecutorService(container));
        }
        if (config.getProtocolProvider() == null) {
            config.setProtocolProvider(new ContainerProtocolProvider.Client(container));
        }
    }

    protected IBufferProvider getBufferProvider(IManagedContainer container) {
        return BufferPoolFactory.get(container);
    }

    protected ExecutorService getExecutorService(IManagedContainer container) {
        return ExecutorServiceFactory.get((IManagedContainer)container);
    }
}

