/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.explorer.ui.repositories.wizards;

import java.util.Properties;
import org.eclipse.emf.cdo.explorer.ui.checkouts.wizards.CheckoutWizardPage;
import org.eclipse.emf.cdo.explorer.ui.repositories.wizards.AbstractRepositoryPage;
import org.eclipse.emf.cdo.explorer.ui.repositories.wizards.MasterRepositoryController;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class RepositoryClonePage
extends AbstractRepositoryPage {
    private MasterRepositoryController controller;
    private Text reconnectSecondsText;
    private Text recommitSecondsText;
    private Text recommitAttemptsText;

    public RepositoryClonePage() {
        super("clone", "Clone Repository");
        this.setTitle("New Clone Repository");
        this.setMessage("Enter label and connection parameters of the new clone repository.");
    }

    @Override
    protected void fillPage(Composite container) {
        RepositoryClonePage.createLabel(container, "Reconnect seconds:");
        this.reconnectSecondsText = RepositoryClonePage.createText(container, 50);
        this.reconnectSecondsText.setText(Integer.toString(3));
        this.reconnectSecondsText.addModifyListener((ModifyListener)this);
        RepositoryClonePage.createLabel(container, "Recommit seconds:");
        this.recommitSecondsText = RepositoryClonePage.createText(container, 50);
        this.recommitSecondsText.setText(Integer.toString(1));
        this.recommitSecondsText.addModifyListener((ModifyListener)this);
        RepositoryClonePage.createLabel(container, "Recommit attempts:");
        this.recommitAttemptsText = RepositoryClonePage.createText(container, 50);
        this.recommitAttemptsText.setText(Integer.toString(10));
        this.recommitAttemptsText.addModifyListener((ModifyListener)this);
    }

    @Override
    protected void doValidate(Properties properties) throws Exception {
        super.doValidate(properties);
        if (this.controller == null) {
            return;
        }
        String connectorDescription = this.controller.getConnectorDescription();
        if (StringUtil.isEmpty((String)connectorDescription)) {
            throw new CheckoutWizardPage.ValidationProblem("Host or port are invalid.");
        }
        String repositoryName = this.controller.getRepositoryName();
        if (StringUtil.isEmpty((String)repositoryName)) {
            throw new CheckoutWizardPage.ValidationProblem("Repository name is empty.");
        }
        String reconnectSeconds = this.reconnectSecondsText.getText();
        try {
            int value = Integer.parseInt(reconnectSeconds);
            if (value < 0) {
                throw new CheckoutWizardPage.ValidationProblem();
            }
        }
        catch (Exception ex) {
            throw new CheckoutWizardPage.ValidationProblem("Invalid reconnect seconds.");
        }
        String recommitSeconds = this.recommitSecondsText.getText();
        try {
            int value = Integer.parseInt(recommitSeconds);
            if (value < 0) {
                throw new CheckoutWizardPage.ValidationProblem();
            }
        }
        catch (Exception ex) {
            throw new CheckoutWizardPage.ValidationProblem("Invalid recommit seconds.");
        }
        String recommitAttempts = this.recommitAttemptsText.getText();
        try {
            int value = Integer.parseInt(recommitAttempts);
            if (value < 0) {
                throw new Exception();
            }
        }
        catch (Exception ex) {
            throw new CheckoutWizardPage.ValidationProblem("Invalid recommit attempts.");
        }
        properties.setProperty("connectorType", "tcp");
        properties.setProperty("connectorDescription", connectorDescription);
        properties.setProperty("name", repositoryName);
        properties.setProperty("reconnectSeconds", reconnectSeconds);
        properties.setProperty("recommitSeconds", recommitSeconds);
        properties.setProperty("recommitAttempts", recommitAttempts);
    }
}

