/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.ecore.logicalstructure;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILogicalStructureType;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.emf.cdo.ecore.logicalstructure.Activator;
import org.eclipse.emf.cdo.ecore.logicalstructure.EMFContainerValue;
import org.eclipse.emf.cdo.ecore.logicalstructure.util.ContainerValue;
import org.eclipse.emf.cdo.ecore.logicalstructure.util.DebugUtil;
import org.eclipse.emf.cdo.ecore.logicalstructure.util.DelegatingObject;
import org.eclipse.emf.cdo.ecore.logicalstructure.util.DelegatingValue;
import org.eclipse.emf.cdo.ecore.logicalstructure.util.Scope;
import org.eclipse.emf.cdo.ecore.logicalstructure.util.Variable;
import org.eclipse.jdt.debug.core.IJavaArray;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.debug.core.IJavaType;
import org.eclipse.jdt.debug.core.IJavaValue;

public class EMFLogicalStructureType
implements ILogicalStructureType {
    public static final EMFLogicalStructureType[] ARRAY = new EMFLogicalStructureType[]{new EMFLogicalStructureType()};
    private static final String INFOS_EXPR = "    org.eclipse.emf.common.util.EList features = eClass().getEAllStructuralFeatures();Object[][] infos = new Object[features.size()][];for (int i = 0; i < features.size(); i++){  org.eclipse.emf.ecore.EStructuralFeature feature = (org.eclipse.emf.ecore.EStructuralFeature)features.get(i);  Class instanceClass = feature.getEType().getInstanceClass();  boolean primitive = instanceClass != null && instanceClass.isPrimitive();  infos[i] = new Object[] { feature.getName(), primitive ? \"1\" : \"0\" };}return infos;";
    private static final String VALUES_EXPR = "    org.eclipse.emf.common.util.EList features = eClass().getEAllStructuralFeatures();Object[] values = new Object[features.size()];for (int i = 0; i < features.size(); i++){  org.eclipse.emf.ecore.EStructuralFeature feature = (org.eclipse.emf.ecore.EStructuralFeature)features.get(i);  Object value = eGet(feature, false);  if (value instanceof org.eclipse.emf.ecore.util.InternalEList)  {    value = ((org.eclipse.emf.ecore.util.InternalEList)value).basicToArray();  }  else if (value instanceof java.util.List)  {    value = ((java.util.List)value).toArray();  }  values[i] = value;}return values;";
    private final Map<IDebugTarget, Map<String, IJavaValue[]>> cache = new WeakHashMap<IDebugTarget, Map<String, IJavaValue[]>>();
    private String infosExpr = "return org.eclipse.emf.ecore.util.EcoreUtil.getAllStructuralFeatureInfos(eClass());";
    private String valuesExpr = "return org.eclipse.emf.ecore.util.EcoreUtil.getAllValues(this);";

    private EMFLogicalStructureType() {
    }

    public String getId() {
        return EMFLogicalStructureType.class.getName();
    }

    public String getDescription() {
        return "EObjects";
    }

    public String getDescription(IValue value) {
        return "EObject";
    }

    public boolean providesLogicalStructure(IValue value) {
        return value instanceof IJavaObject;
    }

    public IValue getLogicalStructure(IValue value) throws CoreException {
        IJavaObject javaValue = (IJavaObject)value;
        IVariable[] variables = this.getLogicalVariables(javaValue);
        return new DelegatingObject(javaValue, variables);
    }

    private IVariable[] getLogicalVariables(IJavaObject eObject) throws CoreException {
        ArrayList<IVariable> result = new ArrayList<IVariable>();
        Scope scope = Scope.create(eObject);
        if (scope != null) {
            EMFContainerValue container = new EMFContainerValue(scope);
            result.add((IVariable)new Variable.Private("[emf]", (IValue)container));
            this.addContributions(eObject, scope, result);
            IJavaValue[] infos = this.getInfos(scope);
            IJavaValue[] values = this.getValues(scope, infos);
            int i = 0;
            while (i < values.length) {
                boolean primitive;
                IJavaValue[] info = ((IJavaArray)infos[i]).getValues();
                IJavaValue value = values[i];
                String featureName = info[0].getValueString();
                boolean bl = primitive = info[1].getValueString().charAt(0) == '1';
                if (primitive) {
                    value = this.unbox(value);
                }
                result.add((IVariable)new Variable(featureName, (IValue)value));
                ++i;
            }
        }
        return result.toArray(new IVariable[result.size()]);
    }

    private void addContributions(IJavaObject eObject, Scope scope, List<IVariable> result) throws DebugException {
        IConfigurationElement[] containerValues;
        IConfigurationElement[] iConfigurationElementArray = containerValues = Activator.getContainerValues();
        int n = containerValues.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement containerValue = iConfigurationElementArray[n2];
            try {
                String typeConstraint = containerValue.getAttribute("typeConstraint");
                if (DebugUtil.isInstanceOf(eObject, typeConstraint)) {
                    String name = containerValue.getAttribute("name");
                    ContributionContainer container = new ContributionContainer(scope, containerValue);
                    result.add((IVariable)new Variable.Private("[" + name + "]", (IValue)container));
                }
            }
            catch (Exception ex) {
                Activator.error(ex);
            }
            ++n2;
        }
    }

    private IJavaValue[] getInfos(Scope scope) throws DebugException {
        IJavaObject value;
        IJavaType javaType;
        String type;
        IJavaValue[] infos;
        IDebugTarget debugTarget = scope.getDebugTarget();
        Map<String, IJavaValue[]> map = this.cache.get(debugTarget);
        if (map == null) {
            map = new HashMap<String, IJavaValue[]>();
            this.cache.put(debugTarget, map);
        }
        if ((infos = map.get(type = (javaType = (value = scope.getValue()).getJavaType()).getName())) == null) {
            try {
                IJavaArray result = (IJavaArray)scope.evaluate(this.infosExpr);
                infos = result.getValues();
            }
            catch (DebugException ex) {
                String message = ex.getMessage();
                if (message != null && message.contains("The method getAllStructuralFeatureInfos(EClass) is undefined for the type EcoreUtil")) {
                    this.infosExpr = INFOS_EXPR;
                    this.valuesExpr = VALUES_EXPR;
                    IJavaArray result = (IJavaArray)scope.evaluate(this.infosExpr);
                    infos = result.getValues();
                }
                Activator.error(ex);
            }
            map.put(type, infos);
        }
        return infos;
    }

    private IJavaValue[] getValues(Scope scope, IJavaValue[] infos) throws DebugException {
        try {
            IJavaArray result = (IJavaArray)scope.evaluate(this.valuesExpr);
            if (result != null) {
                return result.getValues();
            }
        }
        catch (Exception ex) {
            return this.getValuesOneByOne(scope, infos);
        }
        return new IJavaValue[0];
    }

    private IJavaValue[] getValuesOneByOne(Scope scope, IJavaValue[] infos) throws DebugException {
        IJavaValue[] result = new IJavaValue[infos.length];
        int i = 0;
        while (i < infos.length) {
            try {
                String expr = "return eGet(((org.eclipse.emf.ecore.impl.EClassImpl)eClass()).getEAllStructuralFeaturesData()[" + i + "]);";
                result[i] = scope.evaluate(expr);
            }
            catch (Exception ex) {
                Activator.error(ex);
                String featureName = ((IJavaArray)infos[i]).getValue(0).getValueString();
                result[i] = new ErrorValue((IJavaValue)scope.getValue(), featureName, ex);
            }
            ++i;
        }
        return result;
    }

    private IJavaValue unbox(IJavaValue value) throws DebugException {
        IVariable[] variables = value.getVariables();
        int i = 0;
        while (i < variables.length) {
            IVariable variable = variables[i];
            if ("value".equals(variable.getName())) {
                return (IJavaValue)variable.getValue();
            }
            ++i;
        }
        return value;
    }

    private static final class ContributionContainer
    extends ContainerValue {
        private final IConfigurationElement containerValue;

        private ContributionContainer(Scope scope, IConfigurationElement containerValue) {
            super(scope);
            this.containerValue = containerValue;
        }

        @Override
        protected void initVariables(ContainerValue.Variables variables) throws DebugException {
            IConfigurationElement[] iConfigurationElementArray = this.containerValue.getChildren();
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement variable = iConfigurationElementArray[n2];
                String name = variable.getAttribute("name");
                String expression = variable.getAttribute("expression");
                variables.add(name, expression);
                ++n2;
            }
        }
    }

    private static final class ErrorValue
    extends DelegatingValue {
        private final String featureName;
        private final Exception exception;

        private ErrorValue(IJavaValue delegate, String featureName, Exception exception) {
            super(delegate);
            this.featureName = featureName;
            this.exception = exception;
        }

        @Override
        public String getReferenceTypeName() throws DebugException {
            return this.exception.getClass().getName();
        }

        @Override
        public String getValueString() throws DebugException {
            return "Error when evaluating value of feature " + this.featureName;
        }

        @Override
        public boolean hasVariables() throws DebugException {
            return false;
        }
    }
}

