/*
 * Copyright (c) 2007, 2008, 2011, 2012, 2015 Eike Stepper (Loehne, Germany) and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *    Eike Stepper - initial API and implementation
 */
package org.eclipse.net4j.tcp;

import org.eclipse.net4j.connector.IConnector;
import org.eclipse.net4j.tcp.ssl.SSLUtil;

/**
 * A {@link IConnector connector} that implements non-blocking multiplexed TCP transport, optionally with
 * {@link SSLUtil SSL}.
 *
 * @author Eike Stepper
 * @noextend This interface is not intended to be extended by clients.
 * @noimplement This interface is not intended to be implemented by clients.
 */
public interface ITCPConnector extends IConnector
{
  public static final int DEFAULT_PORT = ITCPAcceptor.DEFAULT_PORT;

  /**
   * @since 4.0
   */
  public ITCPSelector getSelector();

  public String getHost();

  public int getPort();
}
