/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.tests.lm;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.List;
import java.util.function.UnaryOperator;
import org.eclipse.emf.cdo.common.lob.CDOClob;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.CDOTextResource;
import org.eclipse.emf.cdo.explorer.checkouts.CDOCheckout;
import org.eclipse.emf.cdo.lm.Baseline;
import org.eclipse.emf.cdo.lm.Module;
import org.eclipse.emf.cdo.lm.Stream;
import org.eclipse.emf.cdo.lm.client.IAssemblyDescriptor;
import org.eclipse.emf.cdo.lm.client.IAssemblyManager;
import org.eclipse.emf.cdo.lm.client.ISystemDescriptor;
import org.eclipse.emf.cdo.lm.client.LMImporter;
import org.eclipse.emf.cdo.tests.lm.AbstractLMTest;
import org.eclipse.emf.cdo.tests.lm.bundle.OM;
import org.eclipse.emf.cdo.tests.model1.Category;
import org.eclipse.emf.cdo.tests.model1.Company;
import org.eclipse.emf.cdo.tests.model1.Customer;
import org.eclipse.emf.cdo.tests.model1.Model1Factory;
import org.eclipse.emf.cdo.tests.model1.SalesOrder;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceFactoryImpl;
import org.eclipse.net4j.util.io.IOUtil;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;

public class LMImporterTest
extends AbstractLMTest {
    public void testModuleImport() throws Exception {
        LMImporter importer = new LMImporter();
        ResourceSet resourceSet = LMImporterTest.createXMLResourceSet();
        Customer externalCustomer = this.createExternalCustomer(resourceSet);
        LMImporter.ImportModule mod0 = this.createTestModule(importer, resourceSet, externalCustomer, "mod0", new String[0]);
        LMImporter.ImportModule mod1 = this.createTestModule(importer, resourceSet, externalCustomer, "mod1", "mod0");
        LMImporter.ImportModule mod2 = this.createTestModule(importer, resourceSet, externalCustomer, "mod2", "mod1", "mod0");
        LMImporter.ImportResolution resolution = importer.resolve(LMImporterTest.createXMLResourceSet());
        MatcherAssert.assertThat((Object)((LMImporter.ImportResolution.ModuleInfo)resolution.getModuleInfos().get(0)).getModule(), (Matcher)CoreMatchers.is((Object)mod0));
        MatcherAssert.assertThat((Object)((LMImporter.ImportResolution.ModuleInfo)resolution.getModuleInfos().get(1)).getModule(), (Matcher)CoreMatchers.is((Object)mod1));
        MatcherAssert.assertThat((Object)((LMImporter.ImportResolution.ModuleInfo)resolution.getModuleInfos().get(2)).getModule(), (Matcher)CoreMatchers.is((Object)mod2));
        ISystemDescriptor systemDescriptor = LMImporterTest.createSystemRepository();
        List modules = resolution.importModules(systemDescriptor);
        MatcherAssert.assertThat((Object)((Module)modules.get(0)).getName(), (Matcher)CoreMatchers.is((Object)mod0.getName()));
        MatcherAssert.assertThat((Object)((Module)modules.get(1)).getName(), (Matcher)CoreMatchers.is((Object)mod1.getName()));
        MatcherAssert.assertThat((Object)((Module)modules.get(2)).getName(), (Matcher)CoreMatchers.is((Object)mod2.getName()));
        Stream mod0Stream = (Stream)((Module)modules.get(0)).getStreams().get(0);
        IAssemblyDescriptor mod0Descriptor = IAssemblyManager.INSTANCE.createDescriptor("base assembly descriptor", (Baseline)mod0Stream, LMImporterTest.monitor());
        CDOCheckout mod0Checkout = mod0Descriptor.getCheckout();
        CDOView mod0View = mod0Checkout.openView(true);
        CDOResource mod0Resource = mod0View.getResource("moved/renamed.xml");
        Company mod0Company = (Company)mod0Resource.getContents().get(0);
        Category mod0Category = (Category)mod0Company.getCategories().get(0);
        MatcherAssert.assertThat((Object)mod0Category.getName(), (Matcher)CoreMatchers.is((Object)"mod0 products"));
        CDOTextResource baseText = mod0View.getTextResource("manifest.txt");
        CDOClob baseClob = baseText.getContents();
        String baseString = baseClob.getString();
        MatcherAssert.assertThat((Object)baseString, (Matcher)CoreMatchers.startsWith((String)"Manifest-Version: 1.0"));
        MatcherAssert.assertThat((Object)baseString, (Matcher)CoreMatchers.containsString((String)"CDO.server.net4j"));
        SalesOrder salesOrder = (SalesOrder)mod0Company.getSalesOrders().get(0);
        Customer customer = salesOrder.getCustomer();
        URI customerURI = EcoreUtil.getURI((EObject)customer);
        MatcherAssert.assertThat((Object)customerURI.scheme(), (Matcher)CoreMatchers.is((Object)"file"));
    }

    private Customer createExternalCustomer(ResourceSet resourceSet) throws IOException {
        File xmlDir = this.getTestFolder("xml");
        URI xmlURI = URI.createFileURI((String)xmlDir.getAbsolutePath());
        Resource resource = resourceSet.createResource(xmlURI.appendSegment("external.xml"));
        Customer externalCustomer = Model1Factory.eINSTANCE.createCustomer();
        externalCustomer.setName("external customer");
        resource.getContents().add((Object)externalCustomer);
        resource.save(null);
        return externalCustomer;
    }

    /*
     * Unable to fully structure code
     */
    private LMImporter.ImportModule createTestModule(LMImporter importer, ResourceSet resourceSet, Customer externalCustomer, String name, String ... dependencies) throws IOException {
        xmlDir = this.getTestFolder("xml");
        xmlURI = URI.createFileURI((String)xmlDir.getAbsolutePath());
        rootURI = xmlURI.appendSegment(name);
        resource = resourceSet.createResource(rootURI.appendSegment("model.xml"));
        company = Model1Factory.eINSTANCE.createCompany();
        company.setName(name + " company");
        resource.getContents().add((Object)company);
        category = Model1Factory.eINSTANCE.createCategory();
        category.setName(name + " products");
        company.getCategories().add((Object)category);
        i = 0;
        while (i < 3) {
            product = Model1Factory.eINSTANCE.createProduct1();
            product.setName(name + " product " + i);
            category.getProducts().add((Object)product);
            ++i;
        }
        salesOrder = Model1Factory.eINSTANCE.createSalesOrder();
        salesOrder.setCustomer(externalCustomer);
        company.getSalesOrders().add((Object)salesOrder);
        var16_16 = dependencies;
        var15_17 = dependencies.length;
        var14_19 = 0;
        while (var14_19 < var15_17) {
            dependency = var16_16[var14_19];
            dependencyResource = resourceSet.getResource(xmlURI.appendSegment((String)dependency).appendSegment("model.xml"), true);
            dependencyCompany = (Company)dependencyResource.getContents().get(0);
            dependencyCategory = (Category)dependencyCompany.getCategories().get(0);
            category.getTopProducts().addAll((Collection)dependencyCategory.getProducts());
            ++var14_19;
        }
        resource.save(null);
        dependency = null;
        var14_20 = null;
        try {
            in = OM.BUNDLE.getInputStream("META-INF/MANIFEST.MF");
            try {
                out = IOUtil.openOutputStream((String)rootURI.appendSegment("MANIFEST.MF").toFileString());
                try {
                    IOUtil.copy((InputStream)in, (OutputStream)out);
                }
                finally {
                    if (out != null) {
                        out.close();
                    }
                }
                ** if (in == null) goto lbl-1000
            }
            catch (Throwable var14_21) {
                if (dependency == null) {
                    dependency = var14_21;
                } else if (dependency != var14_21) {
                    dependency.addSuppressed(var14_21);
                }
                if (in != null) {
                    in.close();
                }
                throw dependency;
            }
lbl-1000:
            // 1 sources

            {
                in.close();
            }
lbl-1000:
            // 2 sources

            {
            }
        }
        catch (Throwable var14_22) {
            if (dependency == null) {
                dependency = var14_22;
            } else if (dependency != var14_22) {
                dependency.addSuppressed(var14_22);
            }
            throw dependency;
        }
        module = importer.addModule(name, rootURI);
        module.addResource("model.xml").setCopyPath("moved/renamed.xml");
        module.addText("MANIFEST.MF", "UTF-8").setCopyPath("manifest.txt").setStringContentsModifier((UnaryOperator)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$0(java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)());
        return module;
    }

    private static ResourceSet createXMLResourceSet() {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("xml", new XMLResourceFactoryImpl());
        return resourceSet;
    }

    private static /* synthetic */ String lambda$0(String str) {
        return str.replaceAll("org\\.eclipse\\.emf\\.cdo", "CDO");
    }
}

