/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.dictionary;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.catalog.IndexDescriptor;
import org.apache.derby.catalog.types.IndexDescriptorImpl;
import org.apache.derby.iapi.services.context.Context;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.io.Formatable;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptorList;
import org.apache.derby.iapi.sql.execute.ExecIndexRow;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.ExecutionContext;
import org.apache.derby.iapi.sql.execute.ExecutionFactory;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

public class IndexRowGenerator
implements IndexDescriptor,
Formatable {
    private IndexDescriptor id;
    private ExecutionFactory ef;

    public IndexRowGenerator(String indexType, boolean isUnique, boolean isUniqueWithDuplicateNulls, boolean isUniqueDeferrable, boolean hasDeferrableChecking, int[] baseColumnPositions, boolean[] isAscending, int numberOfOrderedColumns) {
        this.id = new IndexDescriptorImpl(indexType, isUnique, isUniqueWithDuplicateNulls, isUniqueDeferrable, hasDeferrableChecking, baseColumnPositions, isAscending, numberOfOrderedColumns);
        SanityManager.ASSERT(baseColumnPositions != null, "baseColumnPositions are null");
    }

    public IndexRowGenerator(IndexDescriptor indexDescriptor) {
        this.id = indexDescriptor;
    }

    public ExecIndexRow getIndexRowTemplate() {
        return this.getExecutionFactory().getIndexableRow(this.id.baseColumnPositions().length + 1);
    }

    public ExecIndexRow getNullIndexRow(ColumnDescriptorList columnList, RowLocation rowLocation) throws StandardException {
        int[] baseColumnPositions = this.id.baseColumnPositions();
        ExecIndexRow indexRow = this.getIndexRowTemplate();
        for (int i = 0; i < baseColumnPositions.length; ++i) {
            DataTypeDescriptor dtd = columnList.elementAt(baseColumnPositions[i] - 1).getType();
            indexRow.setColumn(i + 1, dtd.getNull());
        }
        indexRow.setColumn(baseColumnPositions.length + 1, rowLocation);
        return indexRow;
    }

    public void getIndexRow(ExecRow baseRow, RowLocation rowLocation, ExecIndexRow indexRow, FormatableBitSet bitSet) throws StandardException {
        int[] baseColumnPositions = this.id.baseColumnPositions();
        int colCount = baseColumnPositions.length;
        if (bitSet == null) {
            for (int i = 0; i < colCount; ++i) {
                indexRow.setColumn(i + 1, baseRow.getColumn(baseColumnPositions[i]));
            }
        } else {
            SanityManager.ASSERT(!bitSet.get(0), "element zero of the bitSet passed into getIndexRow() is not false, bitSet should be 1 based");
            for (int i = 0; i < colCount; ++i) {
                int fullColumnNumber = baseColumnPositions[i];
                int partialColumnNumber = 0;
                for (int index = 1; index <= fullColumnNumber; ++index) {
                    if (!bitSet.get(index)) continue;
                    ++partialColumnNumber;
                }
                indexRow.setColumn(i + 1, baseRow.getColumn(partialColumnNumber));
            }
        }
        indexRow.setColumn(colCount + 1, rowLocation);
    }

    public int[] getColumnCollationIds(ColumnDescriptorList columnList) throws StandardException {
        int[] base_cols = this.id.baseColumnPositions();
        int[] collation_ids = new int[base_cols.length + 1];
        for (int i = 0; i < base_cols.length; ++i) {
            collation_ids[i] = columnList.elementAt(base_cols[i] - 1).getType().getCollationType();
        }
        collation_ids[collation_ids.length - 1] = 0;
        return collation_ids;
    }

    public IndexDescriptor getIndexDescriptor() {
        return this.id;
    }

    public IndexRowGenerator() {
    }

    @Override
    public boolean isUniqueWithDuplicateNulls() {
        return this.id.isUniqueWithDuplicateNulls();
    }

    @Override
    public boolean hasDeferrableChecking() {
        return this.id.hasDeferrableChecking();
    }

    @Override
    public boolean isUniqueDeferrable() {
        return this.id.isUniqueDeferrable();
    }

    @Override
    public boolean isUnique() {
        return this.id.isUnique();
    }

    @Override
    public int[] baseColumnPositions() {
        return this.id.baseColumnPositions();
    }

    @Override
    public int getKeyColumnPosition(int heapColumnPosition) {
        return this.id.getKeyColumnPosition(heapColumnPosition);
    }

    @Override
    public int numberOfOrderedColumns() {
        return this.id.numberOfOrderedColumns();
    }

    @Override
    public String indexType() {
        return this.id.indexType();
    }

    public String toString() {
        return this.id.toString();
    }

    @Override
    public boolean isAscending(Integer keyColumnPosition) {
        return this.id.isAscending(keyColumnPosition);
    }

    @Override
    public boolean isDescending(Integer keyColumnPosition) {
        return this.id.isDescending(keyColumnPosition);
    }

    @Override
    public boolean[] isAscending() {
        return this.id.isAscending();
    }

    @Override
    public void setBaseColumnPositions(int[] baseColumnPositions) {
        this.id.setBaseColumnPositions(baseColumnPositions);
    }

    @Override
    public void setIsAscending(boolean[] isAscending) {
        this.id.setIsAscending(isAscending);
    }

    @Override
    public void setNumberOfOrderedColumns(int numberOfOrderedColumns) {
        this.id.setNumberOfOrderedColumns(numberOfOrderedColumns);
    }

    public boolean equals(Object other) {
        return this.id.equals(other);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    private ExecutionFactory getExecutionFactory() {
        if (this.ef == null) {
            ExecutionContext ec = (ExecutionContext)IndexRowGenerator.getContext("ExecutionContext");
            this.ef = ec.getExecutionFactory();
        }
        return this.ef;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = (IndexDescriptor)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.id);
    }

    @Override
    public int getTypeFormatId() {
        return 268;
    }

    private static Context getContext(String contextID) {
        return ContextService.getContext(contextID);
    }
}

