/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.classfile;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.derby.iapi.services.io.AccessibleByteArrayOutputStream;

public final class ClassFormatOutput
extends DataOutputStream {
    public ClassFormatOutput() {
        this(512);
    }

    public ClassFormatOutput(int size) {
        this(new AccessibleByteArrayOutputStream(size));
    }

    public ClassFormatOutput(OutputStream stream) {
        super(stream);
    }

    public void putU1(int i) throws IOException {
        if (i > 255) {
            ClassFormatOutput.limit("U1", 255, i);
        }
        this.write(i);
    }

    public void putU2(int i) throws IOException {
        this.putU2("U2", i);
    }

    public void putU2(String limit, int i) throws IOException {
        if (i > 65535) {
            ClassFormatOutput.limit(limit, 65535, i);
        }
        this.write(i >> 8);
        this.write(i);
    }

    public void putU4(int i) throws IOException {
        this.writeInt(i);
    }

    public void writeTo(OutputStream outTo) throws IOException {
        ((AccessibleByteArrayOutputStream)this.out).writeTo(outTo);
    }

    public byte[] getData() {
        return ((AccessibleByteArrayOutputStream)this.out).getInternalByteArray();
    }

    static void limit(String name, int limit, int value) throws IOException {
        throw new IOException(name + "(" + value + " > " + limit + ")");
    }
}

